/*
 * Decompiled with CFR 0.152.
 */
import java.text.Normalizer;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMISearchResult
implements Comparable<TMISearchResult> {
    public amj stack;
    protected String normalizedName;
    protected int internalDistance;
    protected int firstPosition;
    protected int lastPosition;
    protected static Pattern diacritics = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    protected static Pattern styles = Pattern.compile("\u00a7.");

    protected TMISearchResult() {
    }

    public static TMISearchResult scan(amj amj2, char c) {
        if (amj2 == null) {
            return null;
        }
        List list = amj2.a((ahd)bsu.z().h, true);
        if (list == null || list.size() == 0) {
            return null;
        }
        String string = TMISearchResult.clean((String)list.get(0));
        int n = string.indexOf(c = Character.toLowerCase(c));
        if (n == -1) {
            return null;
        }
        TMISearchResult tMISearchResult = new TMISearchResult();
        tMISearchResult.stack = amj2;
        tMISearchResult.firstPosition = tMISearchResult.lastPosition = n;
        tMISearchResult.internalDistance = 0;
        tMISearchResult.normalizedName = string;
        return tMISearchResult;
    }

    public TMISearchResult scan(char c) {
        int n = this.normalizedName.indexOf(c = Character.toLowerCase(c), this.lastPosition + 1);
        if (n == -1) {
            return null;
        }
        TMISearchResult tMISearchResult = new TMISearchResult();
        tMISearchResult.stack = this.stack;
        tMISearchResult.normalizedName = this.normalizedName;
        tMISearchResult.firstPosition = this.firstPosition;
        tMISearchResult.lastPosition = n;
        tMISearchResult.internalDistance = this.internalDistance + n - this.lastPosition;
        return tMISearchResult;
    }

    @Override
    public int compareTo(TMISearchResult tMISearchResult) {
        return this.internalDistance > tMISearchResult.internalDistance ? 1 : (this.internalDistance < tMISearchResult.internalDistance ? -1 : (this.firstPosition > tMISearchResult.firstPosition ? 1 : (this.firstPosition < tMISearchResult.firstPosition ? -1 : 0)));
    }

    public static String clean(String string) {
        string = TMISearchResult.deaccent(string);
        string = string.toLowerCase();
        string = styles.matcher(string).replaceAll("");
        return string;
    }

    public static String deaccent(String string) {
        try {
            Class.forName("java.text.Normalizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return string;
        }
        String string2 = Normalizer.normalize(string, Normalizer.Form.NFD);
        return diacritics.matcher(string2).replaceAll("");
    }
}

