/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMIFuzzySearch {
    private List<amj> baseItems;
    private String lastQuery;
    private Deque<List<TMISearchResult>> resultStack = new LinkedList<List<TMISearchResult>>();

    public TMIFuzzySearch(List<amj> list) {
        this.baseItems = list;
    }

    public List<amj> query(String string) {
        if (string == null || string.equals("")) {
            return this.baseItems;
        }
        if (this.lastQuery != null && this.lastQuery.startsWith(string)) {
            for (int i = 0; i < this.lastQuery.length() - string.length(); ++i) {
                this.resultStack.pollLast();
            }
            return this.getResults();
        }
        int n = 0;
        if (this.lastQuery == null || !string.startsWith(this.lastQuery)) {
            while (this.resultStack.pollLast() != null) {
            }
        } else {
            n = this.lastQuery.length();
        }
        for (int i = n; i < string.length(); ++i) {
            this.pushQuery(string.charAt(i));
        }
        return this.getResults();
    }

    public List<amj> getResults() {
        ArrayList<amj> arrayList = new ArrayList<amj>();
        List<TMISearchResult> list = this.resultStack.peekLast();
        if (list == null) {
            return null;
        }
        for (TMISearchResult tMISearchResult : list) {
            arrayList.add(tMISearchResult.stack);
        }
        return arrayList;
    }

    private void pushQuery(char c) {
        ArrayList<TMISearchResult> arrayList = new ArrayList<TMISearchResult>();
        List<TMISearchResult> list = this.resultStack.peekLast();
        if (list == null) {
            for (amj amj2 : this.baseItems) {
                TMISearchResult tMISearchResult = TMISearchResult.scan(amj2, c);
                if (tMISearchResult == null) continue;
                arrayList.add(tMISearchResult);
            }
        } else {
            for (TMISearchResult tMISearchResult : list) {
                TMISearchResult tMISearchResult2 = tMISearchResult.scan(c);
                if (tMISearchResult2 == null) continue;
                arrayList.add(tMISearchResult2);
            }
        }
        Collections.sort(arrayList);
        this.resultStack.addLast(arrayList);
    }
}

