/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMICustomEnchantPanel
extends TMIArea {
    private TMIItemButton itemButton = new TMIItemButton(new TMIStackBuilder("diamond_pickaxe").stack(), true);
    private TMITextField nameField = new TMITextField();
    private List<TMIEnchantField> enchantFields = new ArrayList<TMIEnchantField>();
    private int page = 0;
    private int fieldsMargin = 44;

    public TMICustomEnchantPanel() {
        this.addChild(this.itemButton);
        this.addChild(this.nameField);
        this.nameField.placeholder = "Name...";
        this.nameField.addEventListener(this);
        this.itemButton.addEventListener(this);
        this.updateFromItem();
    }

    private void updateFromItem() {
        Object object;
        this.blurFocused();
        this.enchantFields.clear();
        fn fn2 = new TMIStackBuilder(this.itemButton.stack).tag();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        if (fn2.c("ench")) {
            fv fv2 = fn2.c("ench", 10);
            for (int i = 0; i < fv2.c(); ++i) {
                try {
                    object = (fn)fv2.g(i);
                    hashMap.put(Integer.valueOf(object.e("id")), Integer.valueOf(object.e("lvl")));
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        for (apf apf2 : this.enchantmentsForItem(this.itemButton.stack)) {
            object = new TMIEnchantField(apf2, this.itemButton.stack);
            ((TMIArea)object).addEventListener(this);
            this.enchantFields.add((TMIEnchantField)object);
            if (!hashMap.containsKey(apf2.B)) continue;
            ((TMINumField)object).setValue("" + hashMap.get(apf2.B));
        }
    }

    private void recreateItem() {
        TMIStackBuilder tMIStackBuilder = new TMIStackBuilder(this.itemButton.stack).clearEnch().clearName();
        for (TMIEnchantField tMIEnchantField : this.enchantFields) {
            int n = tMIEnchantField.intValue();
            if (n <= 0) continue;
            tMIStackBuilder.ench(tMIEnchantField.ench, n);
        }
        if (!this.nameField.value().equals("")) {
            tMIStackBuilder.name(this.nameField.value());
        }
        this.itemButton.stack = tMIStackBuilder.stack();
        this.layoutComponent();
    }

    private void fixPage() {
        int n;
        this.removeChildrenOfType(TMIEnchantField.class);
        int n2 = (this.height - this.fieldsMargin - 4) / 16;
        int n3 = (int)Math.ceil((float)this.enchantFields.size() / (float)n2);
        while (this.page < 0) {
            this.page += n3;
        }
        this.page %= n3;
        for (int i = n = n2 * this.page; i < n + n2 && i < this.enchantFields.size(); ++i) {
            this.addChild(this.enchantFields.get(i));
        }
    }

    @Override
    public void layoutComponent() {
        this.fixPage();
        this.itemButton.setPosition(this.x + this.width / 2 - 8, this.y + 4);
        this.nameField.setSize(this.width - 4, 12);
        this.nameField.setPosition(this.x + 2, this.y + 4 + 16 + 4);
        int n = this.y + this.fieldsMargin;
        for (TMIArea tMIArea : this.children) {
            if (!(tMIArea instanceof TMIEnchantField)) continue;
            tMIArea.setSize(this.width - 4, 14);
            tMIArea.setPosition(this.x + 2, n);
            n += 16;
        }
    }

    private List<apf> enchantmentsForItem(final amj amj2) {
        List<apf> list = Arrays.asList(apf.b);
        Collections.sort(list, new Comparator<apf>(){

            @Override
            public int compare(apf apf2, apf apf3) {
                boolean bl;
                boolean bl2 = apf2.C.a(amj2.b());
                if (bl2 == (bl = apf3.C.a(amj2.b()))) {
                    return fi.a((String)apf2.a()).compareTo(fi.a((String)apf3.a()));
                }
                if (bl) {
                    return 1;
                }
                return -1;
            }
        });
        return list;
    }

    @Override
    public void mouseEvent(TMIEvent tMIEvent) {
        if (tMIEvent.type == 2) {
            this.page -= tMIEvent.wheel;
            this.layoutComponent();
            tMIEvent.cancel();
        }
    }

    @Override
    public void controlEvent(TMIEvent tMIEvent) {
        if (tMIEvent.type == 4 && tMIEvent.target == this.itemButton) {
            this.updateFromItem();
            this.layoutComponent();
        } else if (tMIEvent.type == 3) {
            this.recreateItem();
        }
    }

    @Override
    public void keyboardEvent(TMIEvent tMIEvent) {
        if (tMIEvent.keyCode == 15) {
            if (this.getFocused() == null) {
                this.nameField.focus();
            } else {
                int n = this.children.indexOf(this.getFocused());
                if (n == -1) {
                    this.nameField.focus();
                } else if (n + 1 == this.children.size()) {
                    ++this.page;
                    this.layoutComponent();
                    for (TMIArea tMIArea : this.children) {
                        if (!(tMIArea instanceof TMIEnchantField)) continue;
                        tMIArea.focus();
                        break;
                    }
                } else {
                    ((TMIArea)this.children.get(n + 1)).focus();
                }
            }
            tMIEvent.cancel();
        }
    }
}

