/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lwjgl.input.Keyboard;

public class TMIConfigFile {
    public static final String filename = "TooManyItems.txt";
    public static final int numSaves = 7;
    private static Map<String, String> settings = new LinkedHashMap<String, String>();

    public static File file() {
        return new File(bsu.z().v, filename);
    }

    public static boolean read() {
        try {
            String string;
            File file = TMIConfigFile.file();
            if (!file.exists()) {
                return false;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(":", 2);
                if (stringArray.length <= 1) continue;
                settings.put(stringArray[0], stringArray[1]);
            }
            bufferedReader.close();
            return true;
        }
        catch (Throwable throwable) {
            TMIDebug.reportException(throwable);
            return false;
        }
    }

    public static void write() {
        try {
            File file = TMIConfigFile.file();
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (String string : settings.keySet()) {
                printWriter.println(string + ":" + settings.get(string));
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            TMIDebug.reportException(throwable);
        }
    }

    public static int getHotkey() {
        String string = settings.get("key");
        int n = 0;
        n = Keyboard.getKeyIndex((String)string.toUpperCase());
        if (n == 0) {
            n = 24;
        }
        return n;
    }

    public static void set(String string, String string2) {
        settings.put(string, string2);
        TMIConfigFile.write();
    }

    public static boolean getBooleanSetting(String string) {
        return Boolean.parseBoolean(settings.get(string));
    }

    public static boolean isEnabled() {
        return TMIConfigFile.getBooleanSetting("enable");
    }

    public static void toggleEnabled() {
        TMIConfigFile.set("enable", Boolean.toString(!TMIConfigFile.getBooleanSetting("enable")));
    }

    public static void setEnabled(boolean bl) {
        TMIConfigFile.set("enable", Boolean.toString(bl));
    }

    public static String getSaveName(int n) {
        String string = settings.get("save-name" + (n + 1));
        return string != null ? string : "" + (n + 1);
    }

    public static void setSaveName(int n, String string) {
        TMIConfigFile.set("save-name" + (n + 1), string);
    }

    static {
        settings.put("enable", "true");
        settings.put("give-command", "/give {0} {1} {2} {3}");
        settings.put("give-command-num-id", "false");
        settings.put("key", "o");
        for (int i = 0; i < 7; ++i) {
            settings.put("save-name" + (i + 1), "" + (i + 1));
        }
    }
}

