/*
 * Decompiled with CFR 0.152.
 */
package allthelayers.candles.init.candles.biglight4;

import allthelayers.candles.init.blocks.ATLCraftBlocksAreaLights;
import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ATLCraftBigLight4SuperTorch
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(EnumFacing p_apply_1_) {
            return p_apply_1_ != EnumFacing.DOWN;
        }
    });
    protected static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB((double)0.4f, 0.0, (double)0.4f, (double)0.6f, (double)0.6f, (double)0.6f);
    protected static final AxisAlignedBB TORCH_NORTH_AABB = new AxisAlignedBB((double)0.35f, (double)0.2f, (double)0.7f, (double)0.65f, (double)0.8f, 1.0);
    protected static final AxisAlignedBB TORCH_SOUTH_AABB = new AxisAlignedBB((double)0.35f, (double)0.2f, 0.0, (double)0.65f, (double)0.8f, (double)0.3f);
    protected static final AxisAlignedBB TORCH_WEST_AABB = new AxisAlignedBB((double)0.7f, (double)0.2f, (double)0.35f, 1.0, (double)0.8f, (double)0.65f);
    protected static final AxisAlignedBB TORCH_EAST_AABB = new AxisAlignedBB(0.0, (double)0.2f, (double)0.35f, (double)0.3f, (double)0.8f, (double)0.65f);

    public ATLCraftBigLight4SuperTorch() {
        this(Material.field_151594_q.func_151565_r());
    }

    public ATLCraftBigLight4SuperTorch(MapColor color) {
        super(Material.field_151594_q, color);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return TORCH_EAST_AABB;
            }
            case WEST: {
                return TORCH_WEST_AABB;
            }
            case SOUTH: {
                return TORCH_SOUTH_AABB;
            }
            case NORTH: {
                return TORCH_NORTH_AABB;
            }
        }
        return STANDING_AABB;
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP)) {
            return true;
        }
        return true;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        boolean flag = facing.func_176740_k().func_176722_c();
        return flag && worldIn.isSideSolid(blockpos, facing, true) || facing.equals((Object)EnumFacing.UP) && this.canPlaceOn(worldIn, blockpos);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!worldIn.isSideSolid(pos.func_177972_a(enumfacing.func_176734_d()), enumfacing, true)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public void onBlockAdded1(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    protected boolean onNeighborChangeInternal(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.checkForDrop(worldIn, pos, state)) {
            return true;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing.Axis enumfacing$axis = enumfacing.func_176740_k();
        EnumFacing enumfacing1 = enumfacing.func_176734_d();
        boolean flag = false;
        if (enumfacing$axis.func_176722_c() && !worldIn.isSideSolid(pos.func_177972_a(enumfacing1), enumfacing, true)) {
            flag = true;
        } else if (enumfacing$axis.func_176720_b() && !this.canPlaceOn(worldIn, pos.func_177972_a(enumfacing1))) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return true;
        }
        return false;
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState worldIn, World pos, BlockPos state, Random rand) {
        EnumFacing enumfacing = (EnumFacing)worldIn.func_177229_b((IProperty)FACING);
        double d0 = (double)state.func_177958_n() + 0.5;
        double d1 = (double)state.func_177956_o() + 0.7;
        double d2 = (double)state.func_177952_p() + 0.5;
        double d3 = 0.01;
        double d4 = 0.37;
        if (enumfacing.func_176740_k().func_176722_c()) {
            EnumFacing enumfacing1 = enumfacing.func_176734_d();
            pos.func_175688_a(EnumParticleTypes.FLAME, d0 + d4 * (double)enumfacing1.func_82601_c(), d1 + d3, d2 + d4 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            pos.func_175688_a(EnumParticleTypes.SPELL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            return;
        }
        pos.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        pos.func_175688_a(EnumParticleTypes.SPELL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        switch (meta) {
            case 1: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
                break;
            }
            case 2: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
                break;
            }
            case 3: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
                break;
            }
            case 4: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
                break;
            }
            default: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
            }
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                i |= 1;
                break;
            }
            case WEST: {
                i |= 2;
                break;
            }
            case SOUTH: {
                i |= 3;
                break;
            }
            case NORTH: {
                i |= 4;
                break;
            }
            default: {
                i |= 5;
            }
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public int func_149679_a(int fortune, Random random) {
        if (fortune > 0 && Item.func_150898_a((Block)this) != this.func_180660_a((IBlockState)this.func_176194_O().func_177619_a().iterator().next(), random, fortune)) {
            int i = random.nextInt(fortune + 2) - 1;
            if (i < 0) {
                i = 0;
            }
            return this.func_149745_a(random) * (i + 1);
        }
        return this.func_149745_a(random);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(worldIn, pos, state, chance, fortune);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        Random rand;
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        if (this.func_180660_a(state, rand, fortune) != Item.func_150898_a((Block)this)) {
            int i = 0;
            i = MathHelper.func_76136_a((Random)rand, (int)2, (int)5);
            return i;
        }
        return 0;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.checkFallable(worldIn, pos);
        }
    }

    private void checkFallable(World worldIn, BlockPos pos) {
        float var4 = 1.0f;
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        if (worldIn.func_175623_d(pos.func_177977_b()) && pos.func_177956_o() >= 0) {
            worldIn.func_175656_a(pos.func_177977_b(), ATLCraftBlocksAreaLights.atlcraft_biglight4gag1.func_176223_P());
        }
        if (worldIn.func_175623_d(pos.func_177984_a()) && pos.func_177956_o() >= 0) {
            worldIn.func_175656_a(pos.func_177984_a(), ATLCraftBlocksAreaLights.atlcraft_biglight4gag1.func_176223_P());
        }
        if (worldIn.func_175623_d(pos.func_177978_c()) && pos.func_177956_o() >= 0) {
            worldIn.func_175656_a(pos.func_177978_c(), ATLCraftBlocksAreaLights.atlcraft_biglight4gag1.func_176223_P());
        }
        if (worldIn.func_175623_d(pos.func_177968_d()) && pos.func_177956_o() >= 0) {
            worldIn.func_175656_a(pos.func_177968_d(), ATLCraftBlocksAreaLights.atlcraft_biglight4gag1.func_176223_P());
        }
        if (worldIn.func_175623_d(pos.func_177974_f()) && pos.func_177956_o() >= 0) {
            worldIn.func_175656_a(pos.func_177974_f(), ATLCraftBlocksAreaLights.atlcraft_biglight4gag1.func_176223_P());
        }
        if (worldIn.func_175623_d(pos.func_177976_e()) && pos.func_177956_o() >= 0) {
            worldIn.func_175656_a(pos.func_177976_e(), ATLCraftBlocksAreaLights.atlcraft_biglight4gag1.func_176223_P());
        }
    }

    public static boolean func_185759_i(IBlockState p_185759_0_) {
        Block block = p_185759_0_.func_177230_c();
        Material material = p_185759_0_.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }
}

