/*
 * Decompiled with CFR 0.152.
 */
package allthelayers.candles.init.candles;

import allthelayers.candles.init.blocks.ATLCraftBlocks;
import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ATLCraftCandle07lightblue
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(EnumFacing p_apply_1_) {
            return p_apply_1_ != EnumFacing.DOWN;
        }
    });
    protected static final AxisAlignedBB field_185738_b = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.19, 0.75);
    protected static final AxisAlignedBB TORCH_NORTH_AABB = new AxisAlignedBB(0.25, 0.1, 0.45, 0.75, 0.95, 1.0);
    protected static final AxisAlignedBB TORCH_SOUTH_AABB = new AxisAlignedBB(0.25, 0.1, 0.0, 0.75, 0.95, 0.55);
    protected static final AxisAlignedBB TORCH_WEST_AABB = new AxisAlignedBB(0.45, 0.1, 0.25, 1.0, 0.95, 0.75);
    protected static final AxisAlignedBB TORCH_EAST_AABB = new AxisAlignedBB(0.0, 0.1, 0.25, 0.55, 0.95, 0.75);

    public ATLCraftCandle07lightblue() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return TORCH_EAST_AABB;
            }
            case WEST: {
                return TORCH_WEST_AABB;
            }
            case SOUTH: {
                return TORCH_SOUTH_AABB;
            }
            case NORTH: {
                return TORCH_NORTH_AABB;
            }
        }
        return field_185738_b;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP)) {
            return true;
        }
        return true;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        boolean flag = facing.func_176740_k().func_176722_c();
        return flag && worldIn.isSideSolid(blockpos, facing, true) || facing.equals((Object)EnumFacing.UP) && this.canPlaceOn(worldIn, blockpos);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!worldIn.isSideSolid(pos.func_177972_a(enumfacing.func_176734_d()), enumfacing, true)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    protected boolean onNeighborChangeInternal(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.checkForDrop(worldIn, pos, state)) {
            return true;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing.Axis enumfacing$axis = enumfacing.func_176740_k();
        EnumFacing enumfacing1 = enumfacing.func_176734_d();
        boolean flag = false;
        if (enumfacing$axis.func_176722_c() && !worldIn.isSideSolid(pos.func_177972_a(enumfacing1), enumfacing, true)) {
            flag = true;
        } else if (enumfacing$axis.func_176720_b() && !this.canPlaceOn(worldIn, pos.func_177972_a(enumfacing1))) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return true;
        }
        return false;
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState worldIn, World pos, BlockPos state, Random rand) {
        EnumFacing enumfacing = (EnumFacing)worldIn.func_177229_b((IProperty)FACING);
        double d0 = (double)state.func_177958_n() + 0.5;
        double d1 = (double)state.func_177956_o() + 0.27;
        double d2 = (double)state.func_177952_p() + 0.5;
        double d3 = 0.05;
        double d4 = 0.2;
        if (enumfacing.func_176740_k().func_176722_c()) {
            EnumFacing enumfacing1 = enumfacing.func_176734_d();
            pos.func_175688_a(EnumParticleTypes.FLAME, d0 + d4 * (double)enumfacing1.func_82601_c(), d1 + d3, d2 + d4 * (double)enumfacing1.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
            return;
        }
        pos.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        switch (meta) {
            case 1: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
                break;
            }
            case 2: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
                break;
            }
            case 3: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
                break;
            }
            case 4: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
                break;
            }
            default: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
            }
        }
        return iblockstate;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                i |= 1;
                break;
            }
            case WEST: {
                i |= 2;
                break;
            }
            case SOUTH: {
                i |= 3;
                break;
            }
            case NORTH: {
                i |= 4;
                break;
            }
            default: {
                i |= 5;
            }
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        this.onNeighborChangeInternal(worldIn, pos, state);
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.checkCeilingChange(worldIn, pos);
        }
    }

    private void checkCeilingChange(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150355_j || worldIn.func_180495_p(pos.func_177978_c()).func_177230_c() == Blocks.field_150355_j || worldIn.func_180495_p(pos.func_177968_d()).func_177230_c() == Blocks.field_150355_j || worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() == Blocks.field_150355_j || worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_150355_j || worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150353_l || worldIn.func_180495_p(pos.func_177978_c()).func_177230_c() == Blocks.field_150353_l || worldIn.func_180495_p(pos.func_177968_d()).func_177230_c() == Blocks.field_150353_l || worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() == Blocks.field_150353_l || worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_150353_l) {
            worldIn.func_175698_g(pos);
            IBlockState state = null;
            this.func_176226_b(worldIn, pos, state, 0);
            return;
        }
        if (!worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151585_k && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151586_h && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151587_i && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150480_ab && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151569_G && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151593_r && pos.func_177956_o() >= 0 && (worldIn.func_175623_d(pos.func_177977_b()) || worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151585_k || worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151587_i || worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150480_ab || worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151593_r || worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151569_G) && (worldIn.func_175623_d(pos.func_177978_c()) || worldIn.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151585_k || worldIn.func_180495_p(pos.func_177978_c()).func_177230_c() instanceof BlockFence || worldIn.func_180495_p(pos.func_177978_c()).func_177230_c() instanceof BlockWall) && (worldIn.func_175623_d(pos.func_177968_d()) || worldIn.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151585_k || worldIn.func_180495_p(pos.func_177968_d()).func_177230_c() instanceof BlockFence || worldIn.func_180495_p(pos.func_177968_d()).func_177230_c() instanceof BlockWall) && (worldIn.func_175623_d(pos.func_177974_f()) || worldIn.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151585_k || worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() instanceof BlockFence || worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() instanceof BlockWall) && (worldIn.func_175623_d(pos.func_177976_e()) || worldIn.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151585_k || worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() instanceof BlockFence || worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() instanceof BlockWall) && worldIn.func_180495_p(pos).func_177230_c() == ATLCraftBlocks.atlcraft_candle07_lightblue) {
            worldIn.func_175698_g(pos);
            worldIn.func_175656_a(pos, ATLCraftBlocks.atlcraft_candle07_lightblue_ceiling.func_176223_P());
            return;
        }
    }

    public static boolean func_185759_i(IBlockState p_185759_0_) {
        Block block = p_185759_0_.func_177230_c();
        Material material = p_185759_0_.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }
}

