/*
 * Decompiled with CFR 0.152.
 */
package allthelayers.candles.init.blocks.climbable;

import allthelayers.candles.init.blocks.ATLCraftBlocksDecorations;
import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ATLCraftDecoBlockClimbableVineLong
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(EnumFacing p_apply_1_) {
            return p_apply_1_ != EnumFacing.UP;
        }
    });
    protected static final AxisAlignedBB LADDER_DOWN_AABB = new AxisAlignedBB(0.47, 0.0, 0.47, 0.53, 1.0, 0.53);
    protected static final AxisAlignedBB LADDER_EAST_AABB = new AxisAlignedBB(0.47, 0.0, 0.47, 0.53, 1.0, 0.53);
    protected static final AxisAlignedBB LADDER_WEST_AABB = new AxisAlignedBB(0.47, 0.0, 0.47, 0.53, 1.0, 0.53);
    protected static final AxisAlignedBB LADDER_SOUTH_AABB = new AxisAlignedBB(0.47, 0.0, 0.47, 0.53, 1.0, 0.53);
    protected static final AxisAlignedBB LADDER_NORTH_AABB = new AxisAlignedBB(0.47, 0.0, 0.47, 0.53, 1.0, 0.53);

    public ATLCraftDecoBlockClimbableVineLong() {
        super(Material.field_151594_q);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case DOWN: {
                return LADDER_DOWN_AABB;
            }
            case NORTH: {
                return LADDER_NORTH_AABB;
            }
            case SOUTH: {
                return LADDER_SOUTH_AABB;
            }
            case WEST: {
                return LADDER_WEST_AABB;
            }
        }
        return LADDER_EAST_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.DOWN)) {
            return true;
        }
        return true;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        boolean flag = facing.func_176740_k().func_176722_c();
        return worldIn.isSideSolid(blockpos, facing, true) || facing.equals((Object)EnumFacing.DOWN) && this.canPlaceOn(worldIn, blockpos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.checkDropRope(worldIn, pos);
        }
    }

    private void checkDropRope(World worldIn, BlockPos pos) {
        if ((worldIn.func_175623_d(pos.func_177984_a()) || worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151585_k || worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151587_i || worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151586_h || worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150480_ab || worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151593_r || worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151569_G || ATLCraftDecoBlockClimbableVineLong.func_185759_i(worldIn.func_180495_p(pos.func_177984_a()))) && pos.func_177956_o() >= 0) {
            IBlockState state = this.func_176223_P();
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return;
        }
        if ((worldIn.func_175623_d(pos.func_177977_b()) || worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151585_k || ATLCraftDecoBlockClimbableVineLong.func_185759_i(worldIn.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0 && !worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150480_ab && worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151586_h && worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151587_i && worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151593_r && worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151569_G) {
            worldIn.func_175656_a(pos.func_177977_b(), ATLCraftBlocksDecorations.atlcraft_climbablevine1_longbottom.func_176223_P());
            return;
        }
    }

    public static boolean func_185759_i(IBlockState p_185759_0_) {
        Block block = p_185759_0_.func_177230_c();
        Material material = p_185759_0_.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }
}

