/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.world.noise;

public final class Voronoi {
    private static final double SQRT_3 = Math.sqrt(3.0);
    public static final double DEFAULT_VORONOI_DISPLACEMENT = 1.0;
    public static final double DEFAULT_VORONOI_FREQUENCY = 1.0;
    public static final int DEFAULT_VORONOI_SEED = 0;
    private double displacement = 1.0;
    private boolean enableDistance = false;
    private double frequency = 1.0;
    private int seed = 0;
    private static final int X_NOISE_GEN = 1619;
    private static final int Y_NOISE_GEN = 31337;
    private static final int Z_NOISE_GEN = 6971;
    private static final int SEED_NOISE_GEN = 1013;

    public double getDisplacement() {
        return this.displacement;
    }

    public void setDisplacement(double displacement) {
        this.displacement = displacement;
    }

    public boolean isEnableDistance() {
        return this.enableDistance;
    }

    public void setEnableDistance(boolean enableDistance) {
        this.enableDistance = enableDistance;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public double getValue(double x, double y, double z) {
        double value;
        double x1 = x;
        double y1 = y;
        double z1 = z;
        int xInt = x1 > 0.0 ? (int)x1 : (int)(x1 *= this.frequency) - 1;
        int yInt = y1 > 0.0 ? (int)y1 : (int)(y1 *= this.frequency) - 1;
        int zInt = z1 > 0.0 ? (int)z1 : (int)(z1 *= this.frequency) - 1;
        double minDist = 2.147483647E9;
        double xCandidate = 0.0;
        double yCandidate = 0.0;
        double zCandidate = 0.0;
        for (int zCur = zInt - 2; zCur <= zInt + 2; ++zCur) {
            for (int yCur = yInt - 2; yCur <= yInt + 2; ++yCur) {
                for (int xCur = xInt - 2; xCur <= xInt + 2; ++xCur) {
                    double zPos;
                    double zDist;
                    double yPos;
                    double yDist;
                    double xPos = (double)xCur + Voronoi.valueNoise3D(xCur, yCur, zCur, this.seed);
                    double xDist = xPos - x1;
                    double dist = xDist * xDist + (yDist = (yPos = (double)yCur + Voronoi.valueNoise3D(xCur, yCur, zCur, this.seed + 1)) - y1) * yDist + (zDist = (zPos = (double)zCur + Voronoi.valueNoise3D(xCur, yCur, zCur, this.seed + 2)) - z1) * zDist;
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    xCandidate = xPos;
                    yCandidate = yPos;
                    zCandidate = zPos;
                }
            }
        }
        if (this.enableDistance) {
            double xDist = xCandidate - x1;
            double yDist = yCandidate - y1;
            double zDist = zCandidate - z1;
            value = Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist) * SQRT_3 - 1.0;
        } else {
            value = 0.0;
        }
        return value + this.displacement * Voronoi.valueNoise3D(Voronoi.floor(xCandidate), Voronoi.floor(yCandidate), Voronoi.floor(zCandidate), this.seed);
    }

    public static int floor(double x) {
        int y = (int)x;
        if (x < (double)y) {
            return y - 1;
        }
        return y;
    }

    public static int intValueNoise3D(int x, int y, int z, int seed) {
        int n = 1619 * x + 31337 * y + 6971 * z + 1013 * seed & Integer.MAX_VALUE;
        n = n >> 13 ^ n;
        return n * (n * n * 60493 + 19990303) + 1376312589 & Integer.MAX_VALUE;
    }

    public static double valueNoise3D(int x, int y, int z, int seed) {
        return 1.0 - (double)Voronoi.intValueNoise3D(x, y, z, seed) / 1.073741824E9;
    }
}

