/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.world;

import exterminatorjeff.undergroundbiomes.api.UBBiome;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumn;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumnProvider;
import exterminatorjeff.undergroundbiomes.api.UndergroundBiomeSet;
import exterminatorjeff.undergroundbiomes.api.common.UBLogger;
import exterminatorjeff.undergroundbiomes.api.enums.UBStoneStyle;
import exterminatorjeff.undergroundbiomes.common.block.UBStone;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBStoneSlab;
import exterminatorjeff.undergroundbiomes.common.block.stairs.UBStoneStairs;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import exterminatorjeff.undergroundbiomes.intermod.StonesRegistry;
import exterminatorjeff.undergroundbiomes.world.TraditionalStoneReplacer;
import exterminatorjeff.undergroundbiomes.world.UBBiomesSet;
import exterminatorjeff.undergroundbiomes.world.UBStoneReplacer;
import exterminatorjeff.undergroundbiomes.world.noise.SimplexNoiseGenerator;
import exterminatorjeff.undergroundbiomes.world.noise.Voronoi;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public final class WorldGenManager
implements UBStrataColumnProvider {
    private final UBLogger LOGGER;
    private final int dimensionID;
    private final UndergroundBiomeSet biomesSet;
    private final int biomeSize;
    private UBStoneReplacer stoneReplacer;
    private boolean worldLoaded = false;
    private World world;
    private int seed;
    private SimplexNoiseGenerator simplex;
    private Voronoi voronoi;
    private BlockPos pos;
    private boolean hasChanged = false;
    private UBBiome currentBiome;

    public WorldGenManager(int dimensionID) {
        this.LOGGER = new UBLogger(WorldGenManager.class + " " + dimensionID, Level.INFO);
        this.LOGGER.debug("Dimension " + dimensionID + " will be UBified");
        this.dimensionID = dimensionID;
        this.biomesSet = new UBBiomesSet(UBConfig.SPECIFIC);
        this.biomeSize = UBConfig.SPECIFIC.biomeSize();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.world = event.getWorld();
        this.world.func_72860_G().func_75765_b();
        if (this.world.field_73011_w.getDimension() == this.dimensionID && !this.worldLoaded) {
            this.LOGGER.debug("Dimension " + this.dimensionID + " loaded");
            this.worldLoaded = true;
            this.seed = (int)this.world.func_72905_C();
            if (UBConfig.SPECIFIC.dimensionSpecificSeeds()) {
                this.seed += this.dimensionID;
            }
            this.stoneReplacer = new TraditionalStoneReplacer(this.seed, UBConfig.SPECIFIC.biomeSize(), this.biomesSet);
            this.simplex = new SimplexNoiseGenerator(this.seed);
            this.voronoi = new Voronoi();
            this.voronoi.setSeed(this.seed);
            this.voronoi.setFrequency(0.05 / (double)this.biomeSize);
        }
    }

    private double perlinNoise(int xPos, int zPos) {
        double var = 0.0;
        var += this.simplex.noise((double)xPos, (double)zPos, 2, 0.005, 1000.0, true) * 4.0;
        var += this.simplex.noise((double)xPos, (double)zPos, 2, 0.025, 1000.0, true);
        return var /= 5.0;
    }

    private UBBiome blockBiomeValue(int xPos, int zPos) {
        return this.stoneReplacer.UBBiomeAt(xPos, zPos);
    }

    @SubscribeEvent
    public void onPopulateChunkPost(PopulateChunkEvent.Post event) {
        if (event.getWorld().field_73011_w.getDimension() == this.dimensionID && this.worldLoaded) {
            Chunk chunk = event.getWorld().func_72964_e(event.getChunkX(), event.getChunkZ());
            this.stoneReplacer.replaceStoneInChunk(chunk);
            this.stoneReplacer.redoOres(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onGenerateMinable(OreGenEvent.GenerateMinable event) {
        if (event.getWorld().field_73011_w.getDimension() == this.dimensionID && this.worldLoaded) {
            switch (event.getType()) {
                case GRANITE: 
                case DIORITE: 
                case ANDESITE: {
                    event.setResult(Event.Result.DENY);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onVillageSelectBlock(BiomeEvent.GetVillageBlockID event) {
        IBlockState originalState = event.getOriginal();
        Block originalBlock = originalState.func_177230_c();
        if (this.hasChanged) {
            this.currentBiome = this.blockBiomeValue(this.pos.func_177958_n(), this.pos.func_177952_p());
            this.hasChanged = false;
        }
        if (this.currentBiome == null) {
            return;
        }
        if (this.currentBiome.filler.func_177230_c() instanceof UBStone) {
            UBStone stone = (UBStone)this.currentBiome.filler.func_177230_c();
            if (originalBlock.equals(Blocks.field_150347_e)) {
                event.setReplacement(((UBStone)StonesRegistry.INSTANCE.stoneFor(stone.getStoneType(), UBStoneStyle.COBBLE).getBlock()).func_176203_a(this.currentBiome.meta));
            } else if (originalBlock == Blocks.field_150446_ar) {
                EnumFacing facing = (EnumFacing)originalState.func_177229_b((IProperty)BlockStairs.field_176309_a);
                event.setReplacement(((UBStoneStairs)StonesRegistry.INSTANCE.stairsFor(stone.getStoneType(), UBStoneStyle.COBBLE).getBlock(facing)).func_176203_a(this.currentBiome.meta));
            } else if (originalBlock == Blocks.field_150333_U) {
                BlockSlab.EnumBlockHalf half = (BlockSlab.EnumBlockHalf)originalState.func_177229_b((IProperty)BlockSlab.field_176554_a);
                event.setReplacement(((UBStoneSlab)StonesRegistry.INSTANCE.slabFor(stone.getStoneType(), UBStoneStyle.STONE).getHalfSlab()).func_176203_a(this.currentBiome.meta).func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)half));
            } else if (originalBlock == Blocks.field_150334_T) {
                event.setReplacement(((UBStoneSlab)StonesRegistry.INSTANCE.slabFor(stone.getStoneType(), UBStoneStyle.STONE).getFullSlab()).func_176203_a(this.currentBiome.meta));
            }
            if (event.getReplacement() == null) {
                // empty if block
            }
            if (event.getReplacement() != null && event.getReplacement().func_177230_c().equals(Blocks.field_150347_e)) {
                throw new RuntimeException();
            }
            if (event.getResult().equals((Object)Event.Result.DENY)) {
                throw new RuntimeException();
            }
            if (event.getReplacement() != null) {
                event.setResult(Event.Result.DENY);
                this.LOGGER.trace("Replaced village block " + originalBlock.getRegistryName() + " with " + event.getReplacement().func_177230_c().getRegistryName());
            } else {
                if (event.getOriginal().func_177230_c() == Blocks.field_150376_bx) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150364_r) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150344_f) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150333_U) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150334_T) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150410_aZ) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150350_a) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150478_aa) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150343_Z) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150452_aw) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150342_X) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150486_ae) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150462_ai) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150460_al) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150411_aY) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150353_l) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_180407_aO) {
                    return;
                }
                if (event.getOriginal().func_177230_c() instanceof BlockDoor) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150476_ad) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150346_d) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150464_aj) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150459_bM) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150469_bN) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150458_ak) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150355_j) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150468_ap) {
                    return;
                }
                if (event.getOriginal().func_177230_c() instanceof BlockColored) {
                    return;
                }
                if (event.getOriginal().func_177230_c() instanceof BlockDynamicLiquid) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_185774_da) {
                    return;
                }
                if (event.getOriginal().func_177230_c() == Blocks.field_150351_n) {
                    return;
                }
                if (originalBlock instanceof UBStone) {
                    return;
                }
                throw new RuntimeException(event.getOriginal().func_177230_c().toString());
            }
        }
    }

    @SubscribeEvent
    public void initMapGen(InitMapGenEvent event) {
        if (event.getType() == InitMapGenEvent.EventType.VILLAGE) {
            event.setNewGen((MapGenBase)new MapGenVillage(){

                public StructureStart func_75049_b(int chunkX, int chunkZ) {
                    WorldGenManager.this.LOGGER.debug("Village start in chunk: " + chunkX + ";" + chunkZ);
                    WorldGenManager.this.pos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
                    WorldGenManager.this.hasChanged = true;
                    return super.func_75049_b(chunkX, chunkZ);
                }
            });
            event.setResult(Event.Result.DENY);
        }
    }

    @Override
    public UBStrataColumn strataColumn(int x, int z) {
        return this.stoneReplacer.strataColumn(x, z);
    }
}

