/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.world;

import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.api.StrataLayer;
import exterminatorjeff.undergroundbiomes.api.UBBiome;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumn;
import exterminatorjeff.undergroundbiomes.api.UBStrataColumnProvider;
import exterminatorjeff.undergroundbiomes.common.block.UBStone;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import exterminatorjeff.undergroundbiomes.intermod.OresRegistry;
import exterminatorjeff.undergroundbiomes.world.noise.NoiseGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public abstract class UBStoneReplacer
implements UBStrataColumnProvider {
    final UBBiome[] biomeList;
    final NoiseGenerator noiseGenerator;

    public UBStoneReplacer(UBBiome[] biomeList, NoiseGenerator noiseGenerator) {
        this.biomeList = biomeList;
        this.noiseGenerator = noiseGenerator;
        if (biomeList == null) {
            throw new RuntimeException();
        }
        if (noiseGenerator == null) {
            throw new RuntimeException();
        }
    }

    public abstract int[] getBiomeValues(Chunk var1);

    public void replaceStoneInChunk(Chunk chunk) {
        int[] biomeValues = this.getBiomeValues(chunk);
        int xPos = chunk.field_76635_g * 16;
        int zPos = chunk.field_76647_h * 16;
        for (ExtendedBlockStorage storage : chunk.func_76587_i()) {
            if (storage == null || storage.func_76663_a()) continue;
            int yPos = storage.func_76662_d();
            if (yPos >= UBConfig.SPECIFIC.generationHeight()) {
                return;
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    UBBiome currentBiome = this.biomeList[biomeValues[x * 16 + z]];
                    if (currentBiome == null) {
                        throw new RuntimeException("" + biomeValues[x * 16 + z]);
                    }
                    int variation = (int)(this.noiseGenerator.noise((double)(xPos + x) / 55.533, (double)(zPos + z) / 55.533, 3, 1.0, 0.5) * 10.0 - 5.0);
                    for (int y = 0; y < 16; ++y) {
                        IBlockState currentBlockState = storage.func_177485_a(x, y, z);
                        Block currentBlock = currentBlockState.func_177230_c();
                        if (Block.func_149680_a((Block)Blocks.field_150350_a, (Block)currentBlock) || Block.func_149680_a((Block)Blocks.field_150355_j, (Block)currentBlock) || currentBlock instanceof UBStone) continue;
                        if (currentBlock == Blocks.field_150348_b) {
                            storage.func_177484_a(x, y, z, currentBiome.getStrataBlockAtLayer(yPos + y + variation));
                            continue;
                        }
                        IBlockState strata = currentBiome.getStrataBlockAtLayer(yPos + y + variation);
                        if (!OresRegistry.INSTANCE.isUBified(strata.func_177230_c(), currentBlockState) || !(strata.func_177230_c() instanceof UBStone)) continue;
                        UBStone stone = (UBStone)strata.func_177230_c();
                        IBlockState ore = OresRegistry.INSTANCE.getUBifiedOre(strata.func_177230_c(), stone.func_176201_c(strata), currentBlockState);
                        storage.func_177484_a(x, y, z, ore);
                    }
                }
            }
        }
    }

    public abstract UBBiome UBBiomeAt(int var1, int var2);

    public void redoOres(World world) {
        HashMap<ChunkPos, ArrayList<BlockPos>> toRedo = OresRegistry.INSTANCE.forRedo((IBlockAccess)world);
        for (ChunkPos chunkID : toRedo.keySet()) {
            ArrayList<BlockPos> locations = toRedo.get(chunkID);
            Chunk chunk = world.func_72964_e(chunkID.field_77276_a, chunkID.field_77275_b);
            int[] biomeValues = this.getBiomeValues(chunk);
            for (BlockPos location : locations) {
                IBlockState currentBlockState = chunk.func_177435_g(location);
                UBBiome currentBiome = this.biomeList[biomeValues[(location.func_177958_n() & 0xF) * 16 + location.func_177952_p() & 0xF]];
                int variation = (int)(this.noiseGenerator.noise((double)location.func_177958_n() / 55.533, (double)location.func_177952_p() / 55.533, 3, 1.0, 0.5) * 10.0 - 5.0);
                IBlockState strata = currentBiome.getStrataBlockAtLayer(location.func_177956_o() + variation);
                if (!OresRegistry.INSTANCE.isUBified(strata.func_177230_c(), currentBlockState) || !(strata.func_177230_c() instanceof UBStone)) continue;
                UBStone stone = (UBStone)strata.func_177230_c();
                IBlockState ore = OresRegistry.INSTANCE.getUBifiedOre(strata.func_177230_c(), stone.func_176201_c(strata), currentBlockState);
                chunk.func_177436_a(location, ore);
            }
        }
    }

    private UBStrataColumn strataColumn(final StrataLayer[] strata, final IBlockState fillerBlockCodes, final int variation) {
        return new UBStrataColumn(){

            @Override
            public IBlockState stone(int y) {
                for (int i = 0; i < strata.length; ++i) {
                    if (!strata[i].heightInLayer(y + variation)) continue;
                    return strata[i].filler;
                }
                return fillerBlockCodes;
            }

            @Override
            public IBlockState cobblestone(int height) {
                IBlockState stone = this.stone(height);
                if (stone.func_177230_c() == API.IGNEOUS_STONE.getBlock()) {
                    return API.IGNEOUS_COBBLE.getBlock().func_176203_a(stone.func_177230_c().func_176201_c(stone));
                }
                if (stone.func_177230_c() == API.METAMORPHIC_STONE.getBlock()) {
                    return API.METAMORPHIC_COBBLE.getBlock().func_176203_a(stone.func_177230_c().func_176201_c(stone));
                }
                return stone;
            }

            @Override
            public IBlockState cobblestone() {
                IBlockState stone = this.stone();
                if (stone.func_177230_c() == API.IGNEOUS_STONE.getBlock()) {
                    return API.IGNEOUS_COBBLE.getBlock().func_176203_a(stone.func_177230_c().func_176201_c(stone));
                }
                if (stone.func_177230_c() == API.METAMORPHIC_STONE.getBlock()) {
                    return API.METAMORPHIC_COBBLE.getBlock().func_176203_a(stone.func_177230_c().func_176201_c(stone));
                }
                return stone;
            }

            @Override
            public IBlockState stone() {
                return fillerBlockCodes;
            }
        };
    }

    @Override
    public UBStrataColumn strataColumn(int x, int z) {
        UBBiome biome = this.UBBiomeAt(x, z);
        int variation = (int)(this.noiseGenerator.noise((double)x / 55.533, (double)z / 55.533, 3, 1.0, 0.5) * 10.0 - 5.0);
        return this.strataColumn(biome.strata, biome.filler, variation);
    }
}

