/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.world;

import exterminatorjeff.undergroundbiomes.api.UBBiome;
import exterminatorjeff.undergroundbiomes.world.UBStoneReplacer;
import exterminatorjeff.undergroundbiomes.world.noise.SimplexNoiseGenerator;
import exterminatorjeff.undergroundbiomes.world.noise.Voronoi;
import net.minecraft.world.chunk.Chunk;

public class SimpleStoneReplacer
extends UBStoneReplacer {
    final int NB_BIOMES;
    private SimplexNoiseGenerator simplex;
    private Voronoi voronoi;

    public SimpleStoneReplacer(UBBiome[] biomeList, long seed, int biomeSize) {
        super(biomeList, new SimplexNoiseGenerator(seed));
        this.NB_BIOMES = biomeList.length;
        this.simplex = new SimplexNoiseGenerator(seed + 1L);
        this.voronoi = new Voronoi();
        this.voronoi.setSeed((int)seed);
        this.voronoi.setFrequency(0.05 / (double)biomeSize);
    }

    int getRoundedValueInNParts(double value, int n, double min, double max) {
        int i;
        int ret = -1;
        double range = max - min;
        double gap = range / (double)n;
        double[] bounds = new double[n - 1];
        for (i = 1; i <= bounds.length; ++i) {
            bounds[i - 1] = min + (double)i * gap;
        }
        if (value >= min && value < bounds[0]) {
            ret = 0;
        }
        for (i = 0; i <= n - 3; ++i) {
            if (!(value >= bounds[i]) || !(value < bounds[i + 1])) continue;
            ret = i + 1;
        }
        if (value >= bounds[bounds.length - 1] && value <= max) {
            ret = n - 1;
        }
        if (ret == -1) {
            String msg = String.format("ret == -1 for value : %f | min: %f ; max: %f | %d parts | bounds: {", value, min, max, n);
            for (int i2 = 0; i2 < bounds.length - 1; ++i2) {
                msg = msg + bounds[i2] + ", ";
            }
            msg = msg + bounds[bounds.length - 1] + "}";
            throw new RuntimeException(msg);
        }
        return ret;
    }

    @Override
    public int[] getBiomeValues(Chunk chunk) {
        int[] biomeValues = new int[256];
        int xPos = chunk.field_76635_g * 16;
        int zPos = chunk.field_76647_h * 16;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double v = this.simplex.noise((double)(xPos + x), (double)(zPos + z), 2, 0.05, 10000.0, true);
                int variation = (int)(v * 8.0);
                double value = this.voronoi.getValue(xPos + x + variation, zPos + z + variation, 0.0);
                biomeValues[x * 6 + z] = this.getRoundedValueInNParts(value, this.NB_BIOMES, -1.0, 1.0);
            }
        }
        return biomeValues;
    }

    @Override
    public UBBiome UBBiomeAt(int x, int z) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

