/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.network;

import exterminatorjeff.undergroundbiomes.config.UBConfig;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public final class ConfigSync
implements IMessage {
    private boolean vanillaLike;
    private boolean ubifyRecipes;
    private boolean ubifyOres;
    private byte regularStoneCrafting;
    private float hardnessModifier;
    private float resistanceModifier;
    private boolean buttonsOn;
    private byte buttonsTypes;
    private byte buttonsStyles;
    private boolean stairsOn;
    private byte stairsTypes;
    private byte stairsStyle;
    private boolean wallsOn;
    private byte wallsTypes;
    private byte wallsStyles;

    public ConfigSync() {
    }

    public ConfigSync(UBConfig serverConfig) {
        this.vanillaLike = serverConfig.realistic();
        this.ubifyRecipes = serverConfig.ubifyRecipes();
        this.ubifyOres = serverConfig.ubifyOres();
        this.regularStoneCrafting = serverConfig.regularStoneCrafting.getValue().byteValue();
        this.hardnessModifier = serverConfig.hardnessModifier();
        this.resistanceModifier = serverConfig.resistanceModifier();
        this.buttonsOn = serverConfig.buttonsOn();
        this.buttonsTypes = serverConfig.buttonsTypes.getValue().byteValue();
        this.buttonsStyles = serverConfig.buttonsStyles.getValue().byteValue();
        this.stairsOn = serverConfig.stairsOn();
        this.stairsTypes = serverConfig.stairsTypes.getValue().byteValue();
        this.stairsStyle = serverConfig.stairsStyles.getValue().byteValue();
        this.wallsOn = serverConfig.wallsOn();
        this.wallsTypes = serverConfig.wallsTypes.getValue().byteValue();
        this.wallsStyles = serverConfig.wallsStyles.getValue().byteValue();
    }

    public void fromBytes(ByteBuf buf) {
        this.vanillaLike = buf.readBoolean();
        this.ubifyRecipes = buf.readBoolean();
        this.ubifyOres = buf.readBoolean();
        this.regularStoneCrafting = buf.readByte();
        this.hardnessModifier = buf.readFloat();
        this.resistanceModifier = buf.readFloat();
        this.buttonsOn = buf.readBoolean();
        this.buttonsTypes = buf.readByte();
        this.buttonsStyles = buf.readByte();
        this.stairsOn = buf.readBoolean();
        this.stairsTypes = buf.readByte();
        this.stairsStyle = buf.readByte();
        this.wallsOn = buf.readBoolean();
        this.wallsTypes = buf.readByte();
        this.wallsStyles = buf.readByte();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.vanillaLike);
        buf.writeBoolean(this.ubifyRecipes);
        buf.writeBoolean(this.ubifyOres);
        buf.writeByte((int)this.regularStoneCrafting);
        buf.writeFloat(this.hardnessModifier);
        buf.writeFloat(this.resistanceModifier);
        buf.writeBoolean(this.buttonsOn);
        buf.writeByte((int)this.buttonsTypes);
        buf.writeByte((int)this.buttonsStyles);
        buf.writeBoolean(this.stairsOn);
        buf.writeByte((int)this.stairsTypes);
        buf.writeByte((int)this.stairsStyle);
        buf.writeBoolean(this.wallsOn);
        buf.writeByte((int)this.wallsTypes);
        buf.writeByte((int)this.wallsStyles);
    }

    public static final class ConfigSyncHandler
    implements IMessageHandler<ConfigSync, IMessage> {
        public IMessage onMessage(ConfigSync message, MessageContext ctx) {
            UBConfig affected = (UBConfig)UBConfig.SPECIFIC;
            affected.realistic.changeValue(message.vanillaLike);
            affected.ubifyRecipes.changeValue(message.ubifyRecipes);
            affected.ubifyOres.changeValue(message.ubifyOres);
            affected.regularStoneCrafting.changeValue(Integer.valueOf(message.regularStoneCrafting));
            affected.hardnessModifier.changeValue(Float.valueOf(message.hardnessModifier));
            affected.resistanceModifier.changeValue(Float.valueOf(message.resistanceModifier));
            affected.buttonsOn.changeValue(message.buttonsOn);
            affected.buttonsTypes.changeValue(Integer.valueOf(message.buttonsTypes));
            affected.buttonsStyles.changeValue(Integer.valueOf(message.buttonsStyles));
            affected.stairsOn.changeValue(message.stairsOn);
            affected.stairsTypes.changeValue(Integer.valueOf(message.stairsTypes));
            affected.stairsStyles.changeValue(Integer.valueOf(message.stairsStyle));
            affected.wallsOn.changeValue(message.wallsOn);
            affected.wallsTypes.changeValue(Integer.valueOf(message.wallsTypes));
            affected.wallsStyles.changeValue(Integer.valueOf(message.wallsStyles));
            return null;
        }
    }
}

