/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.intermod;

import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.api.common.UBLogger;
import exterminatorjeff.undergroundbiomes.api.common.UBOresRegistry;
import exterminatorjeff.undergroundbiomes.client.UBStateMappers;
import exterminatorjeff.undergroundbiomes.common.block.UBOre;
import exterminatorjeff.undergroundbiomes.common.block.UBOreIgneous;
import exterminatorjeff.undergroundbiomes.common.block.UBOreMetamorphic;
import exterminatorjeff.undergroundbiomes.common.block.UBOreSedimentary;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import exterminatorjeff.undergroundbiomes.core.UndergroundBiomes;
import exterminatorjeff.undergroundbiomes.intermod.OreEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Level;

public enum OresRegistry implements UBOresRegistry
{
    INSTANCE;

    private static final UBLogger LOGGER;
    private final String SETUP_ERROR_MSG = "Cannot setup UBOres for '%s', Underground Biomes's pre-init is not done yet!";
    private final String SETUP_INFO_MSG = "The ore '%s' has been successfully UBfied.";
    private final String REQUEST_ERROR_MSG = "Cannot request UBOres setup for '%s', Underground Biomes's pre-init is done!";
    private final String REQUEST_INFO_MSG = "Request for '%s' to be UBfied added.";
    private boolean alreadySetup = false;
    private final Set<UBifyRequest> requests = new HashSet<UBifyRequest>();
    private final Map<String, OreEntry> ubifiedOres = new HashMap<String, OreEntry>();
    private final Map<String, ResourceLocation> oresToOverlays = new HashMap<String, ResourceLocation>();
    private final HashMap<Integer, HashMap<ChunkPos, ArrayList<BlockPos>>> storedLocations = new HashMap();

    private String format(String message, Block baseOre) {
        return String.format(message, baseOre.getRegistryName());
    }

    private String format(String message, Block baseOre, int meta) {
        return String.format(message, baseOre.getRegistryName() + ":" + meta);
    }

    private String toKey(Block baseOre, int baseOreMeta, Block baseStone) {
        if (baseOreMeta == -1) {
            baseOreMeta = 0;
        }
        return baseOre.getRegistryName() + ":" + baseOreMeta + ":" + baseStone.getRegistryName();
    }

    public boolean isUBified(Block baseStone, IBlockState baseOreState) {
        if (!UBConfig.SPECIFIC.ubifyOres()) {
            return false;
        }
        Block baseOre = baseOreState.func_177230_c();
        int baseOreMeta = baseOre.func_176201_c(baseOreState);
        return this.ubifiedOres.containsKey(this.toKey(baseOre, baseOreMeta, baseStone));
    }

    public IBlockState getUBifiedOre(Block baseStone, int baseStoneMeta, IBlockState baseOreState) {
        Block baseOre = baseOreState.func_177230_c();
        int baseOreMeta = baseOre.func_176201_c(baseOreState);
        return this.ubifiedOres.get(this.toKey(baseOre, baseOreMeta, baseStone)).ore().func_176203_a(baseStoneMeta);
    }

    private void applyBaseOreSmelting(Block baseOre, OreEntry ... ores) {
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(baseOre));
        if (result != null) {
            for (OreEntry ore : ores) {
                for (int i = 0; i < ore.ore().getNbVariants(); ++i) {
                    GameRegistry.addSmelting((ItemStack)new ItemStack(ore.getBlock(), 1, i), (ItemStack)result, (float)FurnaceRecipes.func_77602_a().func_151398_b(result));
                }
            }
        }
    }

    private void createOre(Block baseOre) {
        this.createOre(baseOre, -1);
    }

    private void createOre(Block baseOre, int baseOreMeta) {
        OreEntry igneousOre = new OreEntry(API.IGNEOUS_STONE.getBlock(), baseOre);
        OreEntry metamorphicOre = new OreEntry(API.METAMORPHIC_STONE.getBlock(), baseOre);
        OreEntry sedimentaryOre = new OreEntry(API.SEDIMENTARY_STONE.getBlock(), baseOre);
        igneousOre.register(new UBOreIgneous(baseOre, baseOreMeta));
        metamorphicOre.register(new UBOreMetamorphic(baseOre, baseOreMeta));
        sedimentaryOre.register(new UBOreSedimentary(baseOre, baseOreMeta));
        this.ubifiedOres.put(this.toKey(baseOre, baseOreMeta, API.IGNEOUS_STONE.getBlock()), igneousOre);
        this.ubifiedOres.put(this.toKey(baseOre, baseOreMeta, API.METAMORPHIC_STONE.getBlock()), metamorphicOre);
        this.ubifiedOres.put(this.toKey(baseOre, baseOreMeta, API.SEDIMENTARY_STONE.getBlock()), sedimentaryOre);
        this.applyBaseOreSmelting(baseOre, igneousOre, metamorphicOre, sedimentaryOre);
    }

    @Override
    public void setupOre(Block baseOre) {
        if (!UndergroundBiomes.isPreInitDone) {
            throw new RuntimeException(this.format("Cannot setup UBOres for '%s', Underground Biomes's pre-init is not done yet!", baseOre));
        }
        this.createOre(baseOre);
        LOGGER.debug(this.format("The ore '%s' has been successfully UBfied.", baseOre));
    }

    @Override
    public void setupOre(Block baseOre, int baseOreMeta) {
        if (!UndergroundBiomes.isPreInitDone) {
            throw new RuntimeException(this.format("Cannot setup UBOres for '%s', Underground Biomes's pre-init is not done yet!", baseOre, baseOreMeta));
        }
        this.createOre(baseOre, baseOreMeta);
        LOGGER.debug(this.format("The ore '%s' has been successfully UBfied.", baseOre, baseOreMeta));
    }

    @Override
    public void requestOreSetup(Block baseOre) {
        if (UndergroundBiomes.isPreInitDone || this.alreadySetup) {
            throw new RuntimeException(this.format("Cannot request UBOres setup for '%s', Underground Biomes's pre-init is done!", baseOre));
        }
        this.requests.add(new UBifyRequest(baseOre));
        LOGGER.debug(this.format("Request for '%s' to be UBfied added.", baseOre));
    }

    @Override
    public void requestOreSetup(Block baseOre, int baseOreMeta) {
        if (UndergroundBiomes.isPreInitDone || this.alreadySetup) {
            throw new RuntimeException(this.format("Cannot request UBOres setup for '%s', Underground Biomes's pre-init is done!", baseOre, baseOreMeta));
        }
        this.requests.add(new UBifyRequestMeta(baseOre, baseOreMeta));
        LOGGER.debug(this.format("Request for '%s' to be UBfied added.", baseOre, baseOreMeta));
    }

    public void fulfillRequests() {
        if (!this.alreadySetup) {
            this.alreadySetup = true;
            for (UBifyRequest request : this.requests) {
                request.fulfill();
            }
            this.requests.clear();
        }
    }

    public ItemStack getUBOresTabIcon() {
        Random random = new Random();
        Object[] ores = this.ubifiedOres.values().toArray();
        UBOre ore = ((OreEntry)ores[random.nextInt(ores.length)]).ore();
        return new ItemStack(Item.func_150898_a((Block)ore), 1, random.nextInt(ore.getNbVariants()));
    }

    private String toKey(Block baseOre, int baseOreMeta) {
        if (baseOreMeta == -1) {
            baseOreMeta = 0;
        }
        return baseOre.getRegistryName() + ":" + baseOreMeta;
    }

    private ResourceLocation getOverlayFor(String key) {
        ResourceLocation location = this.oresToOverlays.get(key);
        if (location == null) {
            LOGGER.error("There is no registered overlay for '" + key + "'!");
        } else {
            LOGGER.debug("Found overlay for '" + key + "': " + location);
        }
        return location;
    }

    public ResourceLocation getOverlayFor(Block baseOre) {
        return this.getOverlayFor(this.toKey(baseOre, -1));
    }

    public ResourceLocation getOverlayFor(Block baseOre, int baseOreMeta) {
        return this.getOverlayFor(this.toKey(baseOre, baseOreMeta));
    }

    private void registerOreOverlay(String key, ResourceLocation overlayLocation) {
        if (!this.oresToOverlays.containsKey(key)) {
            this.oresToOverlays.put(key, overlayLocation);
            LOGGER.debug("Overlay for '" + key + "' registered.");
        } else {
            LOGGER.warn("An overlay for '" + key + "' has already been registered!");
        }
    }

    @Override
    public void registerOreOverlay(Block baseOre, ResourceLocation overlayLocation) {
        this.registerOreOverlay(this.toKey(baseOre, -1), overlayLocation);
    }

    @Override
    public void registerOreOverlay(Block baseOre, int baseOreMeta, ResourceLocation overlayLocation) {
        this.registerOreOverlay(this.toKey(baseOre, baseOreMeta), overlayLocation);
    }

    public void addVanillaOverlays() {
        this.registerOreOverlay(Blocks.field_150365_q, new ResourceLocation("undergroundbiomes:blocks/coal_overlay"));
        this.registerOreOverlay(Blocks.field_150482_ag, new ResourceLocation("undergroundbiomes:blocks/diamond_overlay"));
        this.registerOreOverlay(Blocks.field_150412_bA, new ResourceLocation("undergroundbiomes:blocks/emerald_overlay"));
        this.registerOreOverlay(Blocks.field_150352_o, new ResourceLocation("undergroundbiomes:blocks/gold_overlay"));
        this.registerOreOverlay(Blocks.field_150366_p, new ResourceLocation("undergroundbiomes:blocks/iron_overlay"));
        this.registerOreOverlay(Blocks.field_150369_x, new ResourceLocation("undergroundbiomes:blocks/lapis_overlay"));
        this.registerOreOverlay(Blocks.field_150450_ax, new ResourceLocation("undergroundbiomes:blocks/redstone_overlay"));
    }

    public void registerOreModels() {
        this.ubifiedOres.values().forEach(oreEntry -> oreEntry.registerModel(UBStateMappers.UBORE_STATE_MAPPER));
    }

    @SubscribeEvent
    public void registerOverlayTextures(TextureStitchEvent.Pre e) {
        this.oresToOverlays.values().forEach(overlayLocation -> e.getMap().func_174942_a(overlayLocation));
    }

    private int dimension(IBlockAccess access) {
        return ((World)access).field_73011_w.getDimension();
    }

    private final ArrayList<BlockPos> blockPosList(IBlockAccess world, ChunkPos chunkID) {
        ArrayList<Object> result;
        int dimension = this.dimension(world);
        HashMap<Object, ArrayList<Object>> worldMap = this.storedLocations.get(dimension);
        if (worldMap == null) {
            worldMap = new HashMap();
            this.storedLocations.put(dimension, worldMap);
        }
        if ((result = worldMap.get(chunkID)) == null) {
            result = new ArrayList();
            worldMap.put(chunkID, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecheck(IBlockAccess world, BlockPos pos) {
        HashMap<Integer, HashMap<ChunkPos, ArrayList<BlockPos>>> hashMap = this.storedLocations;
        synchronized (hashMap) {
            ChunkPos chunkID = new ChunkPos(pos);
            this.blockPosList(world, chunkID).add(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<ChunkPos, ArrayList<BlockPos>> forRedo(IBlockAccess world) {
        HashMap<Object, ArrayList<Object>> result = null;
        HashMap<Integer, HashMap<ChunkPos, ArrayList<BlockPos>>> hashMap = this.storedLocations;
        synchronized (hashMap) {
            int dimension = this.dimension(world);
            result = this.storedLocations.get(dimension);
            if (result == null) {
                result = new HashMap();
            }
            this.storedLocations.remove(dimension);
        }
        return result;
    }

    public void recheckPile() {
        int result = 0;
        for (Integer world : this.storedLocations.keySet()) {
            int worldResult = 0;
            HashMap<ChunkPos, ArrayList<BlockPos>> chunkPosMap = this.storedLocations.get(world);
            for (ChunkPos chunkPos : chunkPosMap.keySet()) {
                worldResult += chunkPosMap.get(chunkPos).size();
            }
            result += worldResult;
            System.out.println("" + worldResult + " Blocks in World : " + world.toString());
        }
        System.out.println("Blocks queued for redo: " + result);
    }

    static {
        LOGGER = new UBLogger(OresRegistry.class, Level.INFO);
    }

    private class UBifyRequestMeta
    extends UBifyRequest {
        protected final int baseOreMeta;

        UBifyRequestMeta(Block baseOre, int baseOreMeta) {
            super(baseOre);
            this.baseOreMeta = baseOreMeta;
        }

        @Override
        void fulfill() {
            OresRegistry.this.createOre(this.baseOre, this.baseOreMeta);
            LOGGER.debug(OresRegistry.this.format("The ore '%s' has been successfully UBfied.", this.baseOre, this.baseOreMeta));
        }
    }

    private class UBifyRequest {
        protected final Block baseOre;

        UBifyRequest(Block baseOre) {
            this.baseOre = baseOre;
        }

        void fulfill() {
            OresRegistry.this.createOre(this.baseOre);
            LOGGER.debug(OresRegistry.this.format("The ore '%s' has been successfully UBfied.", this.baseOre));
        }
    }
}

