/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.core;

import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.api.enums.IgneousVariant;
import exterminatorjeff.undergroundbiomes.api.enums.MetamorphicVariant;
import exterminatorjeff.undergroundbiomes.api.enums.SedimentaryVariant;
import exterminatorjeff.undergroundbiomes.api.enums.UBStoneStyle;
import exterminatorjeff.undergroundbiomes.api.names.BlockEntry;
import exterminatorjeff.undergroundbiomes.common.ButtonRecipe;
import exterminatorjeff.undergroundbiomes.common.RegularStoneRecipe;
import exterminatorjeff.undergroundbiomes.common.UBFuelHandler;
import exterminatorjeff.undergroundbiomes.common.block.IgneousBrick;
import exterminatorjeff.undergroundbiomes.common.block.IgneousCobble;
import exterminatorjeff.undergroundbiomes.common.block.IgneousStone;
import exterminatorjeff.undergroundbiomes.common.block.MetamorphicBrick;
import exterminatorjeff.undergroundbiomes.common.block.MetamorphicCobble;
import exterminatorjeff.undergroundbiomes.common.block.MetamorphicStone;
import exterminatorjeff.undergroundbiomes.common.block.SedimentaryStone;
import exterminatorjeff.undergroundbiomes.common.block.button.UBButtonIgneous;
import exterminatorjeff.undergroundbiomes.common.block.button.UBButtonIgneousBrick;
import exterminatorjeff.undergroundbiomes.common.block.button.UBButtonIgneousCobble;
import exterminatorjeff.undergroundbiomes.common.block.button.UBButtonMetamorphic;
import exterminatorjeff.undergroundbiomes.common.block.button.UBButtonMetamorphicBrick;
import exterminatorjeff.undergroundbiomes.common.block.button.UBButtonMetamorphicCobble;
import exterminatorjeff.undergroundbiomes.common.block.button.UBButtonSedimentary;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBIgneousBrickSlabDouble;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBIgneousBrickSlabHalf;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBIgneousCobbleSlabDouble;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBIgneousCobbleSlabHalf;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBIgneousStoneSlabDouble;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBIgneousStoneSlabHalf;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBMetamorphicBrickSlabDouble;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBMetamorphicBrickSlabHalf;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBMetamorphicCobbleSlabDouble;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBMetamorphicCobbleSlabHalf;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBMetamorphicStoneSlabDouble;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBMetamorphicStoneSlabHalf;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBSedimentaryStoneSlabDouble;
import exterminatorjeff.undergroundbiomes.common.block.slab.UBSedimentaryStoneSlabHalf;
import exterminatorjeff.undergroundbiomes.common.block.stairs.UBStairsIgneous;
import exterminatorjeff.undergroundbiomes.common.block.stairs.UBStairsIgneousBrick;
import exterminatorjeff.undergroundbiomes.common.block.stairs.UBStairsIgneousCobble;
import exterminatorjeff.undergroundbiomes.common.block.stairs.UBStairsMetamorphic;
import exterminatorjeff.undergroundbiomes.common.block.stairs.UBStairsMetamorphicBrick;
import exterminatorjeff.undergroundbiomes.common.block.stairs.UBStairsMetamorphicCobble;
import exterminatorjeff.undergroundbiomes.common.block.stairs.UBStairsSedimentary;
import exterminatorjeff.undergroundbiomes.common.block.wall.UBWallIgneous;
import exterminatorjeff.undergroundbiomes.common.block.wall.UBWallIgneousBrick;
import exterminatorjeff.undergroundbiomes.common.block.wall.UBWallIgneousCobble;
import exterminatorjeff.undergroundbiomes.common.block.wall.UBWallMetamorphic;
import exterminatorjeff.undergroundbiomes.common.block.wall.UBWallMetamorphicBrick;
import exterminatorjeff.undergroundbiomes.common.block.wall.UBWallMetamorphicCobble;
import exterminatorjeff.undergroundbiomes.common.block.wall.UBWallSedimentary;
import exterminatorjeff.undergroundbiomes.common.item.ItemFossilPiece;
import exterminatorjeff.undergroundbiomes.common.item.ItemLigniteCoal;
import exterminatorjeff.undergroundbiomes.common.itemblock.ButtonItemBlock;
import exterminatorjeff.undergroundbiomes.common.itemblock.SlabItemBlock;
import exterminatorjeff.undergroundbiomes.common.itemblock.StairsItemBlock;
import exterminatorjeff.undergroundbiomes.config.ConfigManager;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import exterminatorjeff.undergroundbiomes.core.DimensionManager;
import exterminatorjeff.undergroundbiomes.intermod.DropsRegistry;
import exterminatorjeff.undergroundbiomes.intermod.OresRegistry;
import exterminatorjeff.undergroundbiomes.intermod.StonesRegistry;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class CommonProxy {
    private ConfigManager configManager;
    private DimensionManager dimensionManager;
    private ArrayList<Runnable> oneShotServerCloseActions = new ArrayList();
    private ArrayList<Runnable> serverCloseActions = new ArrayList();

    public void preInit(FMLPreInitializationEvent event) {
        API.STONES_REGISTRY = StonesRegistry.INSTANCE;
        API.ORES_REGISTRY = OresRegistry.INSTANCE;
        API.DROPS_REGISTRY = DropsRegistry.INSTANCE;
        API.SETTINGS = UBConfig.SPECIFIC;
        this.configManager = new ConfigManager(event);
        this.dimensionManager = new DimensionManager(this.configManager);
        API.STRATA_COLUMN_PROVIDER = this.dimensionManager;
        this.createBlocks();
        this.createItems();
        this.createOres();
        DropsRegistry.INSTANCE.init();
        OresRegistry.INSTANCE.fulfillRequests();
    }

    public void init(FMLInitializationEvent e) {
        this.addOreDicts();
        this.createRecipes();
        GameRegistry.registerFuelHandler((IFuelHandler)UBFuelHandler.INSTANCE);
    }

    public void postInit(FMLPostInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this.dimensionManager);
    }

    public void serverLoad(FMLServerAboutToStartEvent event) {
        File worldSaveDirectory = null;
        String worldName = event.getServer().func_71270_I();
        if (event.getServer().func_71264_H()) {
            File saveDirectory = event.getServer().func_71209_f("saves");
            worldSaveDirectory = new File(saveDirectory, worldName);
        } else {
            PropertyManager settings = new PropertyManager(event.getServer().func_71209_f("server.properties"));
            worldName = settings.func_73671_a("level-name", worldName);
            worldSaveDirectory = event.getServer().func_71209_f(worldName);
        }
        WorldServer server = event.getServer().func_71218_a(0);
        File worldLocation = server.getChunkSaveLocation();
        this.configManager.setWorldFile(worldLocation);
        this.dimensionManager.refreshManagers();
    }

    public void onServerStopped(FMLServerStoppedEvent event) {
        this.dimensionManager.clearWorldManagers();
        OresRegistry.INSTANCE.recheckPile();
        for (Runnable action : this.serverCloseActions) {
            action.run();
        }
        for (Runnable action : this.oneShotServerCloseActions) {
            action.run();
        }
        this.oneShotServerCloseActions.clear();
    }

    public void runOnServerClose(Runnable action) {
        this.serverCloseActions.add(action);
    }

    public void runOnNextServerCloseOnly(Runnable action) {
        this.serverCloseActions.add(action);
    }

    private final void createBlocks() {
        API.IGNEOUS_STONE.register(new IgneousStone());
        API.IGNEOUS_COBBLE.register(new IgneousCobble());
        API.IGNEOUS_BRICK.register(new IgneousBrick());
        API.METAMORPHIC_STONE.register(new MetamorphicStone());
        API.METAMORPHIC_COBBLE.register(new MetamorphicCobble());
        API.METAMORPHIC_BRICK.register(new MetamorphicBrick());
        API.SEDIMENTARY_STONE.register(new SedimentaryStone());
        API.IGNEOUS_BRICK_SLAB.register(new SlabItemBlock(new UBIgneousBrickSlabHalf(), new UBIgneousBrickSlabDouble()));
        API.METAMORPHIC_BRICK_SLAB.register(new SlabItemBlock(new UBMetamorphicBrickSlabHalf(), new UBMetamorphicBrickSlabDouble()));
        API.IGNEOUS_STONE_SLAB.register(new SlabItemBlock(new UBIgneousStoneSlabHalf(), new UBIgneousStoneSlabDouble()));
        API.METAMORPHIC_STONE_SLAB.register(new SlabItemBlock(new UBMetamorphicStoneSlabHalf(), new UBMetamorphicStoneSlabDouble()));
        API.IGNEOUS_COBBLE_SLAB.register(new SlabItemBlock(new UBIgneousCobbleSlabHalf(), new UBIgneousCobbleSlabDouble()));
        API.METAMORPHIC_COBBLE_SLAB.register(new SlabItemBlock(new UBMetamorphicCobbleSlabHalf(), new UBMetamorphicCobbleSlabDouble()));
        API.SEDIMENTARY_STONE_SLAB.register(new SlabItemBlock(new UBSedimentaryStoneSlabHalf(), new UBSedimentaryStoneSlabDouble()));
        if (UBConfig.SPECIFIC.buttonsOn()) {
            if (UBConfig.SPECIFIC.igneousButtonsOn()) {
                if (UBConfig.SPECIFIC.stoneButtonsOn()) {
                    API.IGNEOUS_STONE_BUTTON.register(new ButtonItemBlock((BlockEntry)API.IGNEOUS_STONE, UBButtonIgneous.class));
                }
                if (UBConfig.SPECIFIC.cobbleButtonsOn()) {
                    API.IGNEOUS_COBBLE_BUTTON.register(new ButtonItemBlock((BlockEntry)API.IGNEOUS_COBBLE, UBButtonIgneousCobble.class));
                }
                if (UBConfig.SPECIFIC.brickButtonsOn()) {
                    API.IGNEOUS_BRICK_BUTTON.register(new ButtonItemBlock((BlockEntry)API.IGNEOUS_BRICK, UBButtonIgneousBrick.class));
                }
            }
            if (UBConfig.SPECIFIC.metamorphicButtonsOn()) {
                if (UBConfig.SPECIFIC.stoneButtonsOn()) {
                    API.METAMORPHIC_STONE_BUTTON.register(new ButtonItemBlock((BlockEntry)API.METAMORPHIC_STONE, UBButtonMetamorphic.class));
                }
                if (UBConfig.SPECIFIC.cobbleButtonsOn()) {
                    API.METAMORPHIC_COBBLE_BUTTON.register(new ButtonItemBlock((BlockEntry)API.METAMORPHIC_COBBLE, UBButtonMetamorphicCobble.class));
                }
                if (UBConfig.SPECIFIC.brickButtonsOn()) {
                    API.METAMORPHIC_BRICK_BUTTON.register(new ButtonItemBlock((BlockEntry)API.METAMORPHIC_BRICK, UBButtonMetamorphicBrick.class));
                }
            }
            if (UBConfig.SPECIFIC.sedimentaryButtonsOn()) {
                API.SEDIMENTARY_STONE_BUTTON.register(new ButtonItemBlock((BlockEntry)API.SEDIMENTARY_STONE, UBButtonSedimentary.class));
            }
        }
        if (UBConfig.SPECIFIC.wallsOn()) {
            if (UBConfig.SPECIFIC.igneousWallsOn()) {
                if (UBConfig.SPECIFIC.stoneWallsOn()) {
                    API.IGNEOUS_STONE_WALL.register(new UBWallIgneous(API.IGNEOUS_STONE));
                }
                if (UBConfig.SPECIFIC.cobbleWallsOn()) {
                    API.IGNEOUS_COBBLE_WALL.register(new UBWallIgneousCobble(API.IGNEOUS_COBBLE));
                }
                if (UBConfig.SPECIFIC.brickWallsOn()) {
                    API.IGNEOUS_BRICK_WALL.register(new UBWallIgneousBrick(API.IGNEOUS_BRICK));
                }
            }
            if (UBConfig.SPECIFIC.metamorphicWallsOn()) {
                if (UBConfig.SPECIFIC.stoneWallsOn()) {
                    API.METAMORPHIC_STONE_WALL.register(new UBWallMetamorphic(API.METAMORPHIC_STONE));
                }
                if (UBConfig.SPECIFIC.cobbleWallsOn()) {
                    API.METAMORPHIC_COBBLE_WALL.register(new UBWallMetamorphicCobble(API.METAMORPHIC_COBBLE));
                }
                if (UBConfig.SPECIFIC.brickWallsOn()) {
                    API.METAMORPHIC_BRICK_WALL.register(new UBWallMetamorphicBrick(API.METAMORPHIC_BRICK));
                }
            }
            if (UBConfig.SPECIFIC.sedimentaryWallsOn()) {
                API.SEDIMENTARY_STONE_WALL.register(new UBWallSedimentary(API.SEDIMENTARY_STONE));
            }
        }
        if (UBConfig.SPECIFIC.stairsOn()) {
            if (UBConfig.SPECIFIC.igneousStairsOn()) {
                if (UBConfig.SPECIFIC.stoneStairsOn()) {
                    API.IGNEOUS_STONE_STAIRS.register(new StairsItemBlock((BlockEntry)API.IGNEOUS_STONE, UBStairsIgneous.class));
                }
                if (UBConfig.SPECIFIC.cobbleStairsOn()) {
                    API.IGNEOUS_COBBLE_STAIRS.register(new StairsItemBlock((BlockEntry)API.IGNEOUS_COBBLE, UBStairsIgneousCobble.class));
                }
                if (UBConfig.SPECIFIC.brickStairsOn()) {
                    API.IGNEOUS_BRICK_STAIRS.register(new StairsItemBlock((BlockEntry)API.IGNEOUS_BRICK, UBStairsIgneousBrick.class));
                }
            }
            if (UBConfig.SPECIFIC.metamorphicStairsOn()) {
                if (UBConfig.SPECIFIC.stoneStairsOn()) {
                    API.METAMORPHIC_STONE_STAIRS.register(new StairsItemBlock((BlockEntry)API.METAMORPHIC_STONE, UBStairsMetamorphic.class));
                }
                if (UBConfig.SPECIFIC.cobbleStairsOn()) {
                    API.METAMORPHIC_COBBLE_STAIRS.register(new StairsItemBlock((BlockEntry)API.METAMORPHIC_COBBLE, UBStairsMetamorphicCobble.class));
                }
                if (UBConfig.SPECIFIC.brickStairsOn()) {
                    API.METAMORPHIC_BRICK_STAIRS.register(new StairsItemBlock((BlockEntry)API.METAMORPHIC_BRICK, UBStairsMetamorphicBrick.class));
                }
            }
            if (UBConfig.SPECIFIC.sedimentaryStairsOn()) {
                API.SEDIMENTARY_STONE_STAIRS.register(new StairsItemBlock((BlockEntry)API.SEDIMENTARY_STONE, UBStairsSedimentary.class));
            }
        }
    }

    private final void createItems() {
        API.LIGNITE_COAL.register(new ItemLigniteCoal());
        API.FOSSIL_PIECE.register(new ItemFossilPiece());
    }

    private final void createOres() {
        OresRegistry.INSTANCE.requestOreSetup(Blocks.field_150482_ag);
        OresRegistry.INSTANCE.requestOreSetup(Blocks.field_150352_o);
        OresRegistry.INSTANCE.requestOreSetup(Blocks.field_150366_p);
        OresRegistry.INSTANCE.requestOreSetup(Blocks.field_150365_q);
        OresRegistry.INSTANCE.requestOreSetup(Blocks.field_150412_bA);
        OresRegistry.INSTANCE.requestOreSetup(Blocks.field_150450_ax);
        OresRegistry.INSTANCE.requestOreSetup(Blocks.field_150369_x);
    }

    public void addOreDicts() {
        for (int i = 0; i < 8; ++i) {
            OreDictionary.registerOre((String)"stone", (ItemStack)new ItemStack(API.IGNEOUS_STONE.getItemBlock(), 1, i));
            OreDictionary.registerOre((String)"stone", (ItemStack)new ItemStack(API.METAMORPHIC_STONE.getItemBlock(), 1, i));
            OreDictionary.registerOre((String)"stone", (ItemStack)new ItemStack(API.SEDIMENTARY_STONE.getItemBlock(), 1, i));
            OreDictionary.registerOre((String)"cobblestone", (ItemStack)new ItemStack(API.IGNEOUS_COBBLE.getItemBlock(), 1, i));
            OreDictionary.registerOre((String)"cobblestone", (ItemStack)new ItemStack(API.METAMORPHIC_COBBLE.getItemBlock(), 1, i));
            OreDictionary.registerOre((String)"stoneBricks", (ItemStack)new ItemStack(API.IGNEOUS_BRICK.getItemBlock(), 1, i));
            OreDictionary.registerOre((String)"stoneBricks", (ItemStack)new ItemStack(API.METAMORPHIC_BRICK.getItemBlock(), 1, i));
        }
    }

    private final void createRecipes() {
        int i;
        int i2;
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.field_151044_h), (Object[])new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), API.LIGNITE_COAL.getItem()});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151100_aR, 1, 15), (Object[])new Object[]{new ItemStack(API.FOSSIL_PIECE.getItem(), 1, Short.MAX_VALUE)});
        for (i2 = 0; i2 < IgneousVariant.NB_VARIANTS; ++i2) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.IGNEOUS_BRICK.getItemBlock(), 4, i2), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), new ItemStack(API.IGNEOUS_STONE.getItemBlock(), 1, i2)});
            GameRegistry.addSmelting((ItemStack)new ItemStack(API.IGNEOUS_COBBLE.getItemBlock(), 1, i2), (ItemStack)new ItemStack(API.IGNEOUS_STONE.getItemBlock(), 1, i2), (float)0.1f);
        }
        for (i2 = 0; i2 < MetamorphicVariant.NB_VARIANTS; ++i2) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.METAMORPHIC_BRICK.getItemBlock(), 4, i2), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), new ItemStack(API.METAMORPHIC_STONE.getItemBlock(), 1, i2)});
            GameRegistry.addSmelting((ItemStack)new ItemStack(API.METAMORPHIC_COBBLE.getItemBlock(), 1, i2), (ItemStack)new ItemStack(API.METAMORPHIC_STONE.getItemBlock(), 1, i2), (float)0.1f);
        }
        for (i2 = 0; i2 < IgneousVariant.NB_VARIANTS; ++i2) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.IGNEOUS_STONE_SLAB.getItem(), 6, i2), (Object[])new Object[]{"XXX", Character.valueOf('X'), new ItemStack(API.IGNEOUS_STONE.getItemBlock(), 1, i2)});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.IGNEOUS_COBBLE_SLAB.getItem(), 6, i2), (Object[])new Object[]{"XXX", Character.valueOf('X'), new ItemStack(API.IGNEOUS_COBBLE.getItemBlock(), 1, i2)});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.IGNEOUS_BRICK_SLAB.getItem(), 6, i2), (Object[])new Object[]{"XXX", Character.valueOf('X'), new ItemStack(API.IGNEOUS_BRICK.getItemBlock(), 1, i2)});
        }
        for (i2 = 0; i2 < MetamorphicVariant.NB_VARIANTS; ++i2) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.METAMORPHIC_STONE_SLAB.getItem(), 6, i2), (Object[])new Object[]{"XXX", Character.valueOf('X'), new ItemStack(API.METAMORPHIC_STONE.getItemBlock(), 1, i2)});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.METAMORPHIC_COBBLE_SLAB.getItem(), 6, i2), (Object[])new Object[]{"XXX", Character.valueOf('X'), new ItemStack(API.METAMORPHIC_COBBLE.getItemBlock(), 1, i2)});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.METAMORPHIC_BRICK_SLAB.getItem(), 6, i2), (Object[])new Object[]{"XXX", Character.valueOf('X'), new ItemStack(API.METAMORPHIC_BRICK.getItemBlock(), 1, i2)});
        }
        for (i2 = 0; i2 < SedimentaryVariant.NB_VARIANTS; ++i2) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.SEDIMENTARY_STONE_SLAB.getItem(), 6, i2), (Object[])new Object[]{"XXX", Character.valueOf('X'), new ItemStack(API.SEDIMENTARY_STONE.getItemBlock(), 1, i2)});
        }
        int n = UBConfig.SPECIFIC.buttonRecipeResult();
        if (UBConfig.SPECIFIC.buttonsOn()) {
            if (UBConfig.SPECIFIC.igneousButtonsOn()) {
                for (i = 0; i < IgneousVariant.NB_VARIANTS; ++i) {
                    if (UBConfig.SPECIFIC.stoneButtonsOn()) {
                        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(API.IGNEOUS_STONE_BUTTON.getItemBlock(), n, i), (Object[])new Object[]{new ItemStack(API.IGNEOUS_STONE.getItemBlock(), 1, i)});
                    }
                    if (UBConfig.SPECIFIC.cobbleButtonsOn()) {
                        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(API.IGNEOUS_COBBLE_BUTTON.getItemBlock(), n, i), (Object[])new Object[]{new ItemStack(API.IGNEOUS_COBBLE.getItemBlock(), 1, i)});
                    }
                    if (!UBConfig.SPECIFIC.brickButtonsOn()) continue;
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(API.IGNEOUS_BRICK_BUTTON.getItemBlock(), n, i), (Object[])new Object[]{new ItemStack(API.IGNEOUS_BRICK.getItemBlock(), 1, i)});
                }
            }
            if (UBConfig.SPECIFIC.metamorphicButtonsOn()) {
                for (i = 0; i < MetamorphicVariant.NB_VARIANTS; ++i) {
                    if (UBConfig.SPECIFIC.stoneButtonsOn()) {
                        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(API.METAMORPHIC_STONE_BUTTON.getItemBlock(), n, i), (Object[])new Object[]{new ItemStack(API.METAMORPHIC_STONE.getItemBlock(), 1, i)});
                    }
                    if (UBConfig.SPECIFIC.cobbleButtonsOn()) {
                        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(API.METAMORPHIC_COBBLE_BUTTON.getItemBlock(), n, i), (Object[])new Object[]{new ItemStack(API.METAMORPHIC_COBBLE.getItemBlock(), 1, i)});
                    }
                    if (!UBConfig.SPECIFIC.brickButtonsOn()) continue;
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(API.METAMORPHIC_BRICK_BUTTON.getItemBlock(), n, i), (Object[])new Object[]{new ItemStack(API.METAMORPHIC_BRICK.getItemBlock(), 1, i)});
                }
            }
            if (UBConfig.SPECIFIC.sedimentaryButtonsOn()) {
                for (i = 0; i < SedimentaryVariant.NB_VARIANTS; ++i) {
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(API.SEDIMENTARY_STONE_BUTTON.getItemBlock(), n, i), (Object[])new Object[]{new ItemStack(API.SEDIMENTARY_STONE.getItemBlock(), 1, i)});
                }
            }
        }
        if (UBConfig.SPECIFIC.wallsOn()) {
            if (UBConfig.SPECIFIC.igneousWallsOn()) {
                for (i = 0; i < IgneousVariant.NB_VARIANTS; ++i) {
                    if (UBConfig.SPECIFIC.stoneWallsOn()) {
                        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.IGNEOUS_STONE_WALL.getItemBlock(), 6, i), (Object[])new Object[]{"XXX", "XXX", Character.valueOf('X'), new ItemStack(API.IGNEOUS_STONE.getItemBlock(), 1, i)});
                    }
                    if (UBConfig.SPECIFIC.cobbleWallsOn()) {
                        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.IGNEOUS_COBBLE_WALL.getItemBlock(), 6, i), (Object[])new Object[]{"XXX", "XXX", Character.valueOf('X'), new ItemStack(API.IGNEOUS_COBBLE.getItemBlock(), 1, i)});
                    }
                    if (!UBConfig.SPECIFIC.brickWallsOn()) continue;
                    GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.IGNEOUS_BRICK_WALL.getItemBlock(), 6, i), (Object[])new Object[]{"XXX", "XXX", Character.valueOf('X'), new ItemStack(API.IGNEOUS_BRICK.getItemBlock(), 1, i)});
                }
            }
            if (UBConfig.SPECIFIC.metamorphicWallsOn()) {
                for (i = 0; i < MetamorphicVariant.NB_VARIANTS; ++i) {
                    if (UBConfig.SPECIFIC.stoneWallsOn()) {
                        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.METAMORPHIC_STONE_WALL.getItemBlock(), 6, i), (Object[])new Object[]{"XXX", "XXX", Character.valueOf('X'), new ItemStack(API.METAMORPHIC_STONE.getItemBlock(), 1, i)});
                    }
                    if (UBConfig.SPECIFIC.cobbleWallsOn()) {
                        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.METAMORPHIC_COBBLE_WALL.getItemBlock(), 6, i), (Object[])new Object[]{"XXX", "XXX", Character.valueOf('X'), new ItemStack(API.METAMORPHIC_COBBLE.getItemBlock(), 1, i)});
                    }
                    if (!UBConfig.SPECIFIC.brickWallsOn()) continue;
                    GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.METAMORPHIC_BRICK_WALL.getItemBlock(), 6, i), (Object[])new Object[]{"XXX", "XXX", Character.valueOf('X'), new ItemStack(API.METAMORPHIC_BRICK.getItemBlock(), 1, i)});
                }
            }
            if (UBConfig.SPECIFIC.sedimentaryWallsOn()) {
                for (i = 0; i < SedimentaryVariant.NB_VARIANTS; ++i) {
                    GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.SEDIMENTARY_STONE_WALL.getItemBlock(), 6, i), (Object[])new Object[]{"XXX", "XXX", Character.valueOf('X'), new ItemStack(API.SEDIMENTARY_STONE.getItemBlock(), 1, i)});
                }
            }
        }
        if (UBConfig.SPECIFIC.stairsOn()) {
            if (UBConfig.SPECIFIC.igneousStairsOn()) {
                for (i = 0; i < IgneousVariant.NB_VARIANTS; ++i) {
                    if (UBConfig.SPECIFIC.stoneStairsOn()) {
                        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.IGNEOUS_STONE_STAIRS.getItemBlock(), 4, i), (Object[])new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack(API.IGNEOUS_STONE.getItemBlock(), 1, i)});
                    }
                    if (UBConfig.SPECIFIC.cobbleStairsOn()) {
                        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.IGNEOUS_COBBLE_STAIRS.getItemBlock(), 4, i), (Object[])new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack(API.IGNEOUS_COBBLE.getItemBlock(), 1, i)});
                    }
                    if (!UBConfig.SPECIFIC.brickStairsOn()) continue;
                    GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.IGNEOUS_BRICK_STAIRS.getItemBlock(), 4, i), (Object[])new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack(API.IGNEOUS_BRICK.getItemBlock(), 1, i)});
                }
            }
            if (UBConfig.SPECIFIC.metamorphicStairsOn()) {
                for (i = 0; i < MetamorphicVariant.NB_VARIANTS; ++i) {
                    if (UBConfig.SPECIFIC.stoneStairsOn()) {
                        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.METAMORPHIC_STONE_STAIRS.getItemBlock(), 4, i), (Object[])new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack(API.METAMORPHIC_STONE.getItemBlock(), 1, i)});
                    }
                    if (UBConfig.SPECIFIC.cobbleStairsOn()) {
                        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.METAMORPHIC_COBBLE_STAIRS.getItemBlock(), 4, i), (Object[])new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack(API.METAMORPHIC_COBBLE.getItemBlock(), 1, i)});
                    }
                    if (!UBConfig.SPECIFIC.brickStairsOn()) continue;
                    GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.METAMORPHIC_BRICK_STAIRS.getItemBlock(), 4, i), (Object[])new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack(API.METAMORPHIC_BRICK.getItemBlock(), 1, i)});
                }
            }
            if (UBConfig.SPECIFIC.sedimentaryStairsOn()) {
                for (i = 0; i < SedimentaryVariant.NB_VARIANTS; ++i) {
                    GameRegistry.addShapedRecipe((ItemStack)new ItemStack(API.SEDIMENTARY_STONE_STAIRS.getItemBlock(), 4, i), (Object[])new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack(API.SEDIMENTARY_STONE.getItemBlock(), 1, i)});
                }
            }
        }
        if (UBConfig.SPECIFIC.ubifyRecipes()) {
            StonesRegistry.INSTANCE.stonesFor(UBStoneStyle.COBBLE).forEach(cobbleEntry -> {
                Item cobble = cobbleEntry.getItemBlock();
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150460_al), (Object[])new Object[]{"XXX", "X X", "XXX", Character.valueOf('X'), cobble});
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150442_at), (Object[])new Object[]{"I", "X", Character.valueOf('X'), cobble, Character.valueOf('I'), Items.field_151055_y});
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)Blocks.field_150331_J), (Object[])new Object[]{"WWW", "CIC", "CRC", Character.valueOf('W'), Blocks.field_150344_f, Character.valueOf('C'), cobble, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), Items.field_151137_ax});
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.field_151049_t), (Object[])new Object[]{"XX ", "XW ", " W ", Character.valueOf('X'), cobble, Character.valueOf('W'), Items.field_151055_y});
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.field_151050_s), (Object[])new Object[]{"XXX", " W ", " W ", Character.valueOf('X'), cobble, Character.valueOf('W'), Items.field_151055_y});
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.field_151018_J), (Object[])new Object[]{"XX ", " W ", " W ", Character.valueOf('X'), cobble, Character.valueOf('W'), Items.field_151055_y});
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.field_151051_r), (Object[])new Object[]{" X ", " W ", " W ", Character.valueOf('X'), cobble, Character.valueOf('W'), Items.field_151055_y});
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.field_151052_q), (Object[])new Object[]{"X", "X", "W", Character.valueOf('X'), cobble, Character.valueOf('W'), Items.field_151055_y});
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.field_151067_bt), (Object[])new Object[]{" B ", "XXX", Character.valueOf('X'), cobble, Character.valueOf('B'), Items.field_151072_bj});
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150367_z), (Object[])new Object[]{"XXX", "XBX", "XRX", Character.valueOf('X'), cobble, Character.valueOf('B'), Items.field_151031_f, Character.valueOf('R'), Items.field_151137_ax});
            });
            StonesRegistry.INSTANCE.stonesFor(UBStoneStyle.STONE).forEach(stoneEntry -> {
                Item stone = stoneEntry.getItemBlock();
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150456_au), (Object[])new Object[]{"XX", Character.valueOf('X'), stone});
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.field_151107_aW), (Object[])new Object[]{"TRT", "XXX", Character.valueOf('X'), stone, Character.valueOf('T'), Blocks.field_150429_aA, Character.valueOf('R'), Items.field_151137_ax});
            });
        }
        if (!UBConfig.SPECIFIC.buttonsOn() && UBConfig.SPECIFIC.ubifyRecipes()) {
            StonesRegistry.INSTANCE.stonesFor(UBStoneStyle.STONE).forEach(stoneEntry -> GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150430_aB), (Object[])new Object[]{stoneEntry.getItemBlock()}));
        }
        if (!UBConfig.SPECIFIC.wallsOn() && UBConfig.SPECIFIC.ubifyRecipes()) {
            StonesRegistry.INSTANCE.stonesFor(UBStoneStyle.COBBLE).forEach(cobbleEntry -> GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150463_bK, 6), (Object[])new Object[]{"XXX", "XXX", Character.valueOf('X'), cobbleEntry.getItemBlock()}));
        }
        if (!UBConfig.SPECIFIC.stairsOn() && UBConfig.SPECIFIC.ubifyRecipes()) {
            StonesRegistry.INSTANCE.stonesFor(UBStoneStyle.COBBLE).forEach(cobbleEntry -> GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150446_ar, 4), (Object[])new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), cobbleEntry.getItemBlock()}));
            StonesRegistry.INSTANCE.stonesFor(UBStoneStyle.BRICK).forEach(brickEntry -> GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150390_bg, 4), (Object[])new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), brickEntry.getItemBlock()}));
        }
        ((UBConfig)UBConfig.SPECIFIC).regularStoneCrafting.addTrackerAndUpdate(new RegularStoneRecipe());
        ((UBConfig)UBConfig.SPECIFIC).changeButtonRecipe.addTrackerAndUpdate(new ButtonRecipe());
    }
}

