/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.config;

import com.google.common.collect.ImmutableSet;
import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.api.common.UBLogger;
import exterminatorjeff.undergroundbiomes.api.common.UBSettings;
import exterminatorjeff.undergroundbiomes.api.enums.IgneousVariant;
import exterminatorjeff.undergroundbiomes.api.enums.MetamorphicVariant;
import exterminatorjeff.undergroundbiomes.api.enums.SedimentaryVariant;
import exterminatorjeff.undergroundbiomes.api.names.BlockAccess;
import exterminatorjeff.undergroundbiomes.api.names.BlockEntry;
import exterminatorjeff.undergroundbiomes.api.names.VanillaBlockAccess;
import exterminatorjeff.undergroundbiomes.config.BooleanSetting;
import exterminatorjeff.undergroundbiomes.config.FloatSetting;
import exterminatorjeff.undergroundbiomes.config.IntegerSetting;
import exterminatorjeff.undergroundbiomes.config.StringSetting;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class UBConfig
implements UBSettings {
    public static UBSettings SPECIFIC;
    static final UBLogger LOGGER;
    private Configuration configuration;
    private final HashMap<BlockAccess, HashMap<Integer, BooleanSetting>> stoneGenerationSettings = new HashMap();
    private static final String CATEGORY_GENERAL = "General";
    public final BooleanSetting crashOnProblems = new BooleanSetting("General", "CrashOnProblems");
    public final BooleanSetting realistic = new BooleanSetting("General", "Realistic");
    private static final String CATEGORY_CONTENT = "Content";
    public final BooleanSetting ubifyRecipes = new BooleanSetting("Content", "UBifyRecipes");
    public final BooleanSetting ubifyOres = new BooleanSetting("Content", "UBifyOres");
    public final IntegerSetting regularStoneCrafting = new IntegerSetting("Content", "RegularStoneCrafting");
    public final FloatSetting hardnessModifier = new FloatSetting("Content", "HarnessModifier");
    public final FloatSetting resistanceModifier = new FloatSetting("Content", "ResistanceModifier");
    private static final String CATEGORY_GENERATION = "World generation";
    public final IntegerSetting biomeSize = new IntegerSetting("World generation", "BiomeSize");
    public final IntegerSetting generationHeight = new IntegerSetting("World generation", "GenerationHeight");
    public final BooleanSetting regularStoneBiomes = new BooleanSetting("World generation", "RegularStoneBiomes");
    public final BooleanSetting harmoniousStrata = new BooleanSetting("World generation", "HarmoniousStrata");
    public final StringSetting includedDimensions = new StringSetting("World generation", "IncludedDimensions");
    public Set<Integer> includedDimensionsSet;
    public final StringSetting excludedDimensions = new StringSetting("World generation", "ExcludedDimensions");
    public Set<Integer> excludedDimensionsSet;
    public final BooleanSetting dimensionSpecificSeeds = new BooleanSetting("World generation", "DimensionSpecificSeeds");
    public final BooleanSetting ubifyVillages = new BooleanSetting("World generation", "UBifyVillages");
    private static final String CATEGORY_VISUAL = "Visual";
    public final BooleanSetting plainSlabTextures = new BooleanSetting("Visual", "PlainSlabTextures");
    private static final String CATEGORY_SPECIFIC = "Specific";
    public final BooleanSetting buttonsOn = new BooleanSetting("Specific", "UndergroundBiomesButtons");
    public final IntegerSetting buttonsTypes = new IntegerSetting("Specific", "UndergroundBiomesButtonsTypes");
    public final IntegerSetting buttonsStyles = new IntegerSetting("Specific", "UndergroundBiomesButtonsStyles");
    public final BooleanSetting stairsOn = new BooleanSetting("Specific", "UndergroundBiomesStairs");
    public final IntegerSetting stairsTypes = new IntegerSetting("Specific", "UndergroundBiomesStairsTypes");
    public final IntegerSetting stairsStyles = new IntegerSetting("Specific", "UndergroundBiomesStairsStyles");
    public final BooleanSetting wallsOn = new BooleanSetting("Specific", "UndergroundBiomesWalls");
    public final IntegerSetting wallsTypes = new IntegerSetting("Specific", "UndergroundBiomesWallsTypes");
    public final IntegerSetting wallsStyles = new IntegerSetting("Specific", "UndergroundBiomesWallsStyles");
    private static final String CATEGORY_MISCELLANEOUS = "Miscellaneaous";
    public final IntegerSetting changeButtonRecipe = new IntegerSetting("Miscellaneaous", "ChangeButtonRecipe");
    public final BooleanSetting disableVanillaStoneVariants = new BooleanSetting("Miscellaneaous", "DisableVanillaStoneVariants");

    public UBConfig() {
        this.setActivations(API.IGNEOUS_STONE, "igneous stone", IgneousVariant.values());
        this.setActivations(API.METAMORPHIC_STONE, "metamorphic stone", MetamorphicVariant.values());
        this.setActivations(API.SEDIMENTARY_STONE, "sedimentary stone", SedimentaryVariant.values());
        this.setActivation((Block)Blocks.field_150354_m, 0);
        this.setActivation(Blocks.field_150322_A, 0);
        this.setActivation(Blocks.field_150348_b, 0);
    }

    private void setActivations(BlockEntry block, String type, IStringSerializable[] names) {
        HashMap<Integer, BooleanSetting> blockActivations = new HashMap<Integer, BooleanSetting>();
        this.stoneGenerationSettings.put(block, blockActivations);
        for (int i = 0; i < names.length; ++i) {
            BooleanSetting generationConfig = new BooleanSetting(CATEGORY_GENERATION, "Generate " + type + " metadata " + i + ", " + names[i].func_176610_l());
            blockActivations.put(i, generationConfig);
        }
    }

    private void setActivation(Block block, int metadata) {
        HashMap<Integer, BooleanSetting> blockActivations = new HashMap<Integer, BooleanSetting>();
        this.stoneGenerationSettings.put(new VanillaBlockAccess(block), blockActivations);
        BooleanSetting generationConfig = new BooleanSetting(CATEGORY_GENERATION, "Generate " + block.func_149739_a() + ", metadata " + metadata);
        blockActivations.put(metadata, generationConfig);
    }

    public void init(File file) {
        ImmutableSet.Builder builder;
        LOGGER.info("Loading configuration");
        this.configuration = new Configuration(file);
        this.configuration.load();
        this.crashOnProblems.initProperty(this.configuration, false, "Crash rather than try to get by when encountering problems");
        this.realistic.initProperty(this.configuration, false, "Only cobble walls, only stone button, no stone stairs\nDisable regular stone variants\nOverrides any specific settings");
        this.ubifyRecipes.initProperty(this.configuration, true, "Modify all recipes to include Underground Biomes stones");
        this.ubifyOres.initProperty(this.configuration, true, "Convert ores to have Underground Biomes stone background textures");
        this.regularStoneCrafting.initProperty(this.configuration, 4, "0 = none\n1 = one rock\n2 = with redstone\n3 = 2x2 stone, lose 3\n4 = 2x2 stone");
        this.hardnessModifier.initProperty(this.configuration, Float.valueOf(1.0f), "Increase to make stone longer to mine. Normal is 1.0");
        this.resistanceModifier.initProperty(this.configuration, Float.valueOf(1.0f), "Increase to make stone more resistant to explosions. Normal is 1.0");
        this.biomeSize.initProperty(this.configuration, 4, "Interval [1-16]\nWarning: exponential");
        this.generationHeight.initProperty(this.configuration, 256, "Maximum height for UB world generation");
        this.regularStoneBiomes.initProperty(this.configuration, false, "Integrate vanilla stone into the world generation\nWill cause sharp biome transitions if changed while playing the same world");
        this.harmoniousStrata.initProperty(this.configuration, false, "Avoid jarring strata transitions");
        this.includedDimensions.initProperty(this.configuration, "*", "Comma-separated list of dimension IDs, put * to use exclude list");
        this.excludedDimensions.initProperty(this.configuration, "-1,1", "Comma-separated list of dimension IDs, used only if include list is *");
        this.dimensionSpecificSeeds.initProperty(this.configuration, false, "Use a different seed for each dimensions");
        this.ubifyVillages.initProperty(this.configuration, true, "Use UB stones in villages structures");
        this.plainSlabTextures.initProperty(this.configuration, false, "Use normal stone textures for slabs");
        this.buttonsOn.initProperty(this.configuration, true, "Provide buttons for Underground Biomes blocks");
        this.buttonsTypes.initProperty(this.configuration, 7, "What types of stone for buttons : +1 for igneous, +2 for metamorphic and +4 for sedimentary\nDefault: 7 -> all");
        this.buttonsStyles.initProperty(this.configuration, 3, "What styles of stone for buttons : +1 for stone, +2 for cobble and +4 for brick\nDefault : 3 -> stone and cobble");
        this.stairsOn.initProperty(this.configuration, true, "Provide Stairs for Underground Biomes blocks");
        this.stairsTypes.initProperty(this.configuration, 7, "What types of stone for stairs : +1 for igneous, +2 for metamorphic and +4 for sedimentary\nDefault: 7 -> all");
        this.stairsStyles.initProperty(this.configuration, 7, "What styles of stone for stairs : +1 for stone, +2 for cobble and +4 for brick\nDefault : 7 -> all");
        this.wallsOn.initProperty(this.configuration, true, "Provide Walls for Underground Biomes blocks");
        this.wallsTypes.initProperty(this.configuration, 7, "What types of stone for walls : +1 for igneous, +2 for metamorphic and +4 for sedimentary\nDefault: 7 -> all");
        this.wallsStyles.initProperty(this.configuration, 7, "What styles of stone for walls : +1 for stone, +2 for cobble and +4 for brick\nDefault : 7 -> all");
        this.changeButtonRecipe.initProperty(this.configuration, 8, "Change the result of the button recipe\nDefault: 8");
        this.disableVanillaStoneVariants.initProperty(this.configuration, false, "Remove vanilla andesite, diorite, and granite");
        for (HashMap<Integer, BooleanSetting> blockActivations : this.stoneGenerationSettings.values()) {
            for (BooleanSetting setting : blockActivations.values()) {
                setting.initProperty(this.configuration, Boolean.TRUE, "");
            }
        }
        this.realistic.addOverride(true, this.wallsStyles, 2).addOverride(true, this.buttonsStyles, 1).addOverride(true, this.stairsStyles, 6).addOverride(true, this.disableVanillaStoneVariants, true);
        this.configuration.save();
        if (this.includedDimensions.getValue().equals("*")) {
            builder = ImmutableSet.builder();
            for (String v : this.excludedDimensions.property.getString().split(",")) {
                builder.add((Object)Integer.parseInt(v));
            }
            this.excludedDimensionsSet = builder.build();
            this.includedDimensionsSet = ImmutableSet.of();
        } else {
            builder = ImmutableSet.builder();
            for (String v : this.includedDimensions.property.getString().split(",")) {
                builder.add((Object)Integer.parseInt(v));
            }
            this.includedDimensionsSet = builder.build();
            this.excludedDimensionsSet = ImmutableSet.of();
        }
    }

    public void copy(UBConfig copied) {
        ImmutableSet.Builder builder;
        this.crashOnProblems.setValue(copied.crashOnProblems.getValue());
        this.realistic.setValue(copied.realistic());
        this.ubifyRecipes.setValue(copied.ubifyRecipes());
        this.ubifyOres.setValue(copied.ubifyOres());
        this.regularStoneCrafting.setValue(copied.regularStoneCrafting());
        this.hardnessModifier.setValue(Float.valueOf(copied.hardnessModifier()));
        this.resistanceModifier.setValue(Float.valueOf(copied.resistanceModifier()));
        this.biomeSize.setValue(copied.biomeSize());
        this.generationHeight.setValue(copied.generationHeight());
        this.regularStoneBiomes.setValue(copied.regularStoneBiomes());
        this.harmoniousStrata.setValue(copied.harmoniousStrata());
        this.includedDimensions.setValue(copied.includedDimensions.getValue());
        this.excludedDimensions.setValue(copied.excludedDimensions.getValue());
        this.dimensionSpecificSeeds.setValue(copied.dimensionSpecificSeeds());
        this.ubifyVillages.setValue(copied.ubifyVillages());
        this.plainSlabTextures.setValue(copied.alternativeSlabTextures());
        this.buttonsOn.setValue(copied.buttonsOn());
        this.buttonsTypes.setValue(copied.buttonsTypes.getValue());
        this.buttonsStyles.setValue(copied.buttonsStyles.getValue());
        this.stairsOn.setValue(copied.stairsOn());
        this.stairsTypes.setValue(copied.stairsTypes.getValue());
        this.stairsStyles.setValue(copied.stairsStyles.getValue());
        this.wallsOn.setValue(copied.wallsOn());
        this.wallsTypes.setValue(copied.wallsTypes.getValue());
        this.wallsStyles.setValue(copied.wallsStyles.getValue());
        this.changeButtonRecipe.setValue(copied.changeButtonRecipe.getValue());
        this.disableVanillaStoneVariants.setValue(copied.disableVanillaStoneVariants());
        this.realistic.addOverride(true, this.wallsStyles, 2).addOverride(true, this.buttonsStyles, 1).addOverride(true, this.stairsStyles, 6).addOverride(true, this.disableVanillaStoneVariants, true);
        for (BlockAccess blockAccess : copied.stoneGenerationSettings.keySet()) {
            Block block = blockAccess.getBlock();
            for (BlockAccess localAccess : this.stoneGenerationSettings.keySet()) {
                if (!localAccess.getBlock().equals(block)) continue;
                HashMap<Integer, BooleanSetting> copiedSettings = copied.stoneGenerationSettings.get(blockAccess);
                HashMap<Integer, BooleanSetting> thisSettings = this.stoneGenerationSettings.get(localAccess);
                copiedSettings.keySet().stream().forEach(metadata -> ((BooleanSetting)thisSettings.get(metadata)).setValue(((BooleanSetting)copiedSettings.get(metadata)).getValue()));
            }
        }
        if (this.includedDimensions.getValue().equals("*")) {
            builder = ImmutableSet.builder();
            for (String v : this.excludedDimensions.property.getString().split(",")) {
                builder.add((Object)Integer.parseInt(v));
            }
            this.excludedDimensionsSet = builder.build();
            this.includedDimensionsSet = ImmutableSet.of();
        } else {
            builder = ImmutableSet.builder();
            for (String v : this.includedDimensions.property.getString().split(",")) {
                builder.add((Object)Integer.parseInt(v));
            }
            this.includedDimensionsSet = builder.build();
            this.excludedDimensionsSet = ImmutableSet.of();
        }
    }

    public void save() {
        this.configuration.save();
    }

    public List<Integer> getUBifiedDimensions() {
        int[] allDims;
        ArrayList<Integer> ubifiedDims = new ArrayList<Integer>();
        ubifiedDims.addAll(this.includedDimensionsSet);
        for (int dim : allDims = DimensionManager.getDimensions((DimensionType)DimensionType.OVERWORLD)) {
            ubifiedDims.add(dim);
        }
        ubifiedDims.removeAll(this.excludedDimensionsSet);
        return ubifiedDims;
    }

    @Override
    public boolean crashOnProblems() {
        return this.crashOnProblems.getValue();
    }

    @Override
    public boolean realistic() {
        return this.realistic.getValue();
    }

    @Override
    public boolean ubifyRecipes() {
        return this.ubifyRecipes.getValue();
    }

    @Override
    public boolean ubifyOres() {
        return this.ubifyOres.getValue();
    }

    @Override
    public int regularStoneCrafting() {
        return this.regularStoneCrafting.getValue();
    }

    @Override
    public float hardnessModifier() {
        return this.hardnessModifier.getValue().floatValue();
    }

    @Override
    public float resistanceModifier() {
        return this.resistanceModifier.getValue().floatValue();
    }

    @Override
    public int biomeSize() {
        return this.biomeSize.getValue();
    }

    @Override
    public int generationHeight() {
        return this.generationHeight.getValue();
    }

    @Override
    public boolean regularStoneBiomes() {
        return this.regularStoneBiomes.getValue();
    }

    @Override
    public boolean harmoniousStrata() {
        return this.harmoniousStrata.getValue();
    }

    @Override
    public Set<Integer> includedDimensions() {
        return this.includedDimensionsSet;
    }

    @Override
    public Set<Integer> excludedDimensions() {
        return this.excludedDimensionsSet;
    }

    @Override
    public boolean dimensionSpecificSeeds() {
        return this.dimensionSpecificSeeds.getValue();
    }

    @Override
    public boolean ubifyVillages() {
        return this.ubifyVillages.getValue();
    }

    @Override
    public boolean plainSlabTextures() {
        return this.plainSlabTextures.getValue();
    }

    @Override
    public boolean buttonsOn() {
        return this.buttonsOn.getValue();
    }

    @Override
    public boolean igneousButtonsOn() {
        int i = this.buttonsTypes.getValue();
        return (i & 1) != 0;
    }

    @Override
    public boolean metamorphicButtonsOn() {
        int i = this.buttonsTypes.getValue();
        return (i & 2) != 0;
    }

    @Override
    public boolean sedimentaryButtonsOn() {
        int i = this.buttonsTypes.getValue();
        return (i & 4) != 0;
    }

    @Override
    public boolean stoneButtonsOn() {
        int i = this.buttonsStyles.getValue();
        return (i & 1) != 0;
    }

    @Override
    public boolean cobbleButtonsOn() {
        int i = this.buttonsStyles.getValue();
        return (i & 2) != 0;
    }

    @Override
    public boolean brickButtonsOn() {
        int i = this.buttonsStyles.getValue();
        return (i & 4) != 0;
    }

    @Override
    public boolean stairsOn() {
        return this.stairsOn.getValue();
    }

    @Override
    public boolean igneousStairsOn() {
        int i = this.stairsTypes.getValue();
        return (i & 1) != 0;
    }

    @Override
    public boolean metamorphicStairsOn() {
        int i = this.stairsTypes.getValue();
        return (i & 2) != 0;
    }

    @Override
    public boolean sedimentaryStairsOn() {
        int i = this.stairsTypes.getValue();
        return (i & 4) != 0;
    }

    @Override
    public boolean stoneStairsOn() {
        int i = this.stairsStyles.getValue();
        return (i & 1) != 0;
    }

    @Override
    public boolean cobbleStairsOn() {
        int i = this.stairsStyles.getValue();
        return (i & 2) != 0;
    }

    @Override
    public boolean brickStairsOn() {
        int i = this.stairsStyles.getValue();
        return (i & 4) != 0;
    }

    @Override
    public boolean wallsOn() {
        return this.wallsOn.getValue();
    }

    @Override
    public boolean igneousWallsOn() {
        int i = this.wallsTypes.getValue();
        return (i & 1) != 0;
    }

    @Override
    public boolean metamorphicWallsOn() {
        int i = this.wallsTypes.getValue();
        return (i & 2) != 0;
    }

    @Override
    public boolean sedimentaryWallsOn() {
        int i = this.wallsTypes.getValue();
        return (i & 4) != 0;
    }

    @Override
    public boolean stoneWallsOn() {
        int i = this.wallsStyles.getValue();
        return (i & 1) != 0;
    }

    @Override
    public boolean cobbleWallsOn() {
        int i = this.wallsStyles.getValue();
        return (i & 2) != 0;
    }

    @Override
    public boolean brickWallsOn() {
        int i = this.wallsStyles.getValue();
        return (i & 4) != 0;
    }

    @Override
    public int buttonRecipeResult() {
        return this.changeButtonRecipe.getValue();
    }

    @Override
    public boolean disableVanillaStoneVariants() {
        return this.disableVanillaStoneVariants.getValue();
    }

    @Override
    public boolean generationAllowed(IBlockState block) {
        int metadata = block.func_177230_c().func_176201_c(block);
        return this.generationAllowed(block.func_177230_c(), metadata);
    }

    public final boolean generationAllowed(BlockEntry block, int metadata) {
        HashMap<Integer, BooleanSetting> info = this.stoneGenerationSettings.get(block);
        if (info == null) {
            return true;
        }
        return info.get(metadata).getValue();
    }

    public final boolean generationAllowed(Block block, int metadata) {
        for (BlockAccess access : this.stoneGenerationSettings.keySet()) {
            if (!access.getBlock().equals(block)) continue;
            HashMap<Integer, BooleanSetting> info = this.stoneGenerationSettings.get(access);
            if (info == null) {
                return true;
            }
            return info.get(metadata).getValue();
        }
        throw new RuntimeException();
    }

    @Override
    public boolean alternativeSlabTextures() {
        return this.plainSlabTextures();
    }

    static {
        LOGGER = new UBLogger(UBConfig.class, Level.DEBUG);
    }
}

