/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.common.itemblock;

import exterminatorjeff.undergroundbiomes.api.common.UBStairs;
import exterminatorjeff.undergroundbiomes.api.names.BlockEntry;
import exterminatorjeff.undergroundbiomes.common.block.stairs.UBStoneStairs;
import exterminatorjeff.undergroundbiomes.common.itemblock.RotatingItemBlock;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class StairsItemBlock
extends RotatingItemBlock
implements UBStairs {
    public StairsItemBlock(BlockEntry baseStoneEntry, Class<? extends UBStoneStairs> blockClass) {
        super(baseStoneEntry);
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            Block block = null;
            try {
                block = (Block)blockClass.getConstructor(IBlockState.class, EnumFacing.class, StairsItemBlock.class).newInstance(baseStoneEntry.getBlock().func_176223_P(), facing, this);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
            this.blocks.put(facing, block);
        }
    }

    public StairsItemBlock(BlockEntry baseStoneEntry, HashMap<EnumFacing, Block> blocks) {
        super(baseStoneEntry);
        this.blocks = blocks;
    }

    @Override
    public Block getBlock(EnumFacing facing) {
        assert (facing != EnumFacing.UP && facing != EnumFacing.DOWN);
        return (Block)this.blocks.get(facing);
    }

    public Block func_179223_d() {
        return this.getBlock(EnumFacing.NORTH);
    }

    @Override
    protected Block getBlockToPlace(EntityPlayer playerIn, EnumFacing side) {
        return (Block)this.blocks.get(playerIn.func_174811_aO());
    }

    @Override
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        Block placedBlock = (Block)this.blocks.get(playerIn.func_184172_bi());
        if (stack.field_77994_a != 0 && playerIn.func_175151_a(pos, facing, stack) && worldIn.func_175716_a(placedBlock, pos, false, facing, (Entity)null, stack)) {
            int i = this.func_77647_b(stack.func_77960_j());
            IBlockState iblockstate1 = placedBlock.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)playerIn);
            if (this.placeBlockAt(stack, playerIn, worldIn, pos, facing, hitX, hitY, hitZ, iblockstate1)) {
                SoundType soundtype = worldIn.func_180495_p(pos).func_177230_c().func_185467_w();
                worldIn.func_184133_a(playerIn, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                --stack.field_77994_a;
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 3)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        for (Block block : this.blocks.values()) {
            if (state.func_177230_c() != block) continue;
            StairsItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            return true;
        }
        throw new RuntimeException(state.func_177230_c().func_149739_a());
    }
}

