/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.common.block;

import com.google.common.base.Predicate;
import exterminatorjeff.undergroundbiomes.api.common.UBBlock;
import exterminatorjeff.undergroundbiomes.client.UBCreativeTab;
import exterminatorjeff.undergroundbiomes.config.UBConfig;
import exterminatorjeff.undergroundbiomes.intermod.DropsRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class UBStone
extends Block
implements UBBlock {
    private static final float BASE_HARDNESS = 2.25f;
    private static final float BASE_RESISTANCE = 10.0f;
    protected static final float COBBLE_HARDNESS_MODIFIER = 1.333f;
    protected ItemBlock itemBlock = new UBItemBlockStone(this);

    public UBStone() {
        super(Material.field_151576_e);
        this.func_149647_a(UBCreativeTab.UB_BLOCKS_TAB);
        this.func_149711_c(UBConfig.SPECIFIC.hardnessModifier());
        this.func_149752_b(UBConfig.SPECIFIC.resistanceModifier());
        ((UBConfig)UBConfig.SPECIFIC).hardnessModifier.addTracker(hardness -> this.func_149711_c(hardness.floatValue()));
        ((UBConfig)UBConfig.SPECIFIC).resistanceModifier.addTracker(resistance -> this.func_149752_b(resistance.floatValue()));
    }

    @Override
    public Block toBlock() {
        return this;
    }

    public ItemBlock getItemBlock() {
        return this.itemBlock;
    }

    public Block func_149711_c(float hardness) {
        return super.func_149711_c(hardness * 2.25f);
    }

    public Block func_149752_b(float resistance) {
        return super.func_149752_b(resistance * 10.0f);
    }

    public float getBaseHardness() {
        return this.field_149782_v;
    }

    public float getBaseResistance() {
        return this.field_149781_w / 5.0f;
    }

    public abstract float func_176195_g(IBlockState var1, World var2, BlockPos var3);

    public abstract float getExplosionResistance(World var1, BlockPos var2, Entity var3, Explosion var4);

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        int quantity = 1;
        if (fortune != 0 && ((UBStone)state.func_177230_c()).isFortuneAffected(state)) {
            int j = random.nextInt(fortune + 2);
            quantity = j < 1 ? 1 : j;
        }
        return quantity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < this.getNbVariants(); ++i) {
            list.add(new ItemStack(itemIn, 1, i));
        }
    }

    public abstract int func_176201_c(IBlockState var1);

    public abstract IBlockState func_176203_a(int var1);

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.itemBlock;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List drops = super.getDrops(world, pos, state, fortune);
        DropsRegistry.INSTANCE.addDrops(drops, this, world, pos, state, fortune);
        return drops;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)this.itemBlock, 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        return true;
    }

    public abstract boolean isFortuneAffected(IBlockState var1);

    private class UBItemBlockStone
    extends ItemBlock {
        public UBItemBlockStone(UBStone block) {
            super((Block)block);
            this.func_77656_e(0);
            this.func_77627_a(true);
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public String func_77667_c(ItemStack stack) {
            return super.func_77658_a() + "." + UBStone.this.getVariantName(stack.func_77960_j());
        }
    }
}

