/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.api.names;

import exterminatorjeff.undergroundbiomes.api.common.UBLogger;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

public abstract class Entry<T extends IForgeRegistryEntry<?>> {
    protected static final UBLogger LOGGER = new UBLogger(Entry.class, Level.INFO);
    protected final String internalName;
    private T thing;

    public Entry(String internalName) {
        this.internalName = internalName;
    }

    public boolean isRegistered() {
        return this.thing != null;
    }

    protected final T getThing() {
        if (this.thing == null) {
            LOGGER.warn("This entry '" + this.internalName + "' is not registered!");
        }
        return this.thing;
    }

    public final void register(T thing) {
        if (this.thing != null) {
            throw new RuntimeException("This entry is already registered! (" + this.internalName + ")");
        }
        this.thing = thing;
        this.doRegister();
        LOGGER.debug("Registering '" + thing.getRegistryName() + "' for entry '" + this.internalName + "'");
    }

    protected abstract void doRegister();

    public final void registerModel(IStateMapper stateMapper) {
        if (this.thing != null) {
            if (stateMapper != null) {
                LOGGER.debug("Registering models for entry '" + this.internalName + "' with custom state mapper");
            } else {
                LOGGER.debug("Registering models for entry '" + this.internalName + "'");
            }
            this.doRegisterModel(stateMapper);
        }
    }

    protected abstract void doRegisterModel(IStateMapper var1);

    protected static String externalName(String internalName) {
        return "undergroundbiomes:" + internalName;
    }
}

