/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props.events;

import com.mia.props.DecoModelMetadata;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class SoundRegistry {
    private static HashMap<String, SoundEvent> lookupStringToEvent = new HashMap();

    public static void register(String soundPath) {
        ResourceLocation resLoc = new ResourceLocation("props", soundPath);
        SoundEvent event = new SoundEvent(resLoc);
        GameRegistry.register((IForgeRegistryEntry)event, (ResourceLocation)resLoc);
        if (lookupStringToEvent.containsKey(soundPath)) {
            System.out.println("DECOCRAFT WARNING: duplicate sound registration for " + soundPath);
        }
        lookupStringToEvent.put(soundPath, event);
    }

    public static SoundEvent get(String soundPath) {
        return lookupStringToEvent.get(soundPath);
    }

    public static void registerAllSounds(Collection<DecoModelMetadata> values) {
        lookupStringToEvent.clear();
        for (DecoModelMetadata decoModelMetadata : values) {
            if (decoModelMetadata.sound == null) continue;
            SoundRegistry.register(decoModelMetadata.sound);
        }
    }
}

