/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props;

import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.IPackReaderCallback;
import com.mia.craftstudio.api.ICSProject;
import com.mia.craftstudio.minecraft.ModelMetadata;
import com.mia.craftstudio.minecraft.forge.CSLibMod;
import com.mia.gson.Gson;
import com.mia.gson.GsonBuilder;
import com.mia.gson.JsonElement;
import com.mia.gson.JsonObject;
import com.mia.props.DecoModelMetadata;
import com.mia.props.client.container.GuiHandler;
import com.mia.props.common.BlockFake;
import com.mia.props.common.BlockProps;
import com.mia.props.common.ItemCratingClay;
import com.mia.props.common.ItemDecowand;
import com.mia.props.common.ItemProps;
import com.mia.props.common.TileFake;
import com.mia.props.common.TileTypeMap;
import com.mia.props.common.entities.EntityChairMount;
import com.mia.props.common.entities.TileDecobench;
import com.mia.props.events.CommonProxy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="props", name="DecoCraft", version="2.4.3", dependencies="after:PTRModelLib@[1.0.0,)", acceptedMinecraftVersions="[1.10.2]")
public class Props {
    @Mod.Instance(value="props")
    public static Props instance;
    @SidedProxy(clientSide="com.mia.props.events.ClientProxy", serverSide="com.mia.props.events.CommonProxy")
    public static CommonProxy proxy;
    public static final String modid = "props";
    public static Logger log;
    public static Block blockProps;
    public static Block blockFake;
    public static Item itemProps;
    public static Item itemClay;
    public static ItemDecowand itemTool;
    public static HashSet<String> recipes;
    public static Map<Integer, DecoModelMetadata> modelData;
    public static ICSProject csproject;
    public HashMap<Integer, MetaVariantListNode> modelDataVariantsList = new HashMap();
    private static Configuration config;
    public static boolean clayRecipe;
    public static boolean clayDrops;
    public static boolean allowPropRecycling;
    public static boolean enabledOldStyleRecipes;
    public static final HashSet<ItemStack> allowableResourceItems;

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        allowableResourceItems.add(new ItemStack(itemClay, 1, Short.MAX_VALUE));
        if (allowPropRecycling) {
            allowableResourceItems.add(new ItemStack(itemProps, 1, Short.MAX_VALUE));
        }
        allowableResourceItems.add(new ItemStack(Items.field_151119_aD));
        allowableResourceItems.add(new ItemStack(Blocks.field_150435_aG));
        for (TileDecobench.DyeResourceMap dyeMap : TileDecobench.DyeResourceMap.values()) {
            List dyesFound = OreDictionary.getOres((String)dyeMap.name());
            for (ItemStack dye : dyesFound) {
                allowableResourceItems.add(dye);
            }
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        File oldConfigFile = ev.getSuggestedConfigurationFile();
        File configFile = new File(ev.getModConfigurationDirectory(), "decocraft.cfg");
        if (oldConfigFile.exists() && !oldConfigFile.isDirectory()) {
            oldConfigFile.renameTo(configFile);
        }
        config = new Configuration(configFile);
        try {
            config.load();
            clayRecipe = config.getBoolean("clayRecipe", "general", true, "");
            clayDrops = config.getBoolean("clayDrops", "general", false, "");
            allowPropRecycling = config.getBoolean("allowPropRecycling", "general", true, "Allow old props to be turned back in to resources at the decobench?");
            enabledOldStyleRecipes = config.getBoolean("enabledOldStyleRecipes", "general", false, "Enable old style crafting recipes using crafting clay.");
        }
        catch (Exception e) {
            FMLLog.severe((String)"Decocraft has a problem loading it's configuration", (Object[])new Object[0]);
            FMLLog.severe((String)e.getMessage(), (Object[])new Object[0]);
            throw new RuntimeException(e);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        blockProps = (Block)new BlockProps().setRegistryName("blockProps");
        GameRegistry.register((IForgeRegistryEntry)blockProps);
        blockFake = (Block)new BlockFake().setRegistryName("blockFake");
        GameRegistry.register((IForgeRegistryEntry)blockFake);
        itemProps = (Item)new ItemProps().setRegistryName(modid);
        GameRegistry.register((IForgeRegistryEntry)itemProps);
        itemClay = (Item)new ItemCratingClay().setRegistryName("clay");
        GameRegistry.register((IForgeRegistryEntry)itemClay);
        itemTool = (ItemDecowand)new ItemDecowand().setRegistryName("tool");
        GameRegistry.register((IForgeRegistryEntry)itemTool);
        EntityRegistry.registerModEntity(EntityChairMount.class, (String)"FakeChairEntity", (int)0, (Object)instance, (int)80, (int)3, (boolean)true);
        GameRegistry.registerTileEntity(TileFake.class, (String)"TileFake");
        TileTypeMap.register();
        if (clayRecipe) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemClay, 4, 0), new Object[]{Blocks.field_150354_m, Blocks.field_150346_d, "dyeRed"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemClay, 4, 1), new Object[]{Blocks.field_150354_m, Blocks.field_150346_d, "dyeBlue"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemClay, 4, 2), new Object[]{Blocks.field_150354_m, Blocks.field_150346_d, "dyeGreen"}));
        }
        File modelListOverride = new File(ev.getModConfigurationDirectory(), "decocraftModelList.json");
        try {
            FileInputStream overrideStream = modelListOverride.exists() ? new FileInputStream(modelListOverride) : null;
            this.loadModels(overrideStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemProps, 1, 508), new Object[]{" R ", "GTB", Character.valueOf('R'), new ItemStack(itemClay, 1, 0), Character.valueOf('G'), new ItemStack(itemClay, 1, 1), Character.valueOf('B'), new ItemStack(itemClay, 1, 2), Character.valueOf('T'), Blocks.field_150462_ai}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemProps, 1, 508), new Object[]{" R ", "GTB", " C ", Character.valueOf('R'), "dyeRed", Character.valueOf('G'), "dyeGreen", Character.valueOf('B'), "dyeBlue", Character.valueOf('T'), Blocks.field_150462_ai, Character.valueOf('C'), Blocks.field_150435_aG}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemTool), new Object[]{"W", "C", "S", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('C'), new ItemStack(itemProps, 1, 508), Character.valueOf('S'), "stickWood"}));
        proxy.preInit();
    }

    private void validateModelMetadata(DecoModelMetadata metaData, CSModel model, ArrayList<Integer> variantsList) {
        if (modelData.containsKey(metaData.decocraftModelID)) {
            DecoModelMetadata existingMeta = modelData.get(metaData.decocraftModelID);
            if (!existingMeta.craftstudioAssetName.equals(metaData.craftstudioAssetName)) {
                throw new RuntimeException("You gave a new model the same DecoID as an existing model! Existing:[" + existingMeta.craftstudioAssetName + "], New:[" + metaData.craftstudioAssetName + "]");
            }
            recipes.remove(existingMeta.recipe);
        }
        variantsList.add(metaData.decocraftModelID);
        metaData.csmodel = model;
        metaData.validate();
        modelData.put(metaData.decocraftModelID, metaData);
        if (metaData.variants != null) {
            for (Map.Entry<Integer, JsonObject> entry : metaData.variants.entrySet()) {
                this.validateModelMetadata(new DecoModelMetadata(metaData, entry.getKey(), entry.getValue()), model, variantsList);
            }
        }
    }

    public void loadModels(InputStream modelListOverride) {
        Integer toolID;
        csproject = CSLibMod.getCSProjectAndLoad("Decopack", modelListOverride, new IPackReaderCallback(){
            private ProgressManager.ProgressBar progressBar = null;

            @Override
            public void modelLoaded(CSModel model, JsonElement json) {
                if (json != null) {
                    this.progressBar.step(json.getAsJsonObject().get("name").getAsString());
                }
                if (this.progressBar.getStep() == this.progressBar.getSteps()) {
                    ProgressManager.pop((ProgressManager.ProgressBar)this.progressBar);
                }
            }

            @Override
            public void setCount(int count) {
                this.progressBar = ProgressManager.push((String)"Loading models", (int)count);
            }
        });
        Gson gson = new GsonBuilder().create();
        for (Map.Entry entry : csproject.getModels().entrySet()) {
            JsonElement modelDescriptor = csproject.getDescriptor((Integer)entry.getKey());
            if (modelDescriptor == null) continue;
            if ("item_decowand".equals(modelDescriptor.getAsJsonObject().get("craftstudioAssetName").getAsString().toLowerCase())) {
                Props.itemTool.modelMeta = gson.fromJson(modelDescriptor, ModelMetadata.class);
                Props.itemTool.modelMeta.csmodel = (CSModel)entry.getValue();
                continue;
            }
            ArrayList<Integer> variantsList = new ArrayList<Integer>();
            this.validateModelMetadata(gson.fromJson(modelDescriptor, DecoModelMetadata.class), (CSModel)entry.getValue(), variantsList);
            if (variantsList.size() <= 1) continue;
            this.modelDataVariantsList.put(variantsList.get(0), new MetaVariantListNode(variantsList.get(variantsList.size() - 1), variantsList.get(1), variantsList.get(0)));
            this.modelDataVariantsList.put(variantsList.get(variantsList.size() - 1), new MetaVariantListNode(variantsList.get(variantsList.size() - 2), variantsList.get(0), variantsList.get(0)));
            int end = variantsList.size() - 1;
            for (int i = 1; i < end; ++i) {
                this.modelDataVariantsList.put(variantsList.get(i), new MetaVariantListNode(variantsList.get(i - 1), variantsList.get(i + 1), variantsList.get(0)));
            }
        }
        if (Props.itemTool.modelMeta == null && (toolID = csproject.findFirstIDfromName("Item_DecoWand")) >= 0) {
            Props.itemTool.modelMeta = new ModelMetadata();
            Props.itemTool.modelMeta.craftstudioAssetID = toolID;
            Props.itemTool.modelMeta.craftstudioAssetName = "Item_DecoWand";
            Props.itemTool.modelMeta.csmodel = csproject.getModel(toolID);
            Props.itemTool.modelMeta.scale = 2.5f;
        }
        proxy.setupModelWrappers();
    }

    public static TileEntity getTileEntityPreferNotCreating(IBlockAccess blockAccess, BlockPos pos) {
        if (blockAccess instanceof World) {
            return Props.getTileEntityWithoutCreating((World)blockAccess, pos);
        }
        if (blockAccess instanceof ChunkCache) {
            return Props.getTileEntityWithoutCreating(((ChunkCache)blockAccess).field_72815_e, pos);
        }
        return blockAccess.func_175625_s(pos);
    }

    public static TileEntity getTileEntityWithoutCreating(World world, BlockPos pos) {
        if (world.func_175668_a(pos, false)) {
            return Props.getTileEntityUnsafe(pos, world.func_175726_f(pos).func_177434_r());
        }
        return null;
    }

    private static TileEntity getTileEntityUnsafe(BlockPos pos, Map<BlockPos, TileEntity> tileMap) {
        TileEntity tileentity = tileMap.get(pos);
        if (tileentity != null && tileentity.func_145837_r()) {
            tileMap.remove(pos);
            tileentity = null;
        }
        return tileentity;
    }

    static {
        log = LogManager.getLogger((String)modid);
        recipes = new HashSet();
        modelData = new HashMap<Integer, DecoModelMetadata>(){

            @Override
            public DecoModelMetadata get(Object key) {
                return super.containsKey(key) ? (DecoModelMetadata)super.get(key) : (DecoModelMetadata)super.get(0);
            }
        };
        config = null;
        clayRecipe = true;
        clayDrops = false;
        allowPropRecycling = true;
        enabledOldStyleRecipes = false;
        allowableResourceItems = new HashSet();
    }

    public static class MetaVariantListNode {
        public Integer prevID;
        public Integer nextID;
        public Integer headID;

        public MetaVariantListNode(Integer p, Integer n, Integer h) {
            this.prevID = p;
            this.nextID = n;
            this.headID = h;
        }

        public String toString() {
            return "prevID: [" + this.prevID + "], nextID: [" + this.nextID + "], headID: [" + this.headID + "]";
        }
    }
}

