/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio.utils;

import com.mia.craftstudio.utils.FastMath;
import com.sun.imageio.plugins.png.PNGImageReader;
import gnu.trove.map.TDoubleFloatMap;
import gnu.trove.map.hash.TDoubleFloatHashMap;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class ImageIOCS {
    private static final IIORegistry theRegistry = IIORegistry.getDefaultInstance();
    private static final ImageReader pngReader = new PNGImageReader(null);
    private static final int[] mipmapBuffer = new int[4];
    static float[] cachedPow22ComponentValue = new float[256];
    static TDoubleFloatMap cachedPow045 = new TDoubleFloatHashMap();

    public static BufferedImage read(InputStream input) throws IOException {
        MemoryCacheImageInputStream stream = new MemoryCacheImageInputStream(input);
        pngReader.setInput(stream, true, true);
        BufferedImage bi = pngReader.read(0, pngReader.getDefaultReadParam());
        pngReader.dispose();
        stream.close();
        return bi;
    }

    public static int[][] generateMipmapData(int mipmapLevels, int textureWidth, int[][] inImages) {
        int[][] outImages = new int[mipmapLevels + 1][];
        outImages[0] = inImages[0];
        if (mipmapLevels > 0) {
            int level;
            boolean isTransparent = false;
            for (level = 0; level < inImages.length; ++level) {
                if (inImages[0][level] >> 24 != 0) continue;
                isTransparent = true;
                break;
            }
            for (level = 1; level <= mipmapLevels; ++level) {
                if (inImages[level] != null) {
                    outImages[level] = inImages[level];
                    continue;
                }
                int[] previousLevelImage = outImages[level - 1];
                int[] newCurrentLevelImage = new int[previousLevelImage.length >> 2];
                int currentLevelTextureWidth = textureWidth >> level;
                int currentLevelTextureHeight = newCurrentLevelImage.length / currentLevelTextureWidth;
                int previousLevelTextureWidth = currentLevelTextureWidth << 1;
                for (int x = 0; x < currentLevelTextureWidth; ++x) {
                    for (int y = 0; y < currentLevelTextureHeight; ++y) {
                        int i2 = 2 * (x + y * previousLevelTextureWidth);
                        newCurrentLevelImage[x + y * currentLevelTextureWidth] = ImageIOCS.blendColors(previousLevelImage[i2 + 0], previousLevelImage[i2 + 1], previousLevelImage[i2 + 0 + previousLevelTextureWidth], previousLevelImage[i2 + 1 + previousLevelTextureWidth], isTransparent);
                    }
                }
                outImages[level] = newCurrentLevelImage;
            }
        }
        return outImages;
    }

    private static int blendColors(int pixel1, int pixel2, int pixel3, int pixel4, boolean isTransparent) {
        if (!isTransparent) {
            return ImageIOCS.blendColorComponent(pixel1, pixel2, pixel3, pixel4, 24) << 24 | ImageIOCS.blendColorComponent(pixel1, pixel2, pixel3, pixel4, 16) << 16 | ImageIOCS.blendColorComponent(pixel1, pixel2, pixel3, pixel4, 8) << 8 | ImageIOCS.blendColorComponent(pixel1, pixel2, pixel3, pixel4, 0);
        }
        ImageIOCS.mipmapBuffer[0] = pixel1;
        ImageIOCS.mipmapBuffer[1] = pixel2;
        ImageIOCS.mipmapBuffer[2] = pixel3;
        ImageIOCS.mipmapBuffer[3] = pixel4;
        float alphaComponent = 0.0f;
        float redComponent = 0.0f;
        float greenComponent = 0.0f;
        float blueComponent = 0.0f;
        for (int pixel = 0; pixel < 4; ++pixel) {
            if (mipmapBuffer[pixel] >> 24 == 0) continue;
            alphaComponent += cachedPow22ComponentValue[mipmapBuffer[pixel] >> 24 & 0xFF];
            redComponent += cachedPow22ComponentValue[mipmapBuffer[pixel] >> 16 & 0xFF];
            greenComponent += cachedPow22ComponentValue[mipmapBuffer[pixel] >> 8 & 0xFF];
            blueComponent += cachedPow22ComponentValue[mipmapBuffer[pixel] >> 0 & 0xFF];
        }
        int alphaValue = (int)((double)ImageIOCS.fastPow045(alphaComponent * 0.25f) * 255.0);
        int redValue = (int)((double)ImageIOCS.fastPow045(redComponent * 0.25f) * 255.0);
        int greenValue = (int)(ImageIOCS.fastPow045(greenComponent * 0.25f) * 255.0f);
        int blueValue = (int)(ImageIOCS.fastPow045(blueComponent * 0.25f) * 255.0f);
        if (alphaValue < 96) {
            alphaValue = 0;
        }
        return alphaValue << 24 | redValue << 16 | greenValue << 8 | blueValue;
    }

    private static int blendColorComponent(int pixel1, int pixel2, int pixel3, int pixel4, int componentShift) {
        return (int)(ImageIOCS.fastPow045((cachedPow22ComponentValue[pixel1 >> componentShift & 0xFF] + cachedPow22ComponentValue[pixel2 >> componentShift & 0xFF] + cachedPow22ComponentValue[pixel3 >> componentShift & 0xFF] + cachedPow22ComponentValue[pixel4 >> componentShift & 0xFF]) * 0.25f) * 255.0f);
    }

    private static float fastPow045(double val) {
        if (!cachedPow045.containsKey(val)) {
            cachedPow045.put(val, (float)FastMath.pow(val, 0.45454545454545453));
        }
        return cachedPow045.get(val);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ImageIOCS.cachedPow22ComponentValue[i] = (float)FastMath.pow((float)i / 255.0f, 2.2);
        }
    }
}

