/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mia.craftstudio.CSExceptions;
import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.CSModelAnim;
import com.mia.craftstudio.CSProject;
import com.mia.craftstudio.CraftStudioLib;
import com.mia.craftstudio.IPackReaderCallback;
import com.mia.gson.JsonArray;
import com.mia.gson.JsonElement;
import com.mia.gson.JsonParser;
import com.mia.gson.stream.JsonReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CSPack {
    private final Map<Integer, ProjectEntry> entries = new HashMap<Integer, ProjectEntry>();
    private final String name;
    private byte version;
    private static final Logger LOGGER = LogManager.getLogger();
    transient CSProject project = null;
    private final IPackReaderCallback callback;

    public CSPack(String name, IPackReaderCallback callback) {
        this.name = name;
        this.callback = callback;
    }

    public String getName() {
        return this.name;
    }

    public byte getVersion() {
        return this.version;
    }

    public BiMap<Integer, ProjectEntry> getEntries() {
        return ImmutableBiMap.copyOf(this.entries);
    }

    void readPackFile(InputStream overrideStream) throws CSExceptions.NoCSProjectException {
        if (this.project == null) {
            throw new CSExceptions.NoCSProjectException();
        }
        try {
            ZipEntry ze;
            InputStream jsonStream;
            this.entries.clear();
            Locale localeOriginal = Locale.getDefault();
            LOGGER.info(String.format("Original locale was %s, switching to Locale.US", localeOriginal));
            Locale.setDefault(Locale.US);
            LOGGER.info(String.format("Locale is now %s", Locale.getDefault()));
            HashMap<Integer, JsonElement> descriptors = new HashMap<Integer, JsonElement>();
            String path = String.format("%s/%s", this.project.getProjectAssetPath(), this.name);
            ZipInputStream zis = new ZipInputStream(CSPack.class.getResourceAsStream(path));
            InputStream inputStream = jsonStream = overrideStream != null ? overrideStream : CSPack.class.getResourceAsStream(String.format("%s/%s", this.project.getProjectAssetPath(), this.name.replace(".cspack", ".json")));
            if (jsonStream != null) {
                JsonElement rootElement;
                int len;
                byte[] buffer = new byte[4096];
                ByteArrayOutputStream outstream = new ByteArrayOutputStream();
                while ((len = jsonStream.read(buffer)) != -1) {
                    outstream.write(buffer, 0, len);
                }
                String jsonString = outstream.toString();
                try {
                    JsonParser jsonParser = new JsonParser();
                    JsonReader jsonReader = new JsonReader(new StringReader(jsonString));
                    jsonReader.setLenient(true);
                    rootElement = jsonParser.parse(jsonReader);
                }
                catch (Throwable e) {
                    LOGGER.error(outstream.toString());
                    throw new RuntimeException(e);
                }
                if (rootElement.isJsonArray()) {
                    JsonArray jsonList = rootElement.getAsJsonArray();
                    for (JsonElement element : jsonList) {
                        if (!element.isJsonObject()) continue;
                        descriptors.put(element.getAsJsonObject().get("craftstudioAssetID").getAsInt(), element);
                    }
                }
            }
            Locale.setDefault(localeOriginal);
            LOGGER.info(String.format("Locale was restored to %s", localeOriginal));
            ReadableByteChannel zipByteChan = Channels.newChannel(zis);
            if (this.callback != null) {
                this.callback.setCount(descriptors.size());
            }
            while ((ze = zis.getNextEntry()) != null) {
                ByteBuffer bbuf = ByteBuffer.allocate((int)ze.getSize());
                zipByteChan.read(bbuf);
                bbuf.order(ByteOrder.LITTLE_ENDIAN).rewind();
                if (ze.getName().indexOf(47) > 0) {
                    String[] nameParts = ze.getName().split("[/.]");
                    Integer id = Integer.valueOf(nameParts[nameParts.length - 2]);
                    String type = nameParts[nameParts.length - 1];
                    if ("csmodel".equals(type)) {
                        try {
                            CSModel model = new CSModel(bbuf);
                            this.project.addModel(id, model);
                            if (this.callback != null) {
                                this.callback.modelLoaded(model, (JsonElement)descriptors.get(id));
                            }
                        }
                        catch (CSExceptions e) {
                            CraftStudioLib.getLog().info(String.format("Skipping Asset %s: %s", id, e.getMessage()));
                        }
                    }
                    if ("csmodelanim".equals(type)) {
                        try {
                            this.project.addAnimation(id, new CSModelAnim(bbuf));
                        }
                        catch (CSExceptions e) {
                            CraftStudioLib.getLog().info(String.format("Skipping Asset %s: %s", id, e.getMessage()));
                        }
                    }
                    if (!descriptors.containsKey(id)) continue;
                    this.project.addDescriptor(id, (JsonElement)descriptors.get(id));
                    continue;
                }
                if (!"DataPackage.dat".equals(ze.getName())) continue;
                try {
                    this.readDataPackage(bbuf);
                }
                catch (CSExceptions e) {
                    CraftStudioLib.getLog().info(String.format("Error while reading CSPack: %s", e.getMessage()));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readDataPackage(ByteBuffer buffer) throws CSExceptions.UnsupportedVersionException {
        this.version = buffer.get();
        short entry_count = buffer.getShort();
        while (true) {
            short s = entry_count;
            entry_count = (short)(entry_count - 1);
            if (s <= 0) break;
            ProjectEntry entry = new ProjectEntry(buffer);
            CraftStudioLib.debug(entry);
            this.entries.put(Integer.valueOf(entry.getID()), entry);
        }
    }

    CSPack cleanup() {
        this.entries.clear();
        this.project = null;
        return this;
    }

    public static class ProjectEntry {
        private final boolean folder;
        private final short id;
        private final short parent_id;
        private final String name;
        private final byte type;
        private final boolean locked;

        public ProjectEntry(ByteBuffer buffer) {
            this.folder = buffer.get() != 0;
            this.id = buffer.getShort();
            this.parent_id = buffer.getShort();
            byte[] tmpName = new byte[buffer.get()];
            buffer.get(tmpName);
            this.name = new String(tmpName);
            this.type = buffer.get();
            boolean bl = this.locked = buffer.get() != 0;
            if (!this.folder) {
                buffer.position(buffer.position() + 5);
            }
        }

        public boolean isFolder() {
            return this.folder;
        }

        public short getID() {
            return this.id;
        }

        public short getParentID() {
            return this.parent_id;
        }

        public String getName() {
            return this.name;
        }

        public byte getType() {
            return this.type;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public String toString() {
            return String.format("ProjectEntry[%s] : Folder[%b], ID[%d], Parent[%d], Type[%d], Locked[%b]", this.name, this.folder, this.id, this.parent_id, this.type, this.locked);
        }
    }
}

