/*
 * Decompiled with CFR 0.152.
 */
package com.deco.tileentity;

import com.deco.container.ContainerCampfire;
import com.deco.container.SlotCampfireFuel;
import com.deco.crafting.CampfireRecipes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityCampfire
extends TileEntity
implements ITickable,
ISidedInventory {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};
    private ItemStack[] campfireItemStacks = new ItemStack[3];
    private int campfireBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.campfireItemStacks.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.campfireItemStacks[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a((ItemStack[])this.campfireItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a((ItemStack[])this.campfireItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean flag = stack != null && stack.func_77969_a(this.campfireItemStacks[index]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.campfireItemStacks[index]);
        this.campfireItemStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (index == 0 && !flag) {
            this.totalCookTime = this.getCookTime(stack);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return "Campfire";
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.campfireItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Slot");
            if (j < 0 || j >= this.campfireItemStacks.length) continue;
            this.campfireItemStacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        this.campfireBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityCampfire.getItemBurnTime(this.campfireItemStacks[1]);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.campfireBurnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.totalCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.campfireItemStacks.length; ++i) {
            if (this.campfireItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.campfireItemStacks[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.campfireBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory p_174903_0_) {
        return p_174903_0_.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.campfireBurnTime;
            Random rand = this.func_145831_w().field_73012_v;
            double x = (double)this.field_174879_c.func_177958_n() + 0.5;
            double y = (double)this.field_174879_c.func_177956_o() + 0.2 + (rand.nextDouble() - 0.05);
            double z = (double)this.field_174879_c.func_177952_p() + 0.5;
            this.func_145831_w().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            if (this.func_145831_w().func_72820_D() % 10L == 0L) {
                this.func_145831_w().func_175688_a(EnumParticleTypes.SMOKE_LARGE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.func_145831_w().func_72820_D() % 7L == 0L) {
                this.func_145831_w().func_184134_a(x, y, z, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.9f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.isBurning() || this.campfireItemStacks[1] != null && this.campfireItemStacks[0] != null) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.campfireBurnTime = TileEntityCampfire.getItemBurnTime(this.campfireItemStacks[1]);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (this.campfireItemStacks[1] != null) {
                            --this.campfireItemStacks[1].field_77994_a;
                            if (this.campfireItemStacks[1].field_77994_a == 0) {
                                this.campfireItemStacks[1] = this.campfireItemStacks[1].func_77973_b().getContainerItem(this.campfireItemStacks[1]);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime(this.campfireItemStacks[0]);
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getCookTime(ItemStack stack) {
        return 200;
    }

    private boolean canSmelt() {
        if (this.campfireItemStacks[0] == null) {
            return false;
        }
        ItemStack itemstack = CampfireRecipes.instance().getSmeltingResult(this.campfireItemStacks[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.campfireItemStacks[2] == null) {
            return true;
        }
        if (!this.campfireItemStacks[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.campfireItemStacks[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.campfireItemStacks[2].func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = CampfireRecipes.instance().getSmeltingResult(this.campfireItemStacks[0]);
            if (this.campfireItemStacks[2] == null) {
                this.campfireItemStacks[2] = itemstack.func_77946_l();
            } else if (this.campfireItemStacks[2].func_77973_b() == itemstack.func_77973_b()) {
                this.campfireItemStacks[2].field_77994_a += itemstack.field_77994_a;
            }
            --this.campfireItemStacks[0].field_77994_a;
            if (this.campfireItemStacks[0].field_77994_a <= 0) {
                this.campfireItemStacks[0] = null;
            }
        }
    }

    public static int getItemBurnTime(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        Item item = itemstack.func_77973_b();
        if (item == Items.field_151055_y || item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        return 0;
    }

    public static boolean isItemFuel(ItemStack itemstack) {
        return TileEntityCampfire.getItemBurnTime(itemstack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = this.campfireItemStacks[1];
        return TileEntityCampfire.isItemFuel(stack) || SlotCampfireFuel.isBucket(stack) && (itemstack == null || itemstack.func_77973_b() != Items.field_151133_ar);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public String getGuiID() {
        return "minecraft:campfire";
    }

    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCampfire(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.campfireBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.campfireBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.campfireItemStacks.length; ++i) {
            this.campfireItemStacks[i] = null;
        }
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString("Campfire");
    }
}

