/*
 * Decompiled with CFR 0.152.
 */
package com.deco.crafting;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;

public class CampfireRecipes {
    private static final CampfireRecipes smeltingBase = new CampfireRecipes();
    private Map<ItemStack, ItemStack> smeltingList = Maps.newHashMap();
    private Map<ItemStack, Float> experienceList = Maps.newHashMap();

    public static CampfireRecipes instance() {
        return smeltingBase;
    }

    private CampfireRecipes() {
        this.addSmelting(Items.field_151147_al, new ItemStack(Items.field_151157_am), 0.35f);
        this.addSmelting(Items.field_151082_bd, new ItemStack(Items.field_151083_be), 0.35f);
        this.addSmelting(Items.field_151076_bf, new ItemStack(Items.field_151077_bg), 0.35f);
        this.addSmelting(Items.field_179558_bo, new ItemStack(Items.field_179559_bp), 0.35f);
        this.addSmelting(Items.field_179561_bm, new ItemStack(Items.field_179557_bn), 0.35f);
        this.addSmelting(Items.field_151174_bG, new ItemStack(Items.field_151168_bH), 0.35f);
        this.addSmelting(Items.field_185161_cS, new ItemStack(Items.field_185162_cT), 0.1f);
        for (ItemFishFood.FishType fishtype : ItemFishFood.FishType.values()) {
            if (!fishtype.func_150973_i()) continue;
            this.addSmeltingRecipe(new ItemStack(Items.field_151115_aP, 1, fishtype.func_150976_a()), new ItemStack(Items.field_179566_aV, 1, fishtype.func_150976_a()), 0.35f);
        }
    }

    public void addSmeltingRecipeForBlock(Block input, ItemStack stack, float experience) {
        this.addSmelting(Item.func_150898_a((Block)input), stack, experience);
    }

    public void addSmelting(Item input, ItemStack stack, float experience) {
        this.addSmeltingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public void addSmeltingRecipe(ItemStack input, ItemStack stack, float experience) {
        if (this.getSmeltingResult(input) != null) {
            FMLLog.info((String)("Ignored smelting recipe with conflicting input: " + input + " = " + stack), (Object[])new Object[0]);
            return;
        }
        this.smeltingList.put(input, stack);
        this.experienceList.put(stack, Float.valueOf(experience));
    }

    public ItemStack getSmeltingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.smeltingList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.smeltingList;
    }

    public float getSmeltingExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

