/*
 * Decompiled with CFR 0.152.
 */
package com.deco.blocks;

import com.deco.blocks.SBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLightBulb
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private boolean lit;

    public BlockLightBulb(boolean light) {
        super(Material.field_151592_s);
        if (light) {
            this.func_149715_a(1.0f);
        }
        this.func_149711_c(0.3f);
        this.lit = light;
    }

    public AxisAlignedBB getCollisionBoundingBox(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return worldIn.isSideSolid(pos.func_177972_a(side.func_176734_d()), side, true);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!worldIn.isSideSolid(pos.func_177972_a(enumfacing), enumfacing.func_176734_d(), true)) continue;
            return true;
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return worldIn.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing, true) ? this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing) : this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        EnumFacing enumfacing;
        if (this.checkForDrop(world, pos, state) && !world.isSideSolid(pos.func_177972_a((enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d()), enumfacing, true)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
        if (!world.field_72995_K) {
            if (this.lit && !world.func_175640_z(pos)) {
                world.func_175684_a(pos, (Block)this, 4);
            } else if (!this.lit && world.func_175640_z(pos)) {
                world.func_180501_a(pos, SBlocks.lightBulbOn.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 2);
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && this.lit && !worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, SBlocks.lightBulbOff.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 2);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            if (this.lit && !worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, SBlocks.lightBulbOff.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 2);
            } else if (this.lit && worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, SBlocks.lightBulbOn.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 2);
            }
        }
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_176196_c(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return false;
        }
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float f2 = 0.125f;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return new AxisAlignedBB(0.0, 0.375, 0.3125, (double)f2, 0.625, 0.6875);
            }
            case WEST: {
                return new AxisAlignedBB((double)(1.0f - f2), 0.375, 0.3125, 1.0, 0.625, 0.6875);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.3125, 0.375, 0.0, 0.6875, 0.625, (double)f2);
            }
            case NORTH: {
                return new AxisAlignedBB(0.3125, 0.375, (double)(1.0f - f2), 0.6875, 0.625, 1.0);
            }
            case UP: {
                return new AxisAlignedBB(0.3125, 0.0, 0.375, 0.6875, (double)(0.0f + f2), 0.625);
            }
            case DOWN: {
                return new AxisAlignedBB(0.3125, (double)(1.0f - f2), 0.375, 0.6875, 1.0, 0.625);
            }
        }
        return new AxisAlignedBB(0.3125, (double)(1.0f - f2), 0.375, 0.6875, 1.0, 0.625);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.notifyNeighbors(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
        super.func_180663_b(worldIn, pos, state);
    }

    private void notifyNeighbors(World worldIn, BlockPos pos, EnumFacing facing) {
        worldIn.func_175685_c(pos, (Block)this);
        worldIn.func_175685_c(pos.func_177972_a(facing.func_176734_d()), (Block)this);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing;
        switch (meta & 7) {
            case 0: {
                enumfacing = EnumFacing.DOWN;
                break;
            }
            case 1: {
                enumfacing = EnumFacing.EAST;
                break;
            }
            case 2: {
                enumfacing = EnumFacing.WEST;
                break;
            }
            case 3: {
                enumfacing = EnumFacing.SOUTH;
                break;
            }
            case 4: {
                enumfacing = EnumFacing.NORTH;
                break;
            }
            default: {
                enumfacing = EnumFacing.UP;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        int i;
        switch (SwitchEnumFacing.FACING_LOOKUP[((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal()]) {
            case 1: {
                i = 1;
                break;
            }
            case 2: {
                i = 2;
                break;
            }
            case 3: {
                i = 3;
                break;
            }
            case 4: {
                i = 4;
                break;
            }
            default: {
                i = 5;
                break;
            }
            case 6: {
                i = 0;
            }
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    static final class SwitchEnumFacing {
        static final int[] FACING_LOOKUP = new int[EnumFacing.values().length];

        SwitchEnumFacing() {
        }

        static {
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.EAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError var6) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError var5) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.SOUTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError var4) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.NORTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError var3) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError var2) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

