/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.misc;

import de.eydamos.backpack.item.EBackpack;
import de.eydamos.backpack.item.EFrame;
import de.eydamos.backpack.item.EPiece;
import de.eydamos.backpack.item.EStick;
import de.eydamos.backpack.item.ItemBackpack;
import de.eydamos.backpack.item.ItemFunctionless;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Bootstrap {
    private static boolean alreadyRegistered = false;

    public static boolean isRegistered() {
        return alreadyRegistered;
    }

    public static void register() {
        if (!alreadyRegistered) {
            Bootstrap.registerItems();
            alreadyRegistered = true;
        }
    }

    private static void registerItems() {
        for (Items item : Items.values()) {
            GameRegistry.register((IForgeRegistryEntry)item.getItem());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerVariants() {
        for (Items item : Items.values()) {
            Hashtable<Integer, String> variants = item.getVariants();
            if (variants == null) continue;
            for (String variant : variants.values()) {
                String identifier = "backpack:" + item.getUnlocalizedName() + '_' + variant;
                ModelBakery.registerItemVariants((Item)item.getItem(), (ResourceLocation[])new ResourceLocation[]{item.getResource(identifier)});
            }
        }
    }

    public static void registerIcons() {
        ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        for (Items item : Items.values()) {
            String identifier = "backpack:" + item.getUnlocalizedName();
            Hashtable<Integer, String> variants = item.getVariants();
            if (variants == null) {
                mesher.func_178086_a(item.getItem(), 0, item.getResource(identifier));
                continue;
            }
            for (Map.Entry<Integer, String> variant : variants.entrySet()) {
                String variantIdentifier = identifier + '_' + variant.getValue();
                mesher.func_178086_a(item.getItem(), variant.getKey().intValue(), item.getResource(variantIdentifier));
            }
        }
    }

    private static enum Items {
        BACKPACK("backpack", ItemBackpack.class, 1, true, EBackpack.getVariants()),
        BOUND_LEATHER("bound_leather", ItemFunctionless.class, 64, false, null),
        TANNED_LEATHER("tanned_leather", ItemFunctionless.class, 64, false, null),
        STICK("stick", ItemFunctionless.class, 64, true, EStick.getVariants()),
        BACKPACK_FRAME("backpack_frame", ItemFunctionless.class, 1, true, EFrame.getVariants()),
        BACKPACK_PIECE("backpack_piece", ItemFunctionless.class, 1, true, EPiece.getVariants());

        private Item item;
        private final Class clazz;
        private final String unlocalizedName;
        private final int stackSize;
        private final boolean hasSubTypes;
        private final Hashtable<Integer, String> variants;

        private Items(String unlocalizedName, Class clazz, int stackSize, boolean hasSubTypes, Hashtable<Integer, String> variants) {
            this.unlocalizedName = unlocalizedName;
            this.clazz = clazz;
            this.stackSize = stackSize;
            this.hasSubTypes = hasSubTypes;
            this.variants = variants;
        }

        public Item getItem() {
            if (this.item == null) {
                if (this.clazz == ItemFunctionless.class) {
                    this.item = new ItemFunctionless(this.unlocalizedName, this.stackSize, this.hasSubTypes);
                } else if (this.clazz == ItemBackpack.class) {
                    this.item = new ItemBackpack();
                    EBackpack.setItem(this.item);
                }
            }
            return this.item;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public Hashtable<Integer, String> getVariants() {
            return this.variants;
        }

        public ModelResourceLocation getResource(String identifier) {
            return new ModelResourceLocation(identifier, "inventory");
        }
    }
}

