/*
 * Decompiled with CFR 0.152.
 */
package primetoxinz.coralreef;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import primetoxinz.coralreef.BlockCoral;
import primetoxinz.coralreef.BlockReef;
import primetoxinz.coralreef.CoralReef;

public class ReefWorldGenerator
implements IWorldGenerator {
    private WorldGenerator genCoralReef = new WorldGenReef();
    private WorldGenerator genSmallReef = new WorldGenSmallReef();

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            this.runGenerator(world, rand, chunkX, chunkZ, 0, world.func_181545_F() - 4);
        }
    }

    private void runGenerator(World world, Random rand, int chunk_X, int chunk_Z, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        if (rand.nextInt(CoralReef.reefClusterRarity) == 0) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int z = chunk_Z * 16 + rand.nextInt(16);
            int y = MathHelper.func_76125_a((int)ReefWorldGenerator.getTopSolidOrLiquidBlock(world, new BlockPos(x, 64, z)).func_177956_o(), (int)minHeight, (int)maxHeight);
            BlockPos position = new BlockPos(x, y, z);
            Biome biome = world.func_180494_b(position);
            if (CoralReef.onlyOcean && BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET)) {
                this.genCoralReef.func_180709_b(world, rand, position);
            }
        }
    }

    public static BlockPos getTopSolidOrLiquidBlock(World world, BlockPos pos) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0 && (!(state = chunk.func_177435_g(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76220_a() || state.func_185904_a().func_76224_d() || state.func_177230_c().isLeaves(state, (IBlockAccess)world, blockpos1) || state.func_177230_c().isFoliage((IBlockAccess)world, blockpos1))) {
            blockpos = blockpos1;
        }
        return blockpos.func_177977_b();
    }

    public class WorldGenSmallReef
    extends WorldGenerator {
        private final IBlockState block;
        private final int startRadius;

        public WorldGenSmallReef() {
            super(false);
            this.block = CoralReef.reef.func_176223_P().func_177226_a((IProperty)BlockReef.VARIANTS, (Comparable)Integer.valueOf(1));
            this.startRadius = 2;
        }

        public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
            if (rand.nextInt(4) != 0) {
                return true;
            }
            while (true) {
                Block block;
                if (position.func_177956_o() <= 3 || !worldIn.func_175623_d(position.func_177977_b()) && ((block = worldIn.func_180495_p(position.func_177977_b()).func_177230_c()) == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150348_b)) {
                    if (position.func_177956_o() <= 3) {
                        return false;
                    }
                    int i1 = this.startRadius;
                    for (int i = 0; i1 >= 0 && i < 3; ++i) {
                        int j = i1 + rand.nextInt(2);
                        int k = i1 + rand.nextInt(2);
                        int l = i1 + rand.nextInt(2);
                        float f = (float)(j + k + l) * 0.333f + 0.5f;
                        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
                            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f))) continue;
                            worldIn.func_180501_a(blockpos, this.block, 4);
                        }
                        position = position.func_177982_a(-(i1 + 1) + rand.nextInt(2 + i1 * 2), 0 - rand.nextInt(2), -(i1 + 1) + rand.nextInt(2 + i1 * 2));
                    }
                    return true;
                }
                position = position.func_177977_b();
            }
        }
    }

    public class WorldGenReef
    extends WorldGenerator {
        public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
            int r = MathHelper.func_76125_a((int)rand.nextInt(CoralReef.maxRadius), (int)CoralReef.minRadius, (int)CoralReef.maxRadius);
            int smallreefcount = 0;
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    Block block;
                    BlockPos pos = ReefWorldGenerator.getTopSolidOrLiquidBlock(worldIn, new BlockPos(position.func_177958_n() + x, position.func_177956_o(), position.func_177952_p() + z));
                    if (x * x + z * z > r * r || rand.nextInt(r) < r / 2 || pos.func_177956_o() > worldIn.func_181545_F() - 5) continue;
                    if (rand.nextInt(CoralReef.smallReefRarity * 2) == 0) {
                        ReefWorldGenerator.this.genSmallReef.func_180709_b(worldIn, rand, pos);
                        ++smallreefcount;
                    }
                    if ((block = worldIn.func_180495_p(pos).func_177230_c()) != Blocks.field_150351_n && block != Blocks.field_150346_d && block != Blocks.field_150354_m || !worldIn.func_175656_a(pos, CoralReef.reef.func_176223_P())) continue;
                    IBlockState variant = CoralReef.coral.func_176223_P().func_177226_a((IProperty)BlockCoral.VARIANTS, (Comparable)Integer.valueOf(rand.nextInt(6)));
                    for (int i = 1; i <= rand.nextInt(4); ++i) {
                        if (!CoralReef.coral.canBlockStay(worldIn, pos.func_177981_b(i), variant)) continue;
                        worldIn.func_175656_a(pos.func_177981_b(i), variant);
                    }
                }
            }
            return true;
        }
    }
}

