/*
 * Decompiled with CFR 0.152.
 */
package primetoxinz.coralreef;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import primetoxinz.coralreef.BlockCoral;
import primetoxinz.coralreef.BlockReef;
import primetoxinz.coralreef.ReefWorldGenerator;

@Mod(modid="coralreef", name="CoralReef", version="1.0", acceptedMinecraftVersions="[1.10.2]")
public class CoralReef {
    public static BlockCoral coral;
    public static BlockReef reef;
    public static Configuration config;
    public static int reefClusterRarity;
    public static int minRadius;
    public static int maxRadius;
    public static int smallReefRarity;
    public static int coralLightLevel;
    public static boolean onlyOcean;
    public static boolean bubbles;
    public static boolean grow;
    @SidedProxy(clientSide="primetoxinz.coralreef.CoralReef$ClientProxy", serverSide="primetoxinz.coralreef.CoralReef$CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        config = new Configuration(e.getSuggestedConfigurationFile());
        config.load();
        reefClusterRarity = config.getInt("reefClusterRarity", "general", 16, 0, Integer.MAX_VALUE, "Rarity of reef clustersv, lower values are more common");
        smallReefRarity = config.getInt("largeCoralRarity", "general", 64, 0, Integer.MAX_VALUE, "Rarity of small reef blocks, lower values are more common");
        minRadius = config.getInt("minRadius", "general", 8, 0, 128, "Minimum coral radius");
        maxRadius = config.getInt("maxRadius", "general", 32, 0, 128, "Max coral radius");
        coralLightLevel = config.getInt("coralLightLevel", "general", 15, 0, 15, "Coral Light Level");
        onlyOcean = config.getBoolean("onlyOcean", "general", true, "Does coral spawn only in ocean(true) or all water(false)");
        bubbles = config.getBoolean("bubbles", "general", true, "Does coral spawn bubbles");
        grow = config.getBoolean("grow", "general", true, "Does coral grow");
        config.save();
        coral = new BlockCoral();
        reef = new BlockReef();
        proxy.registerItems();
        MinecraftForge.EVENT_BUS.register((Object)this);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ReefWorldGenerator(), (int)1);
        OreDictionary.registerOre((String)"dyeOrange", (ItemStack)new ItemStack((Block)coral, 1, 0));
        OreDictionary.registerOre((String)"dyeMagenta", (ItemStack)new ItemStack((Block)coral, 1, 1));
        OreDictionary.registerOre((String)"dyePink", (ItemStack)new ItemStack((Block)coral, 1, 2));
        OreDictionary.registerOre((String)"dyeCyan", (ItemStack)new ItemStack((Block)coral, 1, 3));
        OreDictionary.registerOre((String)"dyeGreen", (ItemStack)new ItemStack((Block)coral, 1, 4));
        OreDictionary.registerOre((String)"dyeGray", (ItemStack)new ItemStack((Block)coral, 1, 5));
    }

    public static class ClientProxy
    extends CommonProxy {
        @Override
        public void registerItems() {
            int i;
            for (i = 0; i <= 5; ++i) {
                this.registerItemModel(Item.func_150898_a((Block)coral), i, "coralreef:coral" + (i + 1));
            }
            for (i = 0; i <= 1; ++i) {
                this.registerItemModel(Item.func_150898_a((Block)reef), i, "coralreef:reef" + (i + 1));
            }
        }

        public void registerItemModel(Item item, int meta, String name) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    public static class CommonProxy {
        public void registerItems() {
        }
    }
}

