/*
 * Decompiled with CFR 0.152.
 */
package primetoxinz.coralreef;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import primetoxinz.coralreef.CoralReef;
import primetoxinz.coralreef.ItemBlockMeta;

public class BlockCoral
extends Block
implements IPlantable {
    public static final EnumPlantType CORAL = EnumPlantType.getPlantType((String)"Coral");
    public static final PropertyInteger VARIANTS = PropertyInteger.func_177719_a((String)"variants", (int)0, (int)5);
    protected static final AxisAlignedBB CORAL_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public BlockCoral() {
        super(Material.field_151586_h);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149663_c("coral");
        this.setRegistryName("coral");
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockMeta(this), (ResourceLocation)this.getRegistryName());
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)VARIANTS, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(15)));
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i <= 5; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, ((Integer)state.func_177229_b((IProperty)VARIANTS)).intValue());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockLiquid.field_176367_b, VARIANTS});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANTS, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VARIANTS);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CORAL_AABB;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        this.checkAndDropBlock(world, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (CoralReef.grow) {
            // empty if block
        }
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VARIANTS);
    }

    protected boolean checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (this.canBlockStay(worldIn, pos, state)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (worldIn.func_180495_p(pos.func_177981_b(2)).func_185904_a() != Material.field_151586_h) {
            return false;
        }
        if (block.canSustainPlant(state, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this)) {
            return true;
        }
        if (block == this) {
            int variant = (Integer)state.func_177229_b((IProperty)VARIANTS);
            return variant > 3;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        if (CoralReef.bubbles && world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151586_h) {
            double offset = 0.0625;
            for (int i = 0; i < 6; ++i) {
                double x1 = (double)pos.func_177958_n() + rand.nextDouble();
                double y1 = (double)pos.func_177956_o() + rand.nextDouble();
                double z1 = (double)pos.func_177952_p() + rand.nextDouble();
                if (i == 0 && !world.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                    y1 = (double)(pos.func_177956_o() + 1) + offset;
                }
                if (i == 1 && !world.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                    y1 = (double)(pos.func_177956_o() + 0) - offset;
                }
                if (i == 2 && !world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH)).func_185914_p()) {
                    z1 = (double)(pos.func_177952_p() + 1) + offset;
                }
                if (i == 3 && !world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH)).func_185914_p()) {
                    z1 = (double)(pos.func_177952_p() + 0) - offset;
                }
                if (i == 4 && !world.func_180495_p(pos.func_177972_a(EnumFacing.EAST)).func_185914_p()) {
                    x1 = (double)(pos.func_177958_n() + 1) + offset;
                }
                if (i == 5 && !world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_185914_p()) {
                    x1 = (double)(pos.func_177958_n() + 0) - offset;
                }
                if (!(x1 < (double)pos.func_177958_n() || x1 > (double)(pos.func_177958_n() + 1) || y1 < 0.0 || y1 > (double)(pos.func_177956_o() + 1) || z1 < (double)pos.func_177952_p()) && !(z1 > (double)(pos.func_177952_p() + 1))) continue;
                world.func_175688_a(EnumParticleTypes.WATER_BUBBLE, x1, y1, z1, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return this.func_176196_c(world, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return CoralReef.coralLightLevel;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return CORAL;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }
}

