/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.spawners;

import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.spawners.Spawnable;
import greymerk.roguelike.worldgen.spawners.SpawnerSettings;
import java.util.Random;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;

public enum Spawner {
    CREEPER((String)EntityList.field_75626_c.get(EntityCreeper.class)),
    CAVESPIDER((String)EntityList.field_75626_c.get(EntityCaveSpider.class)),
    SPIDER((String)EntityList.field_75626_c.get(EntitySpider.class)),
    SKELETON((String)EntityList.field_75626_c.get(EntitySkeleton.class)),
    ZOMBIE((String)EntityList.field_75626_c.get(EntityZombie.class)),
    SILVERFISH((String)EntityList.field_75626_c.get(EntitySilverfish.class)),
    ENDERMAN((String)EntityList.field_75626_c.get(EntityEnderman.class)),
    WITCH((String)EntityList.field_75626_c.get(EntityWitch.class)),
    WITHERBOSS((String)EntityList.field_75626_c.get(EntityWither.class)),
    BAT((String)EntityList.field_75626_c.get(EntityBat.class)),
    LAVASLIME((String)EntityList.field_75626_c.get(EntityMagmaCube.class)),
    BLAZE((String)EntityList.field_75626_c.get(EntityBlaze.class)),
    SLIME((String)EntityList.field_75626_c.get(EntitySlime.class)),
    PRIMEDTNT((String)EntityList.field_75626_c.get(EntityTNTPrimed.class)),
    PIGZOMBIE((String)EntityList.field_75626_c.get(EntityPigZombie.class));

    private String name;
    private static final Spawner[] common;

    private Spawner(String name) {
        this.name = name;
    }

    public static String getName(Spawner type) {
        return type.name;
    }

    public static void generate(IWorldEditor editor, Random rand, LevelSettings settings, Coord cursor) {
        Spawner type = common[rand.nextInt(common.length)];
        Spawner.generate(editor, rand, settings, cursor, type);
    }

    public static void generate(IWorldEditor editor, Random rand, LevelSettings settings, Coord cursor, Spawner type) {
        int difficulty = settings.getDifficulty(cursor);
        SpawnerSettings spawners = settings.getSpawners();
        if (spawners == null) {
            new Spawnable(type).generate(editor, rand, cursor, difficulty);
            return;
        }
        spawners.generate(editor, rand, cursor, type, difficulty);
    }

    static {
        common = new Spawner[]{SPIDER, SKELETON, ZOMBIE};
    }
}

