/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.blocks;

import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;

public enum Door {
    IRON,
    OAK,
    BIRCH,
    SPRUCE,
    JUNGLE,
    ACACIA,
    DARKOAK;


    public static void generate(IWorldEditor editor, Coord pos, Cardinal dir, Door type) {
        Door.generate(editor, pos, dir, type, false);
    }

    public static void generate(IWorldEditor editor, Coord pos, Cardinal dir, Door type, boolean open) {
        Coord cursor = new Coord(pos);
        MetaBlock doorBase = Door.getMeta(type, false, dir, open, false);
        doorBase.set(editor, cursor);
        cursor.add(Cardinal.UP);
        MetaBlock doorTop = Door.getMeta(type, true, dir, open, false);
        doorTop.set(editor, cursor);
    }

    private static MetaBlock getMeta(Door type, boolean top, Cardinal dir, boolean open, boolean hingeLeft) {
        MetaBlock door;
        switch (type) {
            case IRON: {
                door = new MetaBlock(Blocks.field_150454_av.func_176223_P());
                break;
            }
            case BIRCH: {
                door = new MetaBlock(Blocks.field_180412_aq.func_176223_P());
                break;
            }
            case SPRUCE: {
                door = new MetaBlock(Blocks.field_180414_ap.func_176223_P());
                break;
            }
            case JUNGLE: {
                door = new MetaBlock(Blocks.field_180411_ar.func_176223_P());
                break;
            }
            case ACACIA: {
                door = new MetaBlock(Blocks.field_180410_as.func_176223_P());
                break;
            }
            case DARKOAK: {
                door = new MetaBlock(Blocks.field_180409_at.func_176223_P());
                break;
            }
            default: {
                door = new MetaBlock(Blocks.field_180413_ao.func_176223_P());
            }
        }
        door = door.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)(top ? BlockDoor.EnumDoorHalf.UPPER : BlockDoor.EnumDoorHalf.LOWER));
        door = door.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)Cardinal.facing(dir));
        door = door.func_177226_a((IProperty)BlockDoor.field_176519_b, Boolean.valueOf(open));
        door = door.func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)(hingeLeft ? BlockDoor.EnumHingePosition.LEFT : BlockDoor.EnumHingePosition.RIGHT));
        return new MetaBlock(door);
    }
}

