/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import greymerk.roguelike.treasure.loot.Enchant;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.ILoot;
import greymerk.roguelike.treasure.loot.LootProvider;
import greymerk.roguelike.treasure.loot.LootSettings;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.Shield;
import greymerk.roguelike.treasure.loot.Slot;
import greymerk.roguelike.treasure.loot.TippedArrow;
import greymerk.roguelike.treasure.loot.provider.ItemArmour;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import greymerk.roguelike.treasure.loot.provider.ItemSpecialty;
import greymerk.roguelike.treasure.loot.provider.ItemTool;
import greymerk.roguelike.treasure.loot.provider.ItemWeapon;
import greymerk.roguelike.util.TextFormat;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.monster.ZombieType;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public enum Loot {
    WEAPON,
    ARMOUR,
    BLOCK,
    JUNK,
    ORE,
    TOOL,
    POTION,
    FOOD,
    ENCHANTBOOK,
    ENCHANTBONUS,
    SUPPLY,
    MUSIC,
    SMITHY,
    SPECIAL,
    REWARD,
    STARTER;


    public static ILoot getLoot() {
        LootProvider loot = new LootProvider();
        for (int i = 0; i < 5; ++i) {
            loot.put(i, new LootSettings(i));
        }
        return loot;
    }

    public static ItemStack getEquipmentBySlot(Random rand, EntityEquipmentSlot slot, int level, boolean enchant) {
        if (slot == EntityEquipmentSlot.MAINHAND) {
            return ItemWeapon.getRandom(rand, level, enchant);
        }
        return ItemArmour.getRandom(rand, level, Slot.getSlot(slot), enchant);
    }

    public static ItemStack getEquipmentBySlot(Random rand, Slot slot, int level, boolean enchant) {
        if (slot == Slot.WEAPON) {
            return ItemWeapon.getRandom(rand, level, enchant);
        }
        return ItemArmour.getRandom(rand, level, slot, enchant);
    }

    public static void setItemLore(ItemStack item, String loreText) {
        NBTTagCompound display;
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            item.func_77982_d(tag);
        }
        if (!tag.func_74764_b("display")) {
            tag.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        if (!(display = tag.func_74775_l("display")).func_74764_b("Lore")) {
            display.func_74782_a("Lore", (NBTBase)new NBTTagList());
        }
        NBTTagList lore = display.func_150295_c("Lore", 0);
        NBTTagString toAdd = new NBTTagString(loreText);
        lore.func_74742_a((NBTBase)toAdd);
        display.func_74782_a("Lore", (NBTBase)lore);
    }

    public static void setItemLore(ItemStack item, String loreText, TextFormat option) {
        Loot.setItemLore(item, TextFormat.apply(loreText, option));
    }

    public static void setItemName(ItemStack item, String name, TextFormat option) {
        if (option == null) {
            item.func_151001_c(name);
            return;
        }
        item.func_151001_c(TextFormat.apply(name, option));
    }

    public static void setItemName(ItemStack item, String name) {
        Loot.setItemName(item, name, null);
    }

    public static void addEquipment(World world, int level, Entity mob) {
        if (level > 4) {
            level = 4;
        }
        Random rand = world.field_73012_v;
        if (mob instanceof EntityZombie) {
            ItemStack weapon;
            EntityZombie zombie = (EntityZombie)mob;
            if (rand.nextInt(10) == 0) {
                List professions = VillagerRegistry.instance().getRegistry().getValues();
                VillagerRegistry.VillagerProfession profession = (VillagerRegistry.VillagerProfession)professions.get(rand.nextInt(professions.size()));
                zombie.setVillagerType(profession);
            } else if (level > 1 && rand.nextInt(10) == 0) {
                zombie.func_189778_a(ZombieType.HUSK);
            }
            if (level > 1 && rand.nextInt(40) == 0) {
                zombie.func_82227_f(true);
                weapon = rand.nextInt(5) == 0 ? ItemNovelty.getItem(ItemNovelty.ASHLEA) : (rand.nextInt(2) == 0 ? ItemTool.getRandom(rand, level, false) : new ItemStack(Items.field_151106_aX));
            } else {
                weapon = level > 1 && rand.nextInt(50) == 0 ? ItemNovelty.getItem(ItemNovelty.AMLP) : (level > 2 && rand.nextInt(50) == 0 ? ItemNovelty.getItem(ItemNovelty.DINNERBONE) : (level > 1 && rand.nextInt(20) == 0 ? ItemSpecialty.getRandomTool(rand, Quality.get(rand, level, Equipment.SHOVEL)) : ItemTool.getRandom(rand, level, Enchant.canEnchant(world.func_175659_aa(), rand, level))));
            }
            mob.func_184201_a(EntityEquipmentSlot.MAINHAND, weapon);
            mob.func_184201_a(EntityEquipmentSlot.OFFHAND, Shield.get(rand));
        }
        if (mob instanceof EntitySkeleton) {
            if (rand.nextInt(10) == 0 && level > 1) {
                ((EntitySkeleton)mob).func_189768_a(SkeletonType.WITHER);
                mob.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemWeapon.getSword(rand, level, Enchant.canEnchant(world.func_175659_aa(), rand, level)));
            } else {
                if (rand.nextInt(10) == 0) {
                    ((EntitySkeleton)mob).func_189768_a(SkeletonType.STRAY);
                }
                if (rand.nextInt(20) == 0) {
                    if (level > 2 && rand.nextInt(10) == 0) {
                        mob.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemNovelty.getItem(ItemNovelty.NULL));
                    } else if (level > 0 && rand.nextInt(5) == 0) {
                        mob.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemNovelty.getItem(ItemNovelty.VALANDRAH));
                    } else if (level > 0 && rand.nextInt(3) == 0) {
                        mob.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemSpecialty.getRandomItem(Equipment.SWORD, rand, level));
                    } else {
                        mob.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemWeapon.getSword(rand, level, Enchant.canEnchant(world.func_175659_aa(), rand, level)));
                    }
                } else {
                    if (level > 2 && rand.nextInt(50) == 0) {
                        mob.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemNovelty.getItem(ItemNovelty.ENIKOBOW));
                    } else if (level > 1 && rand.nextInt(20) == 0) {
                        mob.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemSpecialty.getRandomItem(Equipment.BOW, rand, level));
                    } else {
                        mob.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemWeapon.getBow(rand, level, Enchant.canEnchant(world.func_175659_aa(), rand, level)));
                    }
                    if (Enchant.canEnchant(world.func_175659_aa(), rand, level) && rand.nextInt(10) == 0) {
                        mob.func_184201_a(EntityEquipmentSlot.OFFHAND, TippedArrow.getHarmful(rand, 1));
                    }
                }
            }
        }
        for (EntityEquipmentSlot slot : new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET}) {
            ItemStack item = mob instanceof EntitySpider ? Loot.getEquipmentBySlot(rand, Slot.FEET, level, Enchant.canEnchant(world.func_175659_aa(), rand, level)) : Loot.getEquipmentBySlot(rand, Slot.getSlot(slot), level, Enchant.canEnchant(world.func_175659_aa(), rand, level));
            mob.func_184201_a(slot, item);
        }
    }
}

