/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.base;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.base.DungeonRoom;
import greymerk.roguelike.dungeon.base.IDungeonFactory;
import greymerk.roguelike.dungeon.base.IDungeonRoom;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DungeonFactory
implements IDungeonFactory {
    private List<DungeonRoom> singles = new ArrayList<DungeonRoom>();
    private WeightedRandomizer<DungeonRoom> multiple;
    private DungeonRoom base;

    public DungeonFactory(DungeonRoom base) {
        this.multiple = new WeightedRandomizer();
        this.base = base;
    }

    public DungeonFactory() {
        this(DungeonRoom.CORNER);
    }

    public DungeonFactory(JsonArray json) {
        this();
        for (JsonElement e : json) {
            JsonObject entry = e.getAsJsonObject();
            String mode = entry.get("mode").getAsString();
            if (mode.equals("single")) {
                this.addSingle(DungeonRoom.valueOf(entry.get("type").getAsString()));
            }
            if (!mode.equals("random")) continue;
            this.addRandom(DungeonRoom.valueOf(entry.get("type").getAsString()), entry.get("weight").getAsInt());
        }
    }

    public DungeonFactory(DungeonFactory toCopy) {
        this.singles.addAll(toCopy.singles);
        this.multiple = new WeightedRandomizer<DungeonRoom>(toCopy.multiple);
    }

    public void addSingle(DungeonRoom type) {
        this.singles.add(type);
    }

    public void addByRatio(DungeonRoom toAdd, int rate) {
        if (rate <= 0) {
            return;
        }
        int max = RogueConfig.getInt(RogueConfig.LEVELMAXROOMS);
        int numRooms = max / rate;
        if (numRooms == 0) {
            this.addSingle(toAdd);
            return;
        }
        for (int i = 0; i < numRooms; ++i) {
            this.addSingle(toAdd);
        }
    }

    public void addRandom(DungeonRoom type, int weight) {
        this.multiple.add(new WeightedChoice<DungeonRoom>(type, weight));
    }

    @Override
    public IDungeonRoom get(Random rand) {
        if (!this.singles.isEmpty()) {
            return DungeonRoom.getInstance(this.singles.remove(0));
        }
        if (!this.multiple.isEmpty()) {
            return DungeonRoom.getInstance(this.multiple.get(rand));
        }
        return DungeonRoom.getInstance(this.base);
    }
}

