/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.storage;

import com.jaquadro.minecraft.storagedrawers.api.event.DrawerPopulatedEvent;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IItemLockable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IShroudable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.storage.BaseDrawerData;
import com.jaquadro.minecraft.storagedrawers.storage.IStorageProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DrawerData
extends BaseDrawerData
implements IVoidable,
IShroudable,
IItemLockable {
    private static final ItemStack nullStack = new ItemStack((Item)null);
    private IStorageProvider storageProvider;
    private int slot;
    private ItemStack protoStack;
    private int count;

    public DrawerData(IStorageProvider provider, int slot) {
        this.storageProvider = provider;
        this.protoStack = nullStack;
        this.slot = slot;
        this.postInit();
    }

    @Override
    public ItemStack getStoredItemPrototype() {
        if (this.protoStack == nullStack) {
            return null;
        }
        return this.protoStack;
    }

    @Override
    public void setStoredItem(ItemStack itemPrototype, int amount) {
        this.setStoredItem(itemPrototype, amount, true);
    }

    @Override
    public IDrawer setStoredItemRedir(ItemStack itemPrototype, int amount) {
        this.setStoredItem(itemPrototype, amount, true);
        return this;
    }

    private void setStoredItem(ItemStack itemPrototype, int amount, boolean mark) {
        if (itemPrototype == null) {
            this.setStoredItemCount(0, false, true);
            this.protoStack = nullStack;
            this.inventoryStack.reset();
            DrawerPopulatedEvent event = new DrawerPopulatedEvent(this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (mark) {
                this.storageProvider.markDirty(this.slot);
            }
            return;
        }
        this.protoStack = itemPrototype.func_77946_l();
        this.protoStack.field_77994_a = 1;
        this.refreshOreDictMatches();
        this.setStoredItemCount(amount, mark, false);
        this.inventoryStack.reset();
        DrawerPopulatedEvent event = new DrawerPopulatedEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (mark) {
            this.storageProvider.markDirty(this.slot);
        }
    }

    @Override
    public int getStoredItemCount() {
        if (this.protoStack != nullStack && this.storageProvider.isVendingUnlimited(this.slot)) {
            return Integer.MAX_VALUE;
        }
        return this.count;
    }

    @Override
    public void setStoredItemCount(int amount) {
        this.setStoredItemCount(amount, true, true);
    }

    public void setStoredItemCount(int amount, boolean mark, boolean clearOnEmpty) {
        if (this.storageProvider.isVendingUnlimited(this.slot)) {
            return;
        }
        this.count = amount;
        if (this.count > this.getMaxCapacity()) {
            this.count = this.getMaxCapacity();
        }
        if (amount == 0) {
            if (clearOnEmpty) {
                if (!this.storageProvider.isLocked(this.slot, LockAttribute.LOCK_POPULATED)) {
                    this.reset();
                }
                if (mark) {
                    this.storageProvider.markDirty(this.slot);
                }
            }
        } else if (mark) {
            this.storageProvider.markAmountDirty(this.slot);
        }
    }

    @Override
    public int getMaxCapacity() {
        return this.getMaxCapacity(this.protoStack);
    }

    @Override
    public int getMaxCapacity(ItemStack itemPrototype) {
        if (itemPrototype == null || itemPrototype.func_77973_b() == null) {
            return 0;
        }
        if (this.storageProvider.isStorageUnlimited(this.slot) || this.storageProvider.isVendingUnlimited(this.slot)) {
            return Integer.MAX_VALUE;
        }
        return itemPrototype.func_77973_b().getItemStackLimit(itemPrototype) * this.storageProvider.getSlotStackCapacity(this.slot);
    }

    @Override
    public int getRemainingCapacity() {
        if (this.protoStack.func_77973_b() == null) {
            return 0;
        }
        if (this.storageProvider.isVendingUnlimited(this.slot)) {
            return Integer.MAX_VALUE;
        }
        return this.getMaxCapacity() - this.getStoredItemCount();
    }

    @Override
    public int getStoredItemStackSize() {
        if (this.protoStack.func_77973_b() == null) {
            return 0;
        }
        return this.protoStack.func_77973_b().getItemStackLimit(this.protoStack);
    }

    @Override
    protected int getItemCapacityForInventoryStack() {
        if (this.storageProvider.isVoid(this.slot)) {
            return Integer.MAX_VALUE;
        }
        return this.getMaxCapacity();
    }

    @Override
    public boolean canItemBeStored(ItemStack itemPrototype) {
        if (this.protoStack == nullStack && !this.isItemLocked(LockAttribute.LOCK_EMPTY)) {
            return true;
        }
        return this.areItemsEqual(itemPrototype);
    }

    @Override
    public boolean canItemBeExtracted(ItemStack itemPrototype) {
        if (this.protoStack == nullStack) {
            return false;
        }
        return this.areItemsEqual(itemPrototype);
    }

    @Override
    public boolean isEmpty() {
        return this.protoStack == nullStack;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        if (this.protoStack.func_77973_b() != null) {
            tag.func_74777_a("Item", (short)Item.func_150891_b((Item)this.protoStack.func_77973_b()));
            tag.func_74777_a("Meta", (short)this.protoStack.func_77952_i());
            tag.func_74768_a("Count", this.count);
            if (this.protoStack.func_77978_p() != null) {
                tag.func_74782_a("Tags", (NBTBase)this.protoStack.func_77978_p());
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Item") && tag.func_74764_b("Count")) {
            Item item = Item.func_150899_d((int)tag.func_74765_d("Item"));
            if (item != null) {
                ItemStack stack = new ItemStack(item);
                stack.func_77964_b((int)tag.func_74765_d("Meta"));
                if (tag.func_74764_b("Tags")) {
                    stack.func_77982_d(tag.func_74775_l("Tags"));
                }
                this.setStoredItem(stack, tag.func_74762_e("Count"), false);
            } else {
                this.reset();
            }
        } else {
            this.reset();
        }
    }

    @Override
    protected void reset() {
        this.protoStack = nullStack;
        super.reset();
        DrawerPopulatedEvent event = new DrawerPopulatedEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public boolean isVoid() {
        return this.storageProvider.isVoid(this.slot);
    }

    @Override
    public boolean isShrouded() {
        return this.storageProvider.isShrouded(this.slot);
    }

    @Override
    public boolean setIsShrouded(boolean state) {
        return this.storageProvider.setIsShrouded(this.slot, state);
    }

    @Override
    public boolean isItemLocked(LockAttribute attr) {
        return this.storageProvider.isLocked(this.slot, attr);
    }

    @Override
    public boolean canItemLock(LockAttribute attr) {
        return false;
    }

    @Override
    public void setItemLocked(LockAttribute attr, boolean isLocked) {
    }
}

