/*
 * Decompiled with CFR 0.152.
 */
package de.shittyco.morematerials;

import de.shittyco.morematerials.ColorUtility;
import de.shittyco.morematerials.CommonProxy;
import de.shittyco.morematerials.GameUtility;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class BlockStainedBrickSlab
extends BlockSlab {
    private static final PropertyBool VARIANT_PROPERTY = PropertyBool.func_177716_a((String)"variant");
    private static final String ID = "stained_bricks_slab";
    private static final String NAME = "stainedBricksSlab";
    private static final float HARDNESS = 2.0f;
    private static final float RESISTANCE = 10.0f;
    private static final int HALF_META_BIT = 8;
    private int color;

    public BlockStainedBrickSlab(int brickColor) {
        super(Material.field_151576_e);
        this.color = brickColor;
        this.field_149783_u = !this.func_176552_j();
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("stainedBricksSlab_" + ColorUtility.COLOR_NAMES[this.color]);
        if (!this.func_176552_j()) {
            this.func_149647_a(CreativeTabs.field_78030_b);
        }
        IBlockState blockState = this.field_176227_L.func_177621_b();
        blockState = blockState.func_177226_a((IProperty)VARIANT_PROPERTY, (Comparable)Boolean.valueOf(false));
        if (!this.func_176552_j()) {
            blockState = blockState.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.func_180632_j(blockState);
    }

    public final String getId() {
        return this.innerGetId(this.func_176552_j());
    }

    public final String func_150002_b(int metadata) {
        return this.func_149739_a();
    }

    public final Comparable<?> func_185674_a(ItemStack stack) {
        return false;
    }

    public final IProperty func_176551_l() {
        return VARIANT_PROPERTY;
    }

    public final IBlockState func_176203_a(int meta) {
        IBlockState blockState = this.func_176223_P();
        blockState = blockState.func_177226_a((IProperty)VARIANT_PROPERTY, (Comparable)Boolean.valueOf(false));
        if (!this.func_176552_j()) {
            BlockSlab.EnumBlockHalf value = BlockSlab.EnumBlockHalf.BOTTOM;
            if ((meta & 8) != 0) {
                value = BlockSlab.EnumBlockHalf.TOP;
            }
            blockState = blockState.func_177226_a((IProperty)field_176554_a, (Comparable)value);
        }
        return blockState;
    }

    public final int func_176201_c(IBlockState state) {
        if (this.func_176552_j()) {
            return 0;
        }
        if ((BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            return 8;
        }
        return 0;
    }

    public final int func_180651_a(IBlockState state) {
        return 0;
    }

    public final Item func_180660_a(IBlockState blockState, Random random, int unused) {
        String blockId = this.innerGetId(false);
        return GameUtility.getItemFromBlock(blockId);
    }

    public final void registerModels(CommonProxy proxy) {
        Item itemBlock = GameUtility.getItemFromBlock(this.getId());
        proxy.registerItemVariants(itemBlock, new ResourceLocation("morematerials:" + this.getId()));
        proxy.registerInventoryModel(itemBlock, this.getId(), 0);
    }

    protected final BlockStateContainer func_180661_e() {
        if (this.func_176552_j()) {
            return new BlockStateContainer((Block)this, new IProperty[]{VARIANT_PROPERTY});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT_PROPERTY, field_176554_a});
    }

    private String innerGetId(boolean isDoubleStacked) {
        String result = "";
        if (isDoubleStacked) {
            result = "double_";
        }
        return result + ID + '_' + ColorUtility.COLOR_IDS[this.color];
    }
}

