/*
 * Decompiled with CFR 0.152.
 */
package de.shittyco.morematerials;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockGenericWall
extends BlockFence {
    private static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    private static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.3125, 1.0, 0.875, 0.6875), new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private static final AxisAlignedBB[] SELECTED_BOUNDING_BOXES = new AxisAlignedBB[]{BOUNDING_BOXES[0].func_186666_e(1.5), BOUNDING_BOXES[1].func_186666_e(1.5), BOUNDING_BOXES[2].func_186666_e(1.5), BOUNDING_BOXES[3].func_186666_e(1.5), BOUNDING_BOXES[4].func_186666_e(1.5), BOUNDING_BOXES[5].func_186666_e(1.5), BOUNDING_BOXES[6].func_186666_e(1.5), BOUNDING_BOXES[7].func_186666_e(1.5), BOUNDING_BOXES[8].func_186666_e(1.5), BOUNDING_BOXES[9].func_186666_e(1.5), BOUNDING_BOXES[10].func_186666_e(1.5), BOUNDING_BOXES[11].func_186666_e(1.5), BOUNDING_BOXES[12].func_186666_e(1.5), BOUNDING_BOXES[13].func_186666_e(1.5), BOUNDING_BOXES[14].func_186666_e(1.5), BOUNDING_BOXES[15].func_186666_e(1.5)};
    private Block sourceBlock;
    private int sourceMetadata;

    protected BlockGenericWall(Block source, int sourceMeta) {
        super(source.func_149688_o(source.func_176223_P()), source.func_180659_g(source.func_176223_P()));
        this.sourceBlock = source;
        this.sourceMetadata = sourceMeta;
        this.func_149672_a(source.func_185467_w());
        IBlockState state = this.func_176223_P();
        this.func_180632_j(state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)));
    }

    public final AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState actualState = this.func_176221_a(state, source, pos);
        return BOUNDING_BOXES[BlockGenericWall.getBoundingBoxIndex(actualState)];
    }

    public final AxisAlignedBB func_180640_a(IBlockState blockState, World worldIn, BlockPos pos) {
        IBlockState actualState = this.func_176221_a(blockState, (IBlockAccess)worldIn, pos);
        return SELECTED_BOUNDING_BOXES[BlockGenericWall.getBoundingBoxIndex(actualState)];
    }

    public final boolean func_176524_e(IBlockAccess blockAccess, BlockPos pos) {
        IBlockState blockState = blockAccess.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block instanceof BlockGenericWall || block instanceof BlockFenceGate) {
            return true;
        }
        if (block.func_149688_o(blockState).func_76218_k() && block.func_149686_d(blockState)) {
            return block.func_149688_o(blockState) != Material.field_151572_C;
        }
        return false;
    }

    public final IBlockState func_176221_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        boolean isUp = this.canConnectUp(blockAccess, pos);
        boolean isNorth = this.func_176524_e(blockAccess, pos.func_177978_c());
        boolean isSouth = this.func_176524_e(blockAccess, pos.func_177968_d());
        boolean isWest = this.func_176524_e(blockAccess, pos.func_177976_e());
        boolean isEast = this.func_176524_e(blockAccess, pos.func_177974_f());
        boolean hasPost = isUp || (!isNorth || !isSouth || isEast || isWest) && (!isEast || !isWest || isNorth || isSouth);
        return state.func_177226_a((IProperty)BlockFence.field_176526_a, (Comparable)Boolean.valueOf(isNorth)).func_177226_a((IProperty)BlockFence.field_176527_M, (Comparable)Boolean.valueOf(isSouth)).func_177226_a((IProperty)BlockFence.field_176528_N, (Comparable)Boolean.valueOf(isWest)).func_177226_a((IProperty)BlockFence.field_176525_b, (Comparable)Boolean.valueOf(isEast)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(hasPost));
    }

    protected final BlockStateContainer func_180661_e() {
        IProperty[] props = new IProperty[]{BlockFence.field_176526_a, BlockFence.field_176525_b, BlockFence.field_176528_N, BlockFence.field_176527_M, UP};
        return new BlockStateContainer((Block)this, props);
    }

    private static int getBoundingBoxIndex(IBlockState blockState) {
        int index = 0;
        if (((Boolean)blockState.func_177229_b((IProperty)field_176526_a)).booleanValue()) {
            index |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)blockState.func_177229_b((IProperty)field_176525_b)).booleanValue()) {
            index |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)blockState.func_177229_b((IProperty)field_176527_M)).booleanValue()) {
            index |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)blockState.func_177229_b((IProperty)field_176528_N)).booleanValue()) {
            index |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return index;
    }

    private boolean canConnectUp(IBlockAccess blockAccess, BlockPos pos) {
        BlockPos upPos = pos.func_177984_a();
        IBlockState upState = blockAccess.func_180495_p(upPos);
        Block upBlock = upState.func_177230_c();
        return upBlock instanceof BlockTorch || this.func_176524_e(blockAccess, upPos);
    }
}

