/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ranged.IAmmo;

public final class AmmoHelper {
    private AmmoHelper() {
    }

    public static ItemStack findAmmoFromInventory(List<Item> ammoItems, Entity entity) {
        if (ammoItems == null || entity == null || !entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return null;
        }
        IItemHandler itemHandler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH);
        ItemStack ammo = AmmoHelper.validAmmoInRange(itemHandler, ammoItems, 0, InventoryPlayer.func_70451_h());
        if (ammo == null && (ammo = AmmoHelper.validAmmoInRange(itemHandler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP), ammoItems, 0, InventoryPlayer.func_70451_h())) == null) {
            ammo = AmmoHelper.validAmmoInRange(itemHandler, ammoItems, InventoryPlayer.func_70451_h(), itemHandler.getSlots());
        }
        return ammo;
    }

    private static ItemStack validAmmoInRange(IItemHandler itemHandler, List<Item> ammoItems, int from, int to) {
        for (int i = from; i < to; ++i) {
            ItemStack in = itemHandler.getStackInSlot(i);
            for (Item ammoItem : ammoItems) {
                if (in == null || in.func_77973_b() != ammoItem || ammoItem instanceof IAmmo && ((IAmmo)ammoItem).getCurrentAmmo(in) <= 0) continue;
                return in;
            }
        }
        return null;
    }

    public static ItemStack getMatchingItemstackFromInventory(ItemStack stack, Entity entity, boolean damagedOnly) {
        if (stack == null || !entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return null;
        }
        if (entity instanceof EntityLivingBase) {
            ItemStack in = ((EntityLivingBase)entity).func_184614_ca();
            if (ToolCore.isEqualTinkersItem(in, stack) && (!damagedOnly || in.func_77952_i() > 0)) {
                return in;
            }
            in = ((EntityLivingBase)entity).func_184592_cb();
            if (ToolCore.isEqualTinkersItem(in, stack) && (!damagedOnly || in.func_77952_i() > 0)) {
                return in;
            }
        }
        IItemHandler itemHandler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack in = itemHandler.getStackInSlot(i);
            if (!ToolCore.isEqualTinkersItem(in, stack) || damagedOnly && in.func_77952_i() <= 0) continue;
            return in;
        }
        return null;
    }
}

