/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.rodents;

import com.animania.entities.rodents.EntityAIRodentEat;
import com.animania.entities.rodents.EntityAIWanderHedgehog;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHedgehog
extends EntityAnimal {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV});
    private boolean boosting;
    private int boostTime;
    private int totalBoostTime;
    public int eatTimer;
    private EntityAIRodentEat entityAIEatGrass;

    public EntityHedgehog(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.05f, 1.05f);
        this.field_70138_W = 1.1f;
    }

    protected void func_184651_r() {
        this.entityAIEatGrass = new EntityAIRodentEat((EntityLiving)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, Items.field_151146_bM, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderHedgehog((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer entityplayer = (EntityPlayer)entity;
        ItemStack itemstack = entityplayer.func_184614_ca();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151146_bM) {
            return true;
        }
        itemstack = entityplayer.func_184592_cb();
        return itemstack != null && itemstack.func_77973_b() == Items.field_151146_bM;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187697_dL;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187703_dN;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187700_dM;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        return true;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        if (distance > 5.0f) {
            for (EntityPlayer entityplayer : this.func_184180_b(EntityPlayer.class)) {
                entityplayer.func_71029_a((StatBase)AchievementList.field_187993_u);
            }
        }
    }

    public void func_70612_e(float strafe, float forward) {
        Entity entity;
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        if (this.func_184207_aI() && this.func_82171_bF()) {
            this.field_70126_B = this.field_70177_z = entity.field_70177_z;
            this.field_70125_A = entity.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.225f;
                if (this.boosting) {
                    if (this.boostTime++ > this.totalBoostTime) {
                        this.boosting = false;
                    }
                    f += f * 1.15f * MathHelper.func_76126_a((float)((float)this.boostTime / (float)this.totalBoostTime * (float)Math.PI));
                }
                this.func_70659_e(f);
                super.func_70612_e(0.0f, 1.0f);
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f1 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.eatTimer = Math.max(0, this.eatTimer - 1);
        }
        super.func_70636_d();
    }

    public boolean boost() {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.totalBoostTime = this.func_70681_au().nextInt(841) + 140;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 160;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 156 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 160) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 156) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 24.0f;
            return 0.62831855f + 0.14660767f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public EntityHedgehog createChild(EntityAgeable ageable) {
        return null;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }
}

