/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.rodents;

import com.animania.Animania;
import com.animania.AnimaniaAchievements;
import com.animania.ModSoundEvents;
import com.animania.entities.rodents.EntityAIPanicRodents;
import com.animania.entities.rodents.EntityAISwimmingRodents;
import com.animania.entities.rodents.EntityAITemptHamster;
import com.animania.entities.rodents.EntityAIWanderRodent;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityHamster
extends EntityTameable {
    private static final DataParameter<Boolean> IN_BALL = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COLOR_NUM = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FOOD_STACK_COUNT = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> IN_LOVE = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BALL_COLOR = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Animania.hamsterFood});
    private static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final String[] HAMSTER_TEXTURES = new String[]{"black", "brown", "darkbrown", "darkgray", "gray", "plum", "tarou", "white"};
    private int fedTimer;
    private int wateredTimer;
    private int happyTimer;
    private int tamedTimer;
    private int stackCount;
    private int eatCount;
    private int foodStackCount;
    private int standCount;
    private EntityItem targetFood;
    private boolean looksWithInterest;
    private boolean isStanding;
    private float field_25048_b;
    private float field_25054_c;
    private static List hamsterColorList;
    private EntityPlayer givemeEntity;
    private int breeding;
    private boolean mountFlag;
    private double yOffset;
    private ResourceLocation resourceLocation;

    public EntityHamster(World world) {
        super(world);
        this.func_70606_j(10.0f);
        this.yOffset = 0.1f;
        this.func_70105_a(0.5f, 0.3f);
        this.field_70138_W = 1.0f;
        this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        this.looksWithInterest = false;
        this.stackCount = 20;
        this.eatCount = 5000;
        this.standCount = 30;
        this.isStanding = false;
        this.breeding = 0;
        this.happyTimer = 60;
        this.tamedTimer = 120;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanicRodents((EntityCreature)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimmingRodents((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderRodent((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITemptHamster((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        this.func_184754_b(player.func_110124_au());
        this.setIsTamed(true);
        this.func_70903_f(true);
        player.func_71064_a((StatBase)AnimaniaAchievements.Hamsters, 1);
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    protected void func_70088_a() {
        Random rand = new Random();
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IN_BALL, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
        this.field_70180_af.func_187214_a(COLOR_NUM, (Object)0);
        this.field_70180_af.func_187214_a(FOOD_STACK_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(IN_LOVE, (Object)0);
        this.field_70180_af.func_187214_a(BALL_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Sitting", this.isHamsterSitting());
        nbttagcompound.func_74757_a("InBall", this.isInBall());
        nbttagcompound.func_74768_a("ColorNumber", this.getColorNumber());
        nbttagcompound.func_74768_a("foodStackCount", this.getFoodStackCount());
        nbttagcompound.func_74768_a("BallColor", this.getBallColor());
        nbttagcompound.func_74757_a("Fed", this.getFed());
        nbttagcompound.func_74757_a("Watered", this.getWatered());
        nbttagcompound.func_74757_a("IsTamed", this.getIsTamed());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setHamsterSitting(nbttagcompound.func_74767_n("Sitting"));
        this.setInBall(nbttagcompound.func_74767_n("InBall"));
        this.setColorNumber(nbttagcompound.func_74762_e("ColorNumber"));
        this.setFoodStackCount(nbttagcompound.func_74762_e("foodStackCount"));
        this.setBallColor(nbttagcompound.func_74762_e("BallColor"));
        this.setFed(nbttagcompound.func_74767_n("Fed"));
        this.setWatered(nbttagcompound.func_74767_n("Watered"));
        this.setIsTamed(nbttagcompound.func_74767_n("IsTamed"));
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public double func_70033_W() {
        return this.yOffset;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && this.func_70877_b(itemstack) && this.func_70874_b() == 0) {
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
                if (itemstack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
            }
            this.func_70624_b(null);
            player.func_71064_a((StatBase)AnimaniaAchievements.Hamsters, 1);
            this.func_146082_f(player);
            this.setIsTamed(true);
            this.func_70903_f(true);
            this.func_184754_b(player.func_110124_au());
            return true;
        }
        if (stack != null && stack.func_77973_b() == Items.field_151131_as) {
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        if (!(this.field_70170_p.field_72995_K || this.func_70877_b(stack) || this.isHamsterSitting() || player.func_70093_af())) {
            this.setHamsterSitting(true);
            this.func_70904_g(true);
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            return true;
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70877_b(stack) && this.isHamsterSitting() && !player.func_70093_af()) {
            this.setHamsterSitting(false);
            this.func_70904_g(false);
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            return true;
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70877_b(stack) && player.func_70093_af()) {
            this.setHamsterSitting(false);
            this.func_70904_g(false);
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            this.func_184754_b(null);
            this.setIsTamed(false);
            this.func_70903_f(false);
            return true;
        }
        if (!this.getIsTamed()) {
            if (itemstack != null && itemstack.func_77973_b() == Animania.hamsterFood) {
                this.addFoodStack();
                player.func_71064_a((StatBase)AnimaniaAchievements.Hamsters, 1);
                return this.interactSeedsNotTamed(itemstack, player);
            }
            return false;
        }
        if (itemstack != null && itemstack.func_77973_b() == Animania.hamsterBall && !this.isInBall()) {
            this.setInBall(true);
            this.setBallColor(itemstack.func_77952_i());
            itemstack.func_77972_a(1, (EntityLivingBase)player);
        }
        if (itemstack != null && itemstack.func_77973_b() == Animania.hamsterFood) {
            this.addFoodStack();
            player.func_71064_a((StatBase)AnimaniaAchievements.Hamsters, 1);
            return this.interactSeedsTamed(itemstack, player);
        }
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151121_aF) {
            if (this.isInBall()) {
                this.setInBall(false);
                return true;
            }
            return false;
        }
        return this.interactOthersTamed();
    }

    private boolean interactSeedsNotTamed(ItemStack itemstack, EntityPlayer entityplayer) {
        --itemstack.field_77994_a;
        entityplayer.func_71064_a((StatBase)AnimaniaAchievements.Hamsters, 1);
        this.setHamsterStanding(true);
        this.standCount = 100;
        if (itemstack.field_77994_a <= 0) {
            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.field_70699_by.func_75499_g();
            this.field_70703_bu = false;
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        }
        this.func_70691_i(1.0f);
        return true;
    }

    private boolean interactSeedsTamed(ItemStack itemstack, EntityPlayer entityplayer) {
        --itemstack.field_77994_a;
        if (itemstack.field_77994_a <= 0) {
            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
        }
        this.func_70691_i(1.0f);
        return true;
    }

    private boolean interactOthersTamed() {
        if (this.isHamsterStanding() || !this.isHamsterSitting()) {
            this.setHamsterSitting(true);
        } else if (this.isHamsterSitting()) {
            this.setHamsterSitting(false);
        }
        this.field_70703_bu = false;
        this.field_70699_by.func_75499_g();
        this.func_70624_b(null);
        return true;
    }

    public void func_70691_i(float f) {
        super.func_70691_i(f);
        this.field_70172_ad = this.field_70771_an / 2;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70094_T() {
        return super.func_70094_T();
    }

    public boolean entityLivingBaseAttackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (this.func_180431_b(par1DamageSource)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.field_70708_bq = 0;
        if (this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (par1DamageSource.func_76347_k() && this.func_70644_a(MobEffects.field_76426_n)) {
            return false;
        }
        this.field_70721_aZ = 1.5f;
        boolean var3 = true;
        if ((float)this.field_70172_ad > (float)this.field_70771_an / 2.0f) {
            if (par2 <= this.field_110153_bc) {
                return false;
            }
            this.func_70665_d(par1DamageSource, par2 - this.field_110153_bc);
            this.field_110153_bc = par2;
            var3 = false;
        } else {
            this.field_110153_bc = par2;
            this.field_70172_ad = this.field_70771_an;
            this.func_70665_d(par1DamageSource, par2);
            this.field_70738_aO = 10;
            this.field_70737_aN = 10;
        }
        this.field_70739_aP = 0.0f;
        Entity var4 = par1DamageSource.func_76346_g();
        if (var4 != null) {
            EntityWolf var5;
            if (var4 instanceof EntityLivingBase) {
                this.func_70604_c((EntityLivingBase)var4);
            }
            if (var4 instanceof EntityPlayer) {
                this.field_70718_bc = 100;
                this.field_70717_bb = (EntityPlayer)var4;
            } else if (var4 instanceof EntityWolf && (var5 = (EntityWolf)var4).func_70909_n()) {
                this.field_70718_bc = 100;
                this.field_70717_bb = null;
            }
        }
        if (var3) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)2);
            if (par1DamageSource != DamageSource.field_76369_e) {
                this.func_70018_K();
            }
            if (var4 != null) {
                double var9 = var4.field_70165_t - this.field_70165_t;
                double var7 = var4.field_70161_v - this.field_70161_v;
                while (var9 * var9 + var7 * var7 < 1.0E-4) {
                    var9 = (Math.random() - Math.random()) * 0.01;
                    var7 = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(Math.atan2(var7, var9) * 180.0 / Math.PI) - this.field_70177_z;
                this.func_70653_a(var4, par2, var9, var7);
            } else {
                this.field_70739_aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            if (var3) {
                // empty if block
            }
            this.func_70645_a(par1DamageSource);
        } else if (var3) {
            // empty if block
        }
        return true;
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.3;
    }

    public void func_70636_d() {
        double d2;
        double d1;
        EntityLivingBase entity;
        if (this.getColorNumber() == 0) {
            Random rand = new Random();
            int bob2 = rand.nextInt(8) + 1;
            this.setColorNumber(bob2);
            this.resourceLocation = new ResourceLocation("animania:textures/entity/rodents/hamster_" + HAMSTER_TEXTURES[bob2 - 1] + ".png");
        } else if (this.resourceLocation == null) {
            this.resourceLocation = new ResourceLocation("animania:textures/entity/rodents/hamster_" + HAMSTER_TEXTURES[this.getColorNumber() - 1] + ".png");
        }
        super.func_70636_d();
        if (this.func_110143_aJ() < 10.0f) {
            this.eatFood();
            this.eatCount = 5000;
        }
        if (!this.isHamsterStanding() && !this.isHamsterSitting()) {
            if (this.field_70146_Z.nextInt(20) == 0 && this.field_70146_Z.nextInt(20) == 0) {
                this.setHamsterStanding(true);
                this.standCount = 30;
                this.field_70699_by.func_75499_g();
                this.field_70703_bu = false;
            }
        } else if (this.isHamsterStanding() && this.standCount-- <= 0 && this.field_70146_Z.nextInt(10) == 0) {
            this.setHamsterStanding(false);
        }
        if (this.getFoodStackCount() > 0) {
            if (this.eatCount == 0) {
                if (this.field_70146_Z.nextInt(30) == 0 && this.field_70146_Z.nextInt(30) == 0) {
                    this.eatFood();
                    this.eatCount = 5000;
                }
            } else {
                --this.eatCount;
            }
        }
        this.looksWithInterest = false;
        if (!this.func_70781_l() && (entity = this.func_70643_av()) instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151014_N) {
                this.looksWithInterest = true;
            }
        }
        if (this.isHamsterSitting() | this.isHamsterStanding() && this.func_70661_as() != null) {
            this.func_70661_as().func_75499_g();
        }
        if (this.fedTimer > -1) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0) {
                // empty if block
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        } else if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && Animania.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.001;
                    d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        if (this.tamedTimer > -1) {
            --this.tamedTimer;
            if (this.tamedTimer == 0) {
                this.tamedTimer = 120;
                if (this.getIsTamed() && Animania.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.02;
                    d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
    }

    public boolean getFed() {
        return (Boolean)this.field_70180_af.func_187225_a(FED);
    }

    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getWatered() {
        return (Boolean)this.field_70180_af.func_187225_a(WATERED);
    }

    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_25054_c = this.field_25048_b;
        this.field_25048_b = this.looksWithInterest ? (this.field_25048_b += (1.0f - this.field_25048_b) * 0.4f) : (this.field_25048_b += (0.0f - this.field_25048_b) * 0.4f);
        if (this.looksWithInterest) {
            // empty if block
        }
        if (this.field_70146_Z.nextInt(10) == 5) {
            ++this.field_70173_aa;
        }
    }

    public float getInterestedAngle(float f) {
        return (this.field_25054_c + (this.field_25048_b - this.field_25054_c) * f) * 0.15f * 3.141593f;
    }

    @Nullable
    public UUID getHamsterOwner() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(field_184756_bw)).orNull();
    }

    public void setHamsterOwner(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(field_184756_bw, (Object)Optional.fromNullable((Object)uniqueId));
    }

    public boolean isInBall() {
        return (Boolean)this.field_70180_af.func_187225_a(IN_BALL);
    }

    public void setInBall(boolean ball) {
        if (ball) {
            this.field_70180_af.func_187227_b(IN_BALL, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(IN_BALL, (Object)false);
        }
    }

    public int getBallColor() {
        return (Integer)this.field_70180_af.func_187225_a(BALL_COLOR);
    }

    public void setBallColor(int color) {
        this.field_70180_af.func_187227_b(BALL_COLOR, (Object)color);
    }

    public boolean isHamsterSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setHamsterSitting(boolean flag) {
        if (flag) {
            this.field_70180_af.func_187227_b(SITTING, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(SITTING, (Object)false);
        }
    }

    void showHeartsOrSmokeFX(String s, int i, boolean flag) {
        for (int j = 0; j < i; ++j) {
            double d = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            if (this.field_70146_Z.nextInt(2) > 0) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, ModSoundEvents.hamsterEat1, SoundCategory.PLAYERS, 0.6f, 0.8f);
                continue;
            }
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, ModSoundEvents.hamsterEat2, SoundCategory.PLAYERS, 0.6f, 0.8f);
        }
    }

    public boolean getIsTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public void setIsTamed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(TAMED, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)false);
        }
    }

    public boolean isHamsterStanding() {
        return this.isStanding;
    }

    public void setHamsterStanding(boolean flag) {
        this.isStanding = flag;
    }

    protected Item func_146068_u() {
        return Items.field_151014_N;
    }

    public int getFoodStackCount() {
        return this.foodStackCount;
    }

    public void setFoodStackCount(int i) {
        this.foodStackCount = i;
    }

    public int getColorNumber() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR_NUM);
    }

    public void setColorNumber(int color) {
        this.field_70180_af.func_187227_b(COLOR_NUM, (Object)color);
    }

    private boolean addFoodStack() {
        if (this.foodStackCount != 5) {
            ++this.foodStackCount;
            return true;
        }
        this.func_70691_i(1.0f);
        return false;
    }

    private boolean eatFood() {
        if (this.foodStackCount != 0) {
            --this.foodStackCount;
            this.func_70691_i(1.0f);
            return true;
        }
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityanimal) {
        return null;
    }

    public double func_70042_X() {
        return this.field_70131_O;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    private void procreate(EntityHamster par1EntityAnimal) {
        EntityHamster entityhamster = (EntityHamster)this.func_90011_a((EntityAgeable)par1EntityAnimal);
        if (entityhamster != null) {
            this.func_70873_a(6000);
            par1EntityAnimal.func_70873_a(6000);
            this.breeding = 0;
            par1EntityAnimal.breeding = 0;
            entityhamster.func_70873_a(-24000);
            entityhamster.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            for (int i = 0; i < 7; ++i) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            }
            this.field_70170_p.func_72838_d((Entity)entityhamster);
        }
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 0;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 6 : (happy == 1 ? 12 : 24))) == 0) {
            return ModSoundEvents.hamsterLiving1;
        }
        if (chooser == 1) {
            return ModSoundEvents.hamsterLiving2;
        }
        if (chooser == 2) {
            return ModSoundEvents.hamsterLiving3;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        return ModSoundEvents.hamsterHurt1;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP() - 0.2f, this.func_70647_i());
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.02f, 1.8f);
    }
}

