/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.rodents;

import com.animania.Animania;
import com.animania.AnimaniaAchievements;
import com.animania.ModSoundEvents;
import com.animania.entities.rodents.EntityAIFindWater;
import com.animania.entities.rodents.EntityAIRodentEat;
import com.animania.entities.rodents.EntityAISwimmingRodents;
import com.animania.entities.rodents.EntityAIWanderRodent;
import com.animania.entities.rodents.EntityAIWatchClosestFromSide;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFerretGrey
extends EntityTameable {
    private static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityFerretGrey.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityFerretGrey.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EntityFerretGrey.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_179561_bm, Items.field_151110_aK, Animania.brownEgg, Items.field_151076_bf, Animania.rawWyandotteChicken, Animania.rawRhodeIslandRedChicken, Animania.rawRhodeIslandRedChicken, Animania.rawOrpingtonChicken});
    private int fedTimer;
    private int wateredTimer;
    private int happyTimer;
    private int tamedTimer;
    public int eatTimer;
    public EntityAIRodentEat entityAIEatGrass;

    public EntityFerretGrey(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.55f, 0.75f);
        this.field_70138_W = 1.1f;
        this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.tamedTimer = 120;
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimmingRodents((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFindWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.entityAIEatGrass = new EntityAIRodentEat((EntityLiving)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.5));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRodentEat((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderRodent((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosestFromSide((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        this.func_184754_b(player.func_110124_au());
        this.setIsTamed(true);
        this.func_70904_g(false);
        player.func_71064_a((StatBase)AnimaniaAchievements.GreyFerret, 1);
        this.entityAIEatGrass.func_75249_e();
        if (player.func_189102_a(AnimaniaAchievements.WhiteFerret) && player.func_189102_a(AnimaniaAchievements.GreyFerret)) {
            player.func_71064_a((StatBase)AnimaniaAchievements.Ferrets, 1);
        }
        if (!player.field_71075_bZ.field_75098_d && stack != null) {
            --stack.field_77994_a;
        }
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    protected void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151131_as) {
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        if (!(!this.func_152114_e((EntityLivingBase)player) || this.field_70170_p.field_72995_K || this.func_70877_b(stack) || this.func_70906_o() || player.func_70093_af())) {
            this.field_70911_d.func_75270_a(true);
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            return true;
        }
        if (this.func_152114_e((EntityLivingBase)player) && !this.field_70170_p.field_72995_K && !this.func_70877_b(stack) && this.func_70906_o() && !player.func_70093_af()) {
            this.field_70911_d.func_75270_a(false);
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            return true;
        }
        if (this.func_152114_e((EntityLivingBase)player) && !this.field_70170_p.field_72995_K && !this.func_70877_b(stack) && player.func_70093_af()) {
            this.field_70911_d.func_75270_a(false);
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            this.func_184754_b(null);
            this.setIsTamed(false);
            this.func_70903_f(false);
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
    }

    public static void func_189792_b(DataFixer p_189792_0_) {
        EntityLiving.func_189752_a((DataFixer)p_189792_0_, (String)"Grey Ferret");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Fed", this.getFed());
        compound.func_74757_a("Watered", this.getWatered());
        compound.func_74757_a("IsTamed", this.getIsTamed());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setFed(compound.func_74767_n("Fed"));
        this.setWatered(compound.func_74767_n("Watered"));
        this.setIsTamed(compound.func_74767_n("IsTamed"));
    }

    public boolean func_184652_a(EntityPlayer player) {
        return true;
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 0;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 10 : (happy == 1 ? 20 : 40))) == 0) {
            return ModSoundEvents.ferretLiving1;
        }
        if (chooser == 1) {
            return ModSoundEvents.ferretLiving2;
        }
        if (chooser == 2) {
            return ModSoundEvents.ferretLiving3;
        }
        if (chooser == 3) {
            return ModSoundEvents.ferretLiving4;
        }
        if (chooser == 4) {
            return ModSoundEvents.ferretLiving5;
        }
        if (chooser == 5) {
            return ModSoundEvents.ferretLiving6;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.ferretHurt1;
        }
        if (chooser == 1) {
            return ModSoundEvents.ferretHurt1;
        }
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.ferretHurt1;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP() - 0.3f, this.func_70647_i());
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.02f, 1.5f);
    }

    public void func_70636_d() {
        double d2;
        double d1;
        double d;
        if (this.field_70170_p.field_72995_K) {
            this.eatTimer = Math.max(0, this.eatTimer - 1);
        }
        if (this.fedTimer > -1) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0) {
                this.setWatered(false);
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        } else if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && Animania.showUnhappyParticles) {
                    d = this.field_70146_Z.nextGaussian() * 0.001;
                    d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        if (this.tamedTimer > -1) {
            --this.tamedTimer;
            if (this.tamedTimer == 0) {
                this.tamedTimer = 120;
                if (this.getIsTamed() && Animania.showUnhappyParticles) {
                    d = this.field_70146_Z.nextGaussian() * 0.02;
                    d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        super.func_70636_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean getFed() {
        return (Boolean)this.field_70180_af.func_187225_a(FED);
    }

    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getWatered() {
        return (Boolean)this.field_70180_af.func_187225_a(WATERED);
    }

    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    public boolean getIsTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public void setIsTamed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(TAMED, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 176 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 80) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 176) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 24.0f;
            return 0.62831855f + 0.14660767f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public EntityFerretGrey createChild(EntityAgeable ageable) {
        return null;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }
}

