/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.pigs;

import com.animania.Animania;
import com.animania.AnimaniaAchievements;
import com.animania.ModSoundEvents;
import com.animania.entities.pigs.EntityAIFindFood;
import com.animania.entities.pigs.EntityAIFindMud;
import com.animania.entities.pigs.EntityAIFindWater;
import com.animania.entities.pigs.EntityAIFollowMatePigs;
import com.animania.entities.pigs.EntityAIMatePigs;
import com.animania.entities.pigs.EntityAIPanicPigs;
import com.animania.entities.pigs.EntityAISwimmingPigs;
import com.animania.entities.pigs.EntityAIWanderPig;
import com.animania.entities.pigs.EntityPigSnuffle;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHogHampshire
extends EntityAnimal {
    private static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntityHogHampshire.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(EntityHogHampshire.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MUDDY = EntityDataManager.func_187226_a(EntityHogHampshire.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> SPLASHTIMER = EntityDataManager.func_187226_a(EntityHogHampshire.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> MUDTIMER = EntityDataManager.func_187226_a(EntityHogHampshire.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityHogHampshire.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityHogHampshire.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PLAYED = EntityDataManager.func_187226_a(EntityHogHampshire.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV, Animania.bucketSlop});
    private boolean boosting;
    private int boostTime;
    private int totalBoostTime;
    private int fedTimer;
    private int wateredTimer;
    private int playedTimer;
    private int happyTimer;
    public int eatTimer;
    public EntityPigSnuffle entityAIEatGrass;

    public EntityHogHampshire(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70138_W = 1.1f;
        this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        this.playedTimer = Animania.playTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
    }

    protected void func_184651_r() {
        this.entityAIEatGrass = new EntityPigSnuffle((EntityLiving)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimmingPigs((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFindMud((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderPig((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFindWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowMatePigs(this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFindFood((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderPig((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIPanicPigs((EntityCreature)this, 1.5));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIMatePigs(this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, Items.field_151146_bM, false));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWanderPig((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.255);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        if (this.entityAIEatGrass != null) {
            this.entityAIEatGrass.func_75249_e();
            this.eatTimer = 80;
        }
        player.func_71064_a((StatBase)AnimaniaAchievements.Hampshire, 1);
        if (player.func_189102_a(AnimaniaAchievements.Duroc) && player.func_189102_a(AnimaniaAchievements.Hampshire) && player.func_189102_a(AnimaniaAchievements.LargeBlack) && player.func_189102_a(AnimaniaAchievements.LargeWhite) && player.func_189102_a(AnimaniaAchievements.OldSpot) && player.func_189102_a(AnimaniaAchievements.Yorkshire)) {
            player.func_71064_a((StatBase)AnimaniaAchievements.Pigs, 1);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            if (stack != null && stack.func_77973_b() != Animania.bucketSlop) {
                --stack.field_77994_a;
            } else if (stack != null && stack.func_77973_b() == Animania.bucketSlop) {
                --stack.field_77994_a;
                if (!player.field_70170_p.field_72995_K) {
                    ItemStack itemstack = new ItemStack(Items.field_151133_ar, 1);
                    EntityItem entityitem = new EntityItem(player.field_70170_p, player.field_70165_t + 0.5, player.field_70163_u, player.field_70161_v + 0.5, itemstack);
                    player.field_70170_p.func_72838_d((Entity)entityitem);
                }
            }
        }
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    protected void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer entityplayer = (EntityPlayer)entity;
        ItemStack itemstack = entityplayer.func_184614_ca();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151146_bM) {
            return true;
        }
        itemstack = entityplayer.func_184592_cb();
        return itemstack != null && itemstack.func_77973_b() == Items.field_151146_bM;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(MUDDY, (Object)false);
        this.field_70180_af.func_187214_a(MUDTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SPLASHTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(PLAYED, (Object)true);
    }

    public static void func_189792_b(DataFixer p_189792_0_) {
        EntityLiving.func_189752_a((DataFixer)p_189792_0_, (String)"Hog Hampshire");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getMateUniqueId() != null) {
            compound.func_74778_a("MateUUID", this.getMateUniqueId().toString());
        }
        compound.func_74757_a("Saddle", this.getSaddled());
        compound.func_74757_a("Muddy", this.getMuddy());
        compound.func_74776_a("MudTimer", this.getMudTimer().floatValue());
        compound.func_74776_a("SplashTimer", this.getSplashTimer().floatValue());
        compound.func_74757_a("Fed", this.getFed());
        compound.func_74757_a("Watered", this.getWatered());
        compound.func_74757_a("Played", this.getPlayed());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSaddled(compound.func_74767_n("Saddle"));
        this.setMuddy(compound.func_74767_n("Muddy"));
        this.setMudTimer(Float.valueOf(compound.func_74760_g("MudTimer")));
        this.setSplashTimer(Float.valueOf(compound.func_74760_g("SplashTimer")));
        this.setFed(compound.func_74767_n("Fed"));
        this.setWatered(compound.func_74767_n("Watered"));
        this.setPlayed(compound.func_74767_n("Played"));
        if (compound.func_150297_b("MateUUID", 8)) {
            String s = compound.func_74779_i("MateUUID");
        } else {
            String s1 = compound.func_74779_i("Mate");
            String s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
    }

    @Nullable
    public UUID getMateUniqueId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(MATE_UNIQUE_ID)).orNull();
    }

    public void setMateUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(MATE_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 0;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 10 : (happy == 1 ? 20 : 40))) == 0) {
            return ModSoundEvents.hog1;
        }
        if (chooser == 1) {
            return ModSoundEvents.hog2;
        }
        if (chooser == 2) {
            return ModSoundEvents.hog3;
        }
        if (chooser == 3) {
            return ModSoundEvents.hog4;
        }
        if (chooser == 4) {
            return ModSoundEvents.hog5;
        }
        if (chooser == 5) {
            return ModSoundEvents.pig1;
        }
        if (chooser == 6) {
            return ModSoundEvents.pig2;
        }
        if (chooser == 7) {
            return ModSoundEvents.pig4;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.pigHurt1;
        }
        if (chooser == 1) {
            return ModSoundEvents.pigHurt2;
        }
        return ModSoundEvents.pig3;
    }

    protected SoundEvent func_184615_bR() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.pigHurt1;
        }
        if (chooser == 1) {
            return ModSoundEvents.pigHurt2;
        }
        return ModSoundEvents.pig3;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - 0.2f);
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.1f, 0.8f);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151131_as) {
            if (--stack.field_77994_a == 0) {
                player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151133_ar))) {
                player.func_71019_a(new ItemStack(Items.field_151133_ar), false);
            }
            if (this.entityAIEatGrass != null) {
                this.entityAIEatGrass.func_75249_e();
                this.eatTimer = 40;
            }
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        if (this.getSaddled()) {
            this.func_145779_a(Items.field_151141_av, 1);
        }
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int happyDrops = 0;
        if (this.getPlayed()) {
            ++happyDrops;
        }
        if (this.getWatered()) {
            ++happyDrops;
        }
        if (this.getFed()) {
            ++happyDrops;
        }
        if (happyDrops == 3) {
            if (this.func_70027_ad()) {
                this.func_145779_a(Animania.cookedHampshireRoast, 1);
            } else {
                this.func_145779_a(Animania.rawHampshirePork, 1);
            }
        } else if (happyDrops == 2) {
            if (this.func_70027_ad()) {
                this.func_145779_a(Animania.cookedHampshireBacon, 1);
            } else {
                this.func_145779_a(Animania.rawHampshireBacon, 1);
            }
        } else if (happyDrops == 1) {
            if (this.func_70027_ad()) {
                this.func_145779_a(Items.field_151157_am, 1);
            } else {
                this.func_145779_a(Items.field_151147_al, 1);
            }
        }
    }

    public boolean getSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        if (saddled) {
            this.field_70180_af.func_187227_b(SADDLED, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(SADDLED, (Object)false);
        }
    }

    public boolean getFed() {
        return (Boolean)this.field_70180_af.func_187225_a(FED);
    }

    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getPlayed() {
        return (Boolean)this.field_70180_af.func_187225_a(PLAYED);
    }

    public void setPlayed(boolean played) {
        if (played) {
            this.field_70180_af.func_187227_b(PLAYED, (Object)true);
            this.playedTimer = Animania.playTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(PLAYED, (Object)false);
        }
    }

    public boolean getWatered() {
        return (Boolean)this.field_70180_af.func_187225_a(WATERED);
    }

    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    public boolean getMuddy() {
        return (Boolean)this.field_70180_af.func_187225_a(MUDDY);
    }

    public void setMuddy(boolean muddy) {
        if (muddy) {
            this.field_70180_af.func_187227_b(MUDDY, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(MUDDY, (Object)false);
        }
    }

    public Float getMudTimer() {
        return Float.valueOf(((Float)this.field_70180_af.func_187225_a(MUDTIMER)).floatValue());
    }

    public void setMudTimer(Float timer) {
        this.field_70180_af.func_187227_b(MUDTIMER, (Object)Float.valueOf(timer.floatValue()));
    }

    public Float getSplashTimer() {
        return Float.valueOf(((Float)this.field_70180_af.func_187225_a(SPLASHTIMER)).floatValue());
    }

    public void setSplashTimer(Float timer) {
        this.field_70180_af.func_187227_b(SPLASHTIMER, (Object)Float.valueOf(timer.floatValue()));
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            EntityPigZombie entitypigzombie = new EntityPigZombie(this.field_70170_p);
            entitypigzombie.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151010_B));
            entitypigzombie.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie.func_94061_f(this.func_175446_cd());
            if (this.func_145818_k_()) {
                entitypigzombie.func_96094_a(this.func_95999_t());
                entitypigzombie.func_174805_g(this.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)entitypigzombie);
            this.func_70106_y();
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        if (distance > 5.0f) {
            for (EntityPlayer entityplayer : this.func_184180_b(EntityPlayer.class)) {
                entityplayer.func_71029_a((StatBase)AchievementList.field_187993_u);
            }
        }
    }

    public void func_70612_e(float strafe, float forward) {
        Entity entity;
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        if (this.func_184207_aI() && this.func_82171_bF()) {
            this.field_70126_B = this.field_70177_z = entity.field_70177_z;
            this.field_70125_A = entity.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.225f;
                if (this.boosting) {
                    if (this.boostTime++ > this.totalBoostTime) {
                        this.boosting = false;
                    }
                    f += f * 1.15f * MathHelper.func_76126_a((float)((float)this.boostTime / (float)this.totalBoostTime * (float)Math.PI));
                }
                this.func_70659_e(f);
                super.func_70612_e(0.0f, 1.0f);
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f1 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.eatTimer = Math.max(0, this.eatTimer - 1);
        }
        if (this.fedTimer > -1) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0) {
                this.setWatered(false);
            }
        }
        if (this.playedTimer > -1) {
            --this.playedTimer;
            if (this.playedTimer == 0) {
                this.setPlayed(false);
            }
        }
        if ((double)this.getMudTimer().floatValue() > 0.0) {
            this.setPlayed(true);
            this.playedTimer = Animania.playTimer + this.field_70146_Z.nextInt(100);
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        boolean played = this.getPlayed();
        if (!fed && !watered && played) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        } else if (!(fed || watered || played)) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
        }
        BlockPos currentpos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Block poschk = this.field_70170_p.func_180495_p(currentpos).func_177230_c();
        if (poschk == Animania.blockMud || poschk.getRegistryName().toString().contains("biomesoplenty:mud")) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 2, 4, false, false));
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && !this.getPlayed() && Animania.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        super.func_70636_d();
    }

    public boolean boost() {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.totalBoostTime = this.func_70681_au().nextInt(841) + 140;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 76 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 80) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 76) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 24.0f;
            return 0.62831855f + 0.14660767f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public EntityHogHampshire createChild(EntityAgeable ageable) {
        return null;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }
}

