/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.cows;

import com.animania.Animania;
import com.animania.AnimaniaAchievements;
import com.animania.ModSoundEvents;
import com.animania.entities.cows.EntityAIFindFood;
import com.animania.entities.cows.EntityAIFindWater;
import com.animania.entities.cows.EntityAIFollowParentCows;
import com.animania.entities.cows.EntityAIPanicCows;
import com.animania.entities.cows.EntityAISwimmingCows;
import com.animania.entities.cows.EntityBullLonghorn;
import com.animania.entities.cows.EntityCowEatGrass;
import com.animania.entities.cows.EntityCowLonghorn;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCalfLonghorn
extends EntityAnimal {
    private static final DataParameter<Optional<UUID>> PARENT_UNIQUE_ID = EntityDataManager.func_187226_a(EntityCalfLonghorn.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityCalfLonghorn.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityCalfLonghorn.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> AGE = EntityDataManager.func_187226_a(EntityCalfLonghorn.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151015_O});
    private int happyTimer;
    private int ageTimer;
    public int eatTimer;
    private int fedTimer;
    private int wateredTimer;
    public EntityCowEatGrass entityAIEatGrass;

    public EntityCalfLonghorn(World world) {
        super(world);
        this.func_70105_a(0.7f, 1.1f);
        this.field_70138_W = 1.1f;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowParentCows(this, 1.1));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFindFood((EntityCreature)this, 1.2));
        this.entityAIEatGrass = new EntityCowEatGrass((EntityLiving)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFindWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimmingCows((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanicCows((EntityCreature)this, 2.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Item.func_150898_a((Block)Blocks.field_150327_N), false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Item.func_150898_a((Block)Blocks.field_150328_O), false));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.ageTimer = 0;
    }

    public static void func_189790_b(DataFixer p_189790_0_) {
        EntityLiving.func_189752_a((DataFixer)p_189790_0_, (String)"Calf Longhorn");
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(AGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PARENT_UNIQUE_ID, (Object)Optional.absent());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26000000298023224);
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        this.entityAIEatGrass.func_75249_e();
        this.eatTimer = 80;
        player.func_71064_a((StatBase)AnimaniaAchievements.Longhorn, 1);
        if (player.func_189102_a(AnimaniaAchievements.Longhorn) && player.func_189102_a(AnimaniaAchievements.Friesian) && player.func_189102_a(AnimaniaAchievements.Hereford) && player.func_189102_a(AnimaniaAchievements.Holstein) && player.func_189102_a(AnimaniaAchievements.Longhorn)) {
            player.func_71064_a((StatBase)AnimaniaAchievements.Cows, 1);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    protected void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Fed", this.getFed());
        compound.func_74757_a("Watered", this.getWatered());
        compound.func_74776_a("Age", this.getEntityAge());
        if (this.getParentUniqueId() != null && this.getParentUniqueId() != null) {
            compound.func_74778_a("ParentUUID", this.getParentUniqueId().toString());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        this.setFed(compound.func_74767_n("Fed"));
        this.setWatered(compound.func_74767_n("Watered"));
        this.setEntityAge(compound.func_74760_g("Age"));
        if (compound.func_150297_b("ParentUUID", 8)) {
            s = compound.func_74779_i("ParentUUID");
        } else {
            String s1 = compound.func_74779_i("Parent");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            this.setParentUniqueId(UUID.fromString(s));
        }
    }

    @Nullable
    public UUID getParentUniqueId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(PARENT_UNIQUE_ID)).orNull();
    }

    public void setParentUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(PARENT_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    public boolean getFed() {
        return (Boolean)this.field_70180_af.func_187225_a(FED);
    }

    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getWatered() {
        return (Boolean)this.field_70180_af.func_187225_a(WATERED);
    }

    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    public float getEntityAge() {
        return ((Float)this.field_70180_af.func_187225_a(AGE)).floatValue();
    }

    public void setEntityAge(float age) {
        this.field_70180_af.func_187227_b(AGE, (Object)Float.valueOf(age));
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 0;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 6 : (happy == 1 ? 12 : 24))) == 0) {
            return ModSoundEvents.mooCalf1;
        }
        if (chooser == 1) {
            return ModSoundEvents.mooCalf2;
        }
        if (chooser == 2) {
            return ModSoundEvents.mooCalf3;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.mooCalf1;
        }
        if (chooser == 1) {
            return ModSoundEvents.mooCalf2;
        }
        return ModSoundEvents.mooCalf3;
    }

    protected SoundEvent func_184615_bR() {
        Random rand = new Random();
        int chooser = rand.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.mooCalf1;
        }
        if (chooser == 1) {
            return ModSoundEvents.mooCalf2;
        }
        return ModSoundEvents.mooCalf3;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() + 0.2f - this.getEntityAge() * 2.0f);
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.5f, 1.2f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return null;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.eatTimer = Math.max(0, this.eatTimer - 1);
        }
        if (this.fedTimer > -1) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0) {
                this.setWatered(false);
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        } else if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
        }
        ++this.ageTimer;
        if (this.ageTimer >= Animania.childGrowthTick && fed && watered) {
            this.ageTimer = 0;
            float age = this.getEntityAge();
            this.setEntityAge(age += 0.01f);
            if ((double)age >= 1.0 && !this.field_70170_p.field_72995_K) {
                String name;
                this.func_70106_y();
                if (this.field_70146_Z.nextInt(2) < 1) {
                    EntityCowLonghorn entityCow = new EntityCowLonghorn(this.field_70170_p);
                    entityCow.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                    name = this.func_95999_t();
                    if (name != "") {
                        entityCow.func_96094_a(name);
                    }
                    this.field_70170_p.func_72838_d((Entity)entityCow);
                    this.func_184185_a(ModSoundEvents.moo1, 0.5f, 1.1f);
                } else {
                    EntityBullLonghorn entityBull = new EntityBullLonghorn(this.field_70170_p);
                    entityBull.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                    name = this.func_95999_t();
                    if (name != "") {
                        entityBull.func_96094_a(name);
                    }
                    this.field_70170_p.func_72838_d((Entity)entityBull);
                    this.func_184185_a(ModSoundEvents.bullMoo1, 0.5f, 1.1f);
                }
            }
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && Animania.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.001;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        super.func_70636_d();
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151131_as) {
            if (--stack.field_77994_a == 0) {
                player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151133_ar))) {
                player.func_71019_a(new ItemStack(Items.field_151133_ar), false);
            }
            this.eatTimer = 40;
            this.entityAIEatGrass.func_75249_e();
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 160;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 156 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 160) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 156) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 64.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && this.isCowBreedingItem(stack.func_77973_b());
    }

    private boolean isCowBreedingItem(Item itemIn) {
        return itemIn == Items.field_151015_O || itemIn == Item.func_150898_a((Block)Blocks.field_150327_N) || itemIn == Item.func_150898_a((Block)Blocks.field_150328_O);
    }

    public EntityCalfLonghorn createChild(EntityAgeable p_90011_1_) {
        return null;
    }
}

