/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.cows;

import com.animania.Animania;
import com.animania.AnimaniaAchievements;
import com.animania.ModSoundEvents;
import com.animania.entities.cows.EntityAIAttackMeleeBulls;
import com.animania.entities.cows.EntityAIFindFood;
import com.animania.entities.cows.EntityAIFindWater;
import com.animania.entities.cows.EntityAIFollowMateCows;
import com.animania.entities.cows.EntityAIMateCows;
import com.animania.entities.cows.EntityAISwimmingCows;
import com.animania.entities.cows.EntityCowEatGrass;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBullFriesian
extends EntityAnimal {
    private static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntityBullFriesian.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> FIGHTING = EntityDataManager.func_187226_a(EntityBullFriesian.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151015_O});
    private static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityBullFriesian.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityBullFriesian.class, (DataSerializer)DataSerializers.field_187198_h);
    private int happyTimer;
    public int eatTimer;
    private int fedTimer;
    private int wateredTimer;
    public EntityCowEatGrass entityAIEatGrass;

    public EntityBullFriesian(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.5f);
        this.field_70138_W = 1.1f;
        this.entityAIEatGrass = new EntityCowEatGrass((EntityLiving)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackMeleeBulls((EntityCreature)this, 2.3, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFindFood((EntityCreature)this, 1.1));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowMateCows(this, 1.1));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFindWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISwimmingCows((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMateCows(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Item.func_150898_a((Block)Blocks.field_150327_N), false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Item.func_150898_a((Block)Blocks.field_150328_O), false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPlayer.class}));
        this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(FIGHTING, (Object)false);
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        this.entityAIEatGrass.func_75249_e();
        this.eatTimer = 80;
        player.func_71064_a((StatBase)AnimaniaAchievements.Friesian, 1);
        if (player.func_189102_a(AnimaniaAchievements.Angus) && player.func_189102_a(AnimaniaAchievements.Friesian) && player.func_189102_a(AnimaniaAchievements.Hereford) && player.func_189102_a(AnimaniaAchievements.Holstein) && player.func_189102_a(AnimaniaAchievements.Longhorn)) {
            player.func_71064_a((StatBase)AnimaniaAchievements.Cows, 1);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    public static void func_189790_b(DataFixer p_189790_0_) {
        EntityLiving.func_189752_a((DataFixer)p_189790_0_, (String)"Bull Friesian");
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getMateUniqueId() != null) {
            if (this.getMateUniqueId() != null) {
                compound.func_74778_a("MateUUID", this.getMateUniqueId().toString());
            }
            compound.func_74757_a("Fighting", this.getFighting());
            compound.func_74757_a("Fed", this.getFed());
            compound.func_74757_a("Watered", this.getWatered());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        if (compound.func_150297_b("MateUUID", 8)) {
            s = compound.func_74779_i("MateUUID");
        } else {
            String s1 = compound.func_74779_i("Mate");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            this.setMateUniqueId(UUID.fromString(s));
        }
        this.setFighting(compound.func_74767_n("Fighting"));
        this.setFed(compound.func_74767_n("Fed"));
        this.setWatered(compound.func_74767_n("Watered"));
    }

    @Nullable
    public UUID getMateUniqueId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(MATE_UNIQUE_ID)).orNull();
    }

    public void setMateUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(MATE_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    public boolean getFighting() {
        return (Boolean)this.field_70180_af.func_187225_a(FIGHTING);
    }

    public void setFighting(boolean fighting) {
        if (fighting) {
            this.field_70180_af.func_187227_b(FIGHTING, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(FIGHTING, (Object)false);
        }
    }

    public boolean getFed() {
        return (Boolean)this.field_70180_af.func_187225_a(FED);
    }

    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getWatered() {
        return (Boolean)this.field_70180_af.func_187225_a(WATERED);
    }

    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 4.0f);
        entityIn.func_70097_a(Animania.bullDamage, 4.0f);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        if (entityIn instanceof EntityPlayer) {
            ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 1.0f, this.field_70165_t - entityIn.field_70165_t, this.field_70161_v - entityIn.field_70161_v);
        }
        return flag;
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 0;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 18 : (happy == 1 ? 36 : 60))) == 0) {
            return ModSoundEvents.bullMoo1;
        }
        if (chooser == 1) {
            return ModSoundEvents.bullMoo2;
        }
        if (chooser == 2) {
            return ModSoundEvents.bullMoo3;
        }
        if (chooser == 3) {
            return ModSoundEvents.bullMoo4;
        }
        if (chooser == 4) {
            return ModSoundEvents.bullMoo5;
        }
        if (chooser == 5) {
            return ModSoundEvents.bullMoo6;
        }
        if (chooser == 6) {
            return ModSoundEvents.bullMoo7;
        }
        if (chooser == 7) {
            return ModSoundEvents.bullMoo8;
        }
        if (chooser == 8) {
            return ModSoundEvents.moo4;
        }
        if (chooser == 9) {
            return ModSoundEvents.moo8;
        }
        if (chooser == 10) {
            return ModSoundEvents.moo4;
        }
        return ModSoundEvents.moo8;
    }

    protected SoundEvent func_184601_bQ() {
        Random rand = new Random();
        int chooser = rand.nextInt(2);
        if (chooser == 0) {
            return ModSoundEvents.angryBull1;
        }
        if (chooser == 1) {
            return ModSoundEvents.angryBull2;
        }
        return ModSoundEvents.angryBull3;
    }

    protected SoundEvent func_184615_bR() {
        Random rand = new Random();
        int chooser = rand.nextInt(2);
        if (chooser == 0) {
            return ModSoundEvents.cowDeath1;
        }
        return ModSoundEvents.cowDeath2;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - 0.2f);
        }
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Items.field_151116_aA;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.eatTimer = Math.max(0, this.eatTimer - 1);
        }
        if (this.fedTimer > -1) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0) {
                this.setWatered(false);
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        } else if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && Animania.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.001;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
        super.func_70636_d();
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int happyDrops = 0;
        if (this.getWatered()) {
            ++happyDrops;
        }
        if (this.getFed()) {
            ++happyDrops;
        }
        int j = happyDrops + 1;
        j = happyDrops + 1;
        for (int k = 0; k < j; ++k) {
            if (this.func_70027_ad()) {
                this.func_145779_a(Items.field_151083_be, 1);
                this.func_145779_a(Items.field_151116_aA, 1);
                continue;
            }
            this.func_145779_a(Items.field_151082_bd, 1);
            this.func_145779_a(Items.field_151116_aA, 1);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151131_as) {
            if (--stack.field_77994_a == 0) {
                player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151133_ar))) {
                player.func_71019_a(new ItemStack(Items.field_151133_ar), false);
            }
            this.eatTimer = 40;
            this.entityAIEatGrass.func_75249_e();
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 160;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 156 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 160) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 156) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 64.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && this.isCowBreedingItem(stack.func_77973_b());
    }

    private boolean isCowBreedingItem(Item itemIn) {
        return itemIn == Items.field_151015_O || itemIn == Item.func_150898_a((Block)Blocks.field_150327_N) || itemIn == Item.func_150898_a((Block)Blocks.field_150328_O);
    }

    public EntityBullFriesian createChild(EntityAgeable p_90011_1_) {
        return null;
    }
}

