/*
 * Decompiled with CFR 0.152.
 */
package com.animania.entities.chickens;

import com.animania.Animania;
import com.animania.AnimaniaAchievements;
import com.animania.ModSoundEvents;
import com.animania.entities.chickens.EntityAIFindFood;
import com.animania.entities.chickens.EntityAIFindWater;
import com.animania.entities.chickens.EntityAIPanicChickens;
import com.animania.entities.chickens.EntityAISwimmingChicks;
import com.animania.entities.chickens.EntityAIWatchClosestFromSide;
import com.animania.entities.chickens.EntityHenPlymouthRock;
import com.animania.entities.chickens.EntityRoosterPlymouthRock;
import com.google.common.collect.Sets;
import com.google.common.reflect.ClassPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityChickPlymouthRock
extends EntityAnimal {
    private static final DataParameter<String> COLOR = EntityDataManager.func_187226_a(EntityChickPlymouthRock.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityChickPlymouthRock.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityChickPlymouthRock.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> AGE = EntityDataManager.func_187226_a(EntityChickPlymouthRock.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    public int timeUntilNextEgg;
    public boolean chickenJockey;
    private static List ColorList;
    private ResourceLocation resourceLocation;
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    private int fedTimer;
    private int wateredTimer;
    private int ageTimer;
    private int happyTimer;

    public EntityChickPlymouthRock(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.4f);
        this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimmingChicks((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanicChickens((EntityCreature)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFindWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFindFood((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosestFromSide((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.ageTimer = 0;
        String texture = null;
        if (this.getColor() == "") {
            this.setColor(this.getRandomColor());
            texture = this.getColor();
            this.resourceLocation = new ResourceLocation(texture);
        }
    }

    protected void func_175505_a(EntityPlayer player, ItemStack stack) {
        this.setFed(true);
        player.func_71064_a((StatBase)AnimaniaAchievements.PlymouthRock, 1);
        if (player.func_189102_a(AnimaniaAchievements.Leghorn) && player.func_189102_a(AnimaniaAchievements.Orpington) && player.func_189102_a(AnimaniaAchievements.PlymouthRock) && player.func_189102_a(AnimaniaAchievements.RhodeIslandRed) && player.func_189102_a(AnimaniaAchievements.Wyandotte)) {
            player.func_71064_a((StatBase)AnimaniaAchievements.Chickens, 1);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    public boolean isAIEnabled() {
        return true;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151131_as) {
            this.setWatered(true);
            this.func_146082_f(player);
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    public String getColor() {
        return (String)this.field_70180_af.func_187225_a(COLOR);
    }

    public void setColor(String color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)String.valueOf(color));
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    private String getRandomColor() {
        this.ColorInitialize();
        Collections.shuffle(ColorList);
        Random rand = new Random();
        if (rand.nextInt(2) == 0) {
            return "animania:textures/entity/chickens/chick_specked.png";
        }
        return "animania:textures/entity/chickens/chick_black.png";
    }

    private void ColorInitialize() {
        if (ColorList == null) {
            ColorList = new ArrayList();
            try {
                Pattern p = Pattern.compile("assets/animania/textures/(entity/chickens/chick_.*)");
                for (ClassPath.ResourceInfo i : ClassPath.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getResources()) {
                    Matcher m = p.matcher(i.getResourceName());
                    if (!m.matches()) continue;
                    String s = m.group(1);
                    ColorList.add(s);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)"");
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(AGE, (Object)Float.valueOf(0.0f));
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74778_a("Color", this.getColor());
        nbttagcompound.func_74757_a("IsChickenJockey", this.chickenJockey);
        nbttagcompound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
        nbttagcompound.func_74757_a("Fed", this.getFed());
        nbttagcompound.func_74757_a("Watered", this.getWatered());
        nbttagcompound.func_74776_a("Age", this.getEntityAge());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        String s1 = nbttagcompound.func_74779_i("Color");
        this.ColorInitialize();
        if (s1.length() > 0 && ColorList.contains(s1)) {
            this.setColor(s1);
            this.resourceLocation = new ResourceLocation(s1);
        }
        this.chickenJockey = nbttagcompound.func_74767_n("IsChickenJockey");
        if (nbttagcompound.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = nbttagcompound.func_74762_e("EggLayTime");
        }
        this.setFed(nbttagcompound.func_74767_n("Fed"));
        this.setWatered(nbttagcompound.func_74767_n("Watered"));
        this.setEntityAge(nbttagcompound.func_74760_g("Age"));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
        if (this.fedTimer > -1) {
            --this.fedTimer;
            if (this.fedTimer == 0) {
                this.setFed(false);
            }
        }
        if (this.wateredTimer > -1) {
            --this.wateredTimer;
            if (this.wateredTimer == 0) {
                this.setWatered(false);
            }
        }
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        if (!fed || !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 0, false, false));
        } else if (!fed && !watered) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 2, 1, false, false));
        }
        ++this.ageTimer;
        if (this.ageTimer >= Animania.childGrowthTick && fed && watered) {
            this.ageTimer = 0;
            float age = this.getEntityAge();
            this.setEntityAge(age += 0.01f);
            if ((double)age >= 0.5 && !this.field_70170_p.field_72995_K) {
                String name;
                this.func_70106_y();
                if (this.field_70146_Z.nextInt(2) < 1) {
                    EntityHenPlymouthRock entityHen = new EntityHenPlymouthRock(this.field_70170_p);
                    entityHen.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                    name = this.func_95999_t();
                    if (name != "") {
                        entityHen.func_96094_a(name);
                    }
                    this.field_70170_p.func_72838_d((Entity)entityHen);
                    this.func_184185_a(ModSoundEvents.chickenHurt1, 0.5f, 1.1f);
                } else {
                    EntityRoosterPlymouthRock entityRooster = new EntityRoosterPlymouthRock(this.field_70170_p);
                    entityRooster.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                    name = this.func_95999_t();
                    if (name != "") {
                        entityRooster.func_96094_a(name);
                    }
                    this.field_70170_p.func_72838_d((Entity)entityRooster);
                    this.func_184185_a(ModSoundEvents.chickenCrow1, 0.5f, 1.1f);
                }
            }
        }
        if (this.happyTimer > -1) {
            --this.happyTimer;
            if (this.happyTimer == 0) {
                this.happyTimer = 60;
                if (!this.getFed() && !this.getWatered() && Animania.showUnhappyParticles) {
                    double d = this.field_70146_Z.nextGaussian() * 0.001;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.001;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.001;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + 1.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                }
            }
        }
    }

    public boolean getFed() {
        return (Boolean)this.field_70180_af.func_187225_a(FED);
    }

    public void setFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = Animania.feedTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getWatered() {
        return (Boolean)this.field_70180_af.func_187225_a(WATERED);
    }

    public void setWatered(boolean watered) {
        if (watered) {
            this.field_70180_af.func_187227_b(WATERED, (Object)true);
            this.wateredTimer = Animania.waterTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(WATERED, (Object)false);
        }
    }

    public float getEntityAge() {
        return ((Float)this.field_70180_af.func_187225_a(AGE)).floatValue();
    }

    public void setEntityAge(float age) {
        this.field_70180_af.func_187227_b(AGE, (Object)Float.valueOf(age));
    }

    protected void fall(float p_70069_1_) {
    }

    protected SoundEvent func_184639_G() {
        Random rand;
        int chooser;
        int happy = 0;
        int num = 0;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = (rand = new Random()).nextInt(num = happy == 2 ? 6 : (happy == 1 ? 12 : 24))) == 0) {
            return ModSoundEvents.chickenCluck1;
        }
        if (chooser == 1) {
            return ModSoundEvents.chickenCluck2;
        }
        if (chooser == 2) {
            return ModSoundEvents.chickenCluck3;
        }
        if (chooser == 3) {
            return ModSoundEvents.chickenCluck4;
        }
        if (chooser == 4) {
            return ModSoundEvents.chickenCluck5;
        }
        return ModSoundEvents.chickenCluck6;
    }

    protected SoundEvent func_184601_bQ() {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP() - 0.3f, this.func_70647_i() + 0.9f - this.getEntityAge() * 2.0f);
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.1f, 1.4f);
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    protected int func_70693_a(EntityPlayer player) {
        return this.isChickenJockey() ? 10 : super.func_70693_a(player);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        float f = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f2 = 0.1f;
        float f3 = 0.0f;
        passenger.func_70107_b(this.field_70165_t + (double)(0.1f * f), this.field_70163_u + (double)(this.field_70131_O * 0.5f) + passenger.func_70033_W() + 0.0, this.field_70161_v - (double)(0.1f * f1));
        if (passenger instanceof EntityLivingBase) {
            ((EntityLivingBase)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    public boolean isChickenJockey() {
        return this.chickenJockey;
    }

    public void setChickenJockey(boolean jockey) {
        this.chickenJockey = jockey;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }
}

