/*
 * Decompiled with CFR 0.152.
 */
package lellson.foodexpansion.items;

import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ItemFoodBasic
extends ItemFood {
    private int hungerPoints;
    private float saturation;
    private PotionEffect[] effects;
    private int probability;
    private ItemStack returnItem;
    private int maxUseDuration;

    public ItemFoodBasic(String name, int foodAmount, float saturation, boolean wolfFav, PotionEffect[] effects, int probability, ItemStack returnItem, int useDuration) {
        super(foodAmount, saturation, wolfFav);
        this.func_77655_b(name);
        this.setRegistryName(name);
        if (effects.length != 0 && name != "ItemBatWing" && name != "ItemCookedBatWing") {
            this.func_77848_i();
        }
        if (returnItem != null) {
            this.func_77625_d(1);
        }
        this.hungerPoints = foodAmount;
        this.saturation = saturation;
        this.effects = effects;
        this.probability = probability;
        this.returnItem = returnItem;
        this.maxUseDuration = useDuration;
    }

    public ItemFoodBasic(String name, int foodAmount, float saturation, boolean wolfFav, PotionEffect[] effects, ItemStack returnItem, int useDuration) {
        this(name, foodAmount, saturation, wolfFav, effects, 1, returnItem, useDuration);
    }

    public ItemFoodBasic(String name, int foodAmount, float saturation, boolean wolfFav, int useDuration) {
        this(name, foodAmount, saturation, wolfFav, new PotionEffect[0], null, useDuration);
    }

    public ItemFoodBasic(String name, int foodAmount, float saturation, boolean wolfFav, ItemStack returnItem) {
        this(name, foodAmount, saturation, wolfFav, new PotionEffect[0], returnItem, 32);
    }

    public ItemFoodBasic(String name, int foodAmount, float saturation, boolean wolfFav) {
        this(name, foodAmount, saturation, wolfFav, 32);
    }

    public ItemFoodBasic(String name, int foodAmount, float saturation) {
        this(name, foodAmount, saturation, false);
    }

    public ItemStack onEaten(ItemStack item, World world, EntityPlayer player, Random rnd) {
        if (!player.field_71075_bZ.field_75098_d) {
            --item.field_77994_a;
        }
        for (PotionEffect effect : this.effects) {
            if (rnd.nextInt(this.probability) != 0) continue;
            player.func_70690_d(new PotionEffect(effect));
        }
        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, rnd.nextFloat() * 0.1f + 0.9f);
        player.func_71029_a(StatList.func_188057_b((Item)this));
        player.func_71024_bL().func_75122_a(this.hungerPoints, this.saturation);
        return this.returnItem != null ? this.returnItem : item;
    }

    public ItemStack func_77654_b(ItemStack item, World world, EntityLivingBase entity) {
        return this.onEaten(item, world, (EntityPlayer)entity, world.field_73012_v);
    }

    public int func_77626_a(ItemStack stack) {
        return this.maxUseDuration;
    }
}

