/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.util;

import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.SubTile;
import hunternif.mc.atlas.client.SubTileQuartet;
import hunternif.mc.atlas.client.Textures;
import hunternif.mc.atlas.client.TileRenderIterator;
import hunternif.mc.atlas.client.gui.ExportUpdateListener;
import hunternif.mc.atlas.core.DimensionData;
import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerRenderInfo;
import hunternif.mc.atlas.registry.MarkerType;
import hunternif.mc.atlas.registry.MarkerTypes;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.Rect;
import hunternif.mc.atlas.util.RenderedImageScanned;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ExportImageUtil {
    public static final int TILE_SIZE = 16;
    public static final int MARKER_SIZE = 32;
    public static boolean isExporting = false;
    private static Frame frame;
    private static final JFileChooser chooser;
    private static final int BG_TILE_SIZE = 22;

    private static ExportUpdateListener getListener() {
        return ExportUpdateListener.INSTANCE;
    }

    public static File selectPngFileToSave(String atlasName) {
        ExportImageUtil.getListener().setHeaderString("", new Object[0]);
        ExportImageUtil.getListener().setStatusString("gui.antiqueatlas.export.opening", new Object[0]);
        ExportImageUtil.getListener().setProgressMax(-1);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            Log.error(e, "Setting system Look&Feel for JFileChooser", new Object[0]);
        }
        ExportImageUtil.getListener().setStatusString("gui.antiqueatlas.export.selectFile", new Object[0]);
        frame = new Frame();
        if (chooser.showSaveDialog(frame) == 0) {
            File file = chooser.getSelectedFile();
            frame.dispose();
            if (file.getName().length() < 4 || !file.getName().substring(file.getName().length() - 4).equalsIgnoreCase(".png")) {
                file = new File(file.getAbsolutePath() + ".png");
            }
            return file;
        }
        frame.dispose();
        return null;
    }

    public static void exportPngImage(DimensionData biomeData, DimensionMarkersData globalMarkers, DimensionMarkersData localMarkers, File file, boolean showMarkers) {
        ExportImageUtil.getListener().setHeaderString("gui.antiqueatlas.export.setup", new Object[0]);
        int minX = (biomeData.getScope().minX - 1) * 16;
        int minY = (biomeData.getScope().minY - 1) * 16;
        int outWidth = (biomeData.getScope().maxX + 2) * 16 - minX;
        int outHeight = (biomeData.getScope().maxY + 2) * 16 - minY;
        Log.info("Image size: %dx%d", outWidth, outHeight);
        ExportImageUtil.getListener().setStatusString("gui.antiqueatlas.export.makingbuffer", outWidth, outHeight);
        BufferedImage outImage = new BufferedImage(outWidth, outHeight, 2);
        Graphics2D graphics = outImage.createGraphics();
        int scale = 2;
        int bgTilesX = Math.round((float)outWidth / 22.0f / (float)scale);
        int bgTilesY = Math.round((float)outHeight / 22.0f / (float)scale);
        ExportImageUtil.getListener().setStatusString("gui.antiqueatlas.export.loadingtextures", new Object[0]);
        ExportImageUtil.getListener().setProgressMax(-1);
        BufferedImage bg = null;
        HashMap<ResourceLocation, BufferedImage> textureImageMap = new HashMap<ResourceLocation, BufferedImage>();
        try {
            InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(Textures.EXPORTED_BG).func_110527_b();
            bg = ImageIO.read(is);
            is.close();
            ArrayList<ResourceLocation> allTextures = new ArrayList<ResourceLocation>(64);
            allTextures.addAll(BiomeTextureMap.instance().getAllTextures());
            if (showMarkers) {
                for (MarkerType type : MarkerRegistry.getValues()) {
                    allTextures.addAll(Arrays.asList(type.getAllIcons()));
                }
            }
            for (ResourceLocation texture : allTextures) {
                try {
                    is = Minecraft.func_71410_x().func_110442_L().func_110536_a(texture).func_110527_b();
                    BufferedImage tileImage = ImageIO.read(is);
                    is.close();
                    textureImageMap.put(texture, tileImage);
                }
                catch (FileNotFoundException e) {
                    Log.warn("Texture %s not found!", texture.toString());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ExportImageUtil.getListener().setHeaderString("gui.antiqueatlas.export.rendering", new Object[0]);
        ExportImageUtil.drawMapToGraphics(graphics, bgTilesX, bgTilesY, outWidth, outHeight, biomeData, textureImageMap, globalMarkers, localMarkers, showMarkers, minX, minY, scale, bg);
        try {
            ExportImageUtil.getListener().setHeaderString("", new Object[0]);
            ExportImageUtil.getListener().setStatusString("gui.antiqueatlas.export.writing", new Object[0]);
            ImageIO.write((RenderedImage)outImage, "PNG", file);
            Log.info("Done writing image", new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportPngImageTooLarge(DimensionData biomeData, DimensionMarkersData globalMarkers, DimensionMarkersData localMarkers, File file, boolean showMarkers) {
        ExportImageUtil.getListener().setHeaderString("", new Object[0]);
        int minX = (biomeData.getScope().minX - 1) * 16;
        int minY = (biomeData.getScope().minY - 1) * 16;
        int outWidth = (biomeData.getScope().maxX + 2) * 16 - minX;
        int outHeight = (biomeData.getScope().maxY + 2) * 16 - minY;
        Log.info("Image size: %dx%d", outWidth, outHeight);
        int scale = 2;
        int bgTilesX = Math.round((float)outWidth / 22.0f / 2.0f);
        int bgTilesY = Math.round((float)outHeight / 22.0f / 2.0f);
        ExportImageUtil.getListener().setStatusString("gui.antiqueatlas.export.loadingtextures", new Object[0]);
        ExportImageUtil.getListener().setProgressMax(-1);
        BufferedImage bg = null;
        HashMap<ResourceLocation, BufferedImage> textureImageMap = new HashMap<ResourceLocation, BufferedImage>();
        try {
            InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(Textures.EXPORTED_BG).func_110527_b();
            bg = ImageIO.read(is);
            is.close();
            ArrayList<ResourceLocation> allTextures = new ArrayList<ResourceLocation>(64);
            allTextures.addAll(BiomeTextureMap.instance().getAllTextures());
            if (showMarkers) {
                for (MarkerType type : MarkerRegistry.getValues()) {
                    allTextures.addAll(Arrays.asList(type.getAllIcons()));
                }
            }
            for (ResourceLocation texture : allTextures) {
                try {
                    is = Minecraft.func_71410_x().func_110442_L().func_110536_a(texture).func_110527_b();
                    BufferedImage tileImage = ImageIO.read(is);
                    is.close();
                    textureImageMap.put(texture, tileImage);
                }
                catch (FileNotFoundException e) {
                    Log.warn("Texture %s not found!", texture.toString());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.gc();
        long availableMem = ExportImageUtil.getAvailableMemory();
        long usableMem = (long)((double)availableMem * 0.8);
        int pixelSize = 4;
        int sliceHeight = 16;
        for (int i = bgTilesY; i > 0; --i) {
            long usedMem = (long)(i * 16) * (long)outWidth * (long)pixelSize;
            if (usedMem <= usableMem) {
                sliceHeight = i * 16;
                break;
            }
            Log.info("%d tiles tall is too big, %d > %d", i, usedMem, usableMem);
        }
        int sliceHeight_ = sliceHeight;
        int slices = (int)Math.ceil((float)outHeight / (float)sliceHeight);
        BufferedImage bg_ = bg;
        BufferedImage scanBuffer = new BufferedImage(outWidth, sliceHeight, 2);
        ExportImageUtil.getListener().setProgressMax(slices);
        RenderedImageScanned outImage = new RenderedImageScanned(outWidth, outHeight, scanBuffer, graphics -> {
            int slice = (int)Math.floor(-graphics.getTransform().getTranslateY() / (double)sliceHeight_);
            ExportImageUtil.getListener().setProgress(slice);
            ExportImageUtil.getListener().setHeaderString("gui.antiqueatlas.export.renderstripe", slice + 1, slices);
            ExportImageUtil.drawMapToGraphics(graphics, bgTilesX, bgTilesY, outWidth, outHeight, biomeData, textureImageMap, globalMarkers, localMarkers, showMarkers, minX, minY, 2, bg_);
            ExportImageUtil.getListener().setStatusString("gui.antiqueatlas.export.writestripe", new Object[0]);
            ExportImageUtil.getListener().setProgressMax(sliceHeight_ * (slice + 1) > outHeight ? outHeight - sliceHeight_ * slice : sliceHeight_);
        }, value -> ExportImageUtil.getListener().setProgress(value));
        try {
            ExportImageUtil.getListener().setHeaderString("gui.antiqueatlas.export.renderstripe", 1, slices);
            ImageIO.write((RenderedImage)outImage, "PNG", file);
            Log.info("Done writing image", new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static long getAvailableMemory() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        long usedMemory = totalMemory - freeMemory;
        return maxMemory - usedMemory;
    }

    private static void drawMapToGraphics(Graphics2D graphics, int bgTilesX, int bgTilesY, int outWidth, int outHeight, DimensionData biomeData, Map<ResourceLocation, BufferedImage> textureImageMap, DimensionMarkersData globalMarkers, DimensionMarkersData localMarkers, boolean showMarkers, int minX, int minY, int scale, BufferedImage bg) {
        int y;
        int x;
        ExportImageUtil.getListener().setStatusString("gui.antiqueatlas.export.rendering.background", new Object[0]);
        ExportImageUtil.getListener().setProgressMax(bgTilesX * bgTilesY);
        graphics.drawImage(bg, 0, 0, 22 * scale, 22 * scale, 0, 0, 22, 22, null);
        ExportImageUtil.getListener().addProgress(1);
        for (x = 1; x < bgTilesX; ++x) {
            graphics.drawImage(bg, x * 22 * scale, 0, (x + 1) * 22 * scale, 22 * scale, 22, 0, 44, 22, null);
            ExportImageUtil.getListener().addProgress(1);
        }
        for (y = 1; y < bgTilesY; ++y) {
            graphics.drawImage(bg, 0, y * 22 * scale, 22 * scale, (y + 1) * 22 * scale, 0, 22, 22, 44, null);
            ExportImageUtil.getListener().addProgress(1);
        }
        for (x = 1; x < bgTilesX; ++x) {
            for (int y2 = 1; y2 < bgTilesY; ++y2) {
                graphics.drawImage(bg, x * 22 * scale, y2 * 22 * scale, (x + 1) * 22 * scale, (y2 + 1) * 22 * scale, 22, 22, 44, 44, null);
                ExportImageUtil.getListener().addProgress(1);
            }
        }
        graphics.drawImage(bg, outWidth - 22 * scale, 0, outWidth, 22 * scale, 44, 0, 66, 22, null);
        ExportImageUtil.getListener().addProgress(1);
        for (y = 1; y < bgTilesY; ++y) {
            graphics.drawImage(bg, outWidth - 22 * scale, y * 22 * scale, outWidth, (y + 1) * 22 * scale, 44, 22, 66, 44, null);
            ExportImageUtil.getListener().addProgress(1);
        }
        graphics.drawImage(bg, 0, outHeight - 22 * scale, 22 * scale, outHeight, 0, 44, 22, 66, null);
        ExportImageUtil.getListener().addProgress(1);
        for (x = 1; x < bgTilesX; ++x) {
            graphics.drawImage(bg, x * 22 * scale, outHeight - 22 * scale, (x + 1) * 22 * scale, outHeight, 22, 44, 44, 66, null);
            ExportImageUtil.getListener().addProgress(1);
        }
        graphics.drawImage(bg, outWidth - 22 * scale, outHeight - 22 * scale, outWidth, outHeight, 44, 44, 66, 66, null);
        ExportImageUtil.getListener().addProgress(1);
        Rect scope = biomeData.getScope();
        ExportImageUtil.getListener().setStatusString("gui.antiqueatlas.export.rendering.map", new Object[0]);
        ExportImageUtil.getListener().setProgressMax(scope.getHeight() * scope.getWidth());
        TileRenderIterator iter = new TileRenderIterator(biomeData);
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                ResourceLocation texture;
                BufferedImage tileImage;
                if (subtile == null || subtile.tile == null || (tileImage = textureImageMap.get(texture = BiomeTextureMap.instance().getTexture(subtile.tile))) == null) continue;
                graphics.drawImage(tileImage, 16 + subtile.x * 16 / 2, 16 + subtile.y * 16 / 2, 16 + (subtile.x + 1) * 16 / 2, 16 + (subtile.y + 1) * 16 / 2, subtile.getTextureU() * 16 / 2, subtile.getTextureV() * 16 / 2, (subtile.getTextureU() + 1) * 16 / 2, (subtile.getTextureV() + 1) * 16 / 2, null);
            }
            ExportImageUtil.getListener().addProgress(1);
        }
        ExportImageUtil.getListener().setStatusString("gui.antiqueatlas.export.rendering.markers", new Object[0]);
        ExportImageUtil.getListener().setProgressMax(-1);
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (int x2 = biomeData.getScope().minX / 8; x2 <= biomeData.getScope().maxX / 8; ++x2) {
            for (int z = biomeData.getScope().minY / 8; z <= biomeData.getScope().maxY / 8; ++z) {
                List<Marker> localMarkersAt;
                markers.clear();
                List<Marker> globalMarkersAt = globalMarkers.getMarkersAtChunk(x2, z);
                if (globalMarkersAt != null) {
                    markers.addAll(globalMarkers.getMarkersAtChunk(x2, z));
                }
                if (localMarkers != null && (localMarkersAt = localMarkers.getMarkersAtChunk(x2, z)) != null) {
                    markers.addAll(localMarkersAt);
                }
                for (Marker marker : markers) {
                    MarkerType type = MarkerRegistry.find(marker.getType());
                    if (type == null) {
                        Log.warn("Could not find marker data for type: ", marker.getType());
                        type = MarkerTypes.UNKNOWN;
                    }
                    if (!marker.isVisibleAhead() && !biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ()) || type.shouldHide(!showMarkers, 0)) continue;
                    type.calculateMip(1.0, 1.0, 1.0);
                    MarkerRenderInfo info = type.getRenderInfo(1.0, 1.0, 1.0);
                    type.resetMip();
                    ResourceLocation texture = info.tex;
                    BufferedImage markerImage = textureImageMap.get(texture);
                    if (markerImage == null) continue;
                    int markerX = marker.getX() - minX;
                    int markerY = marker.getZ() - minY;
                    graphics.drawImage(markerImage, (int)((double)markerX + info.x), (int)((double)markerY + info.y), info.width, info.height, null);
                }
            }
        }
    }

    static {
        chooser = new JFileChooser();
        chooser.setDialogTitle(I18n.func_135052_a((String)"gui.antiqueatlas.exportImage", (Object[])new Object[0]));
        chooser.setSelectedFile(new File("Atlas.png"));
        chooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "PNG Image";
            }

            @Override
            public boolean accept(File file) {
                return true;
            }
        });
    }
}

