/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.MathUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NetherFortressWatcher {
    private final Set<String> visited = new HashSet<String>();
    private static final String ROOFED = "NeSCLT";
    private static final String ROOFED2 = "NeSCR";
    private static final String ROOFED_STAIRS = "NeCCS";
    private static final String ROOFED3 = "NeCTB";
    private static final String ROOFED4 = "NeSC";
    private static final String BRIDGE_GATE = "NeRC";
    private static final String ROOFED_CROSS = "NeSCSC";
    private static final String BRIDGE_CROSS = "NeBCr";
    private static final String START = "NeStart";
    private static final String BRIDGE = "NeBS";
    private static final String BRIDGE_END = "NeBEF";
    private static final String ENTRANCE = "NeCE";
    private static final String WART_STAIRS = "NeCSR";
    private static final String THRONE = "NeMT";
    private static final String TOWER = "NeSR";

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == -1) {
            this.visitAllUnvisitedFortresses(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onPopulateChunk(PopulateChunkEvent.Post event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == -1) {
            this.visitAllUnvisitedFortresses(event.getWorld());
        }
    }

    public void visitAllUnvisitedFortresses(World world) {
        MapGenStructureData data = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "Fortress");
        if (data == null) {
            return;
        }
        NBTTagCompound fortressNBTData = data.func_143041_a();
        Set tagSet = fortressNBTData.func_150296_c();
        for (String coords : tagSet) {
            NBTBase tag;
            if (this.visited.contains(coords) || (tag = fortressNBTData.func_74781_a(coords)).func_74732_a() != 10) continue;
            this.visitFortress(world, (NBTTagCompound)tag);
            this.visited.add(coords);
        }
    }

    private void visitFortress(World world, NBTTagCompound tag) {
        int startChunkX = tag.func_74762_e("ChunkX");
        int startChunkZ = tag.func_74762_e("ChunkZ");
        Log.info("Visiting Nether Fortress in dimension #%d \"%s\" at chunk (%d, %d) ~ blocks (%d, %d)", world.field_73011_w.getDimension(), world.field_73011_w.func_186058_p().func_186065_b(), startChunkX, startChunkZ, startChunkX << 4, startChunkZ << 4);
        NBTTagList children = tag.func_150295_c("Children", 10);
        for (int i = 0; i < children.func_74745_c(); ++i) {
            int chunkX;
            int chunkZ;
            NBTTagCompound child = children.func_150305_b(i);
            String childID = child.func_74779_i("id");
            StructureBoundingBox boundingBox = new StructureBoundingBox(child.func_74759_k("BB"));
            if (BRIDGE.equals(childID)) {
                if (boundingBox.func_78883_b() > 16) {
                    String tileName = "netherBridgeX";
                    chunkZ = MathUtil.getCenter(boundingBox).func_177952_p() >> 4;
                    for (int x = boundingBox.field_78897_a; x < boundingBox.field_78893_d; x += 16) {
                        int chunkX2 = x >> 4;
                        if (!NetherFortressWatcher.noTileAt(world, chunkX2, chunkZ)) continue;
                        AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX2, chunkZ);
                    }
                    continue;
                }
                String tileName = "netherBridgeZ";
                chunkX = MathUtil.getCenter(boundingBox).func_177958_n() >> 4;
                for (int z = boundingBox.field_78896_c; z < boundingBox.field_78892_f; z += 16) {
                    int chunkZ2 = z >> 4;
                    if (!NetherFortressWatcher.noTileAt(world, chunkX, chunkZ2)) continue;
                    AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX, chunkZ2);
                }
                continue;
            }
            if (BRIDGE_END.equals(childID)) {
                int chunkZ3;
                String tileName;
                if (boundingBox.func_78883_b() > boundingBox.func_78880_d()) {
                    tileName = "netherBridgeEndX";
                    chunkX = boundingBox.field_78897_a >> 4;
                    chunkZ3 = MathUtil.getCenter(boundingBox).func_177952_p() >> 4;
                } else {
                    tileName = "netherBridgeEndZ";
                    chunkX = MathUtil.getCenter(boundingBox).func_177958_n() >> 4;
                    chunkZ3 = boundingBox.field_78896_c >> 4;
                }
                if (!NetherFortressWatcher.noTileAt(world, chunkX, chunkZ3)) continue;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX, chunkZ3);
                continue;
            }
            int chunkX3 = MathUtil.getCenter(boundingBox).func_177958_n() >> 4;
            chunkZ = MathUtil.getCenter(boundingBox).func_177952_p() >> 4;
            if (BRIDGE_GATE.equals(childID)) {
                String tileName = "netherBridgeGate";
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (BRIDGE_CROSS.equals(childID) || START.equals(childID)) {
                String tileName = "netherBridge";
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (TOWER.equals(childID)) {
                String tileName = "netherTower";
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (ENTRANCE.equals(childID)) {
                String tileName = "netherHall";
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (WART_STAIRS.equals(childID)) {
                String tileName = "netherFortStairs";
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (THRONE.equals(childID)) {
                String tileName = "netherThrone";
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            String tileName = "netherWall";
            if (!NetherFortressWatcher.noTileAt(world, chunkX3, chunkZ)) continue;
            AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
        }
    }

    private static boolean noTileAt(World world, int chunkX, int chunkZ) {
        return AntiqueAtlasMod.extBiomeData.getData().getBiomeIdAt(world.field_73011_w.getDimension(), chunkX, chunkZ) == -1;
    }
}

