/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client.gui.core;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiComponent
extends GuiScreen {
    private GuiComponent parent = null;
    private final List<GuiComponent> children = new CopyOnWriteArrayList<GuiComponent>();
    int properWidth;
    int properHeight;
    int contentWidth;
    int contentHeight;
    private boolean sizeIsInvalid = false;
    private boolean isClipped = false;
    protected boolean isMouseOver = false;
    private boolean interceptsMouse = true;
    private boolean interceptsKeyboard = true;
    private boolean hasHandledKeyboard = false;
    private boolean hasHandledMouse = false;
    private boolean blocksScreen = false;
    private int guiX = 0;
    private int guiY = 0;
    private final HoveringTextInfo hoveringTextInfo = new HoveringTextInfo();

    public void setGuiCoords(int x, int y) {
        int dx = x - this.guiX;
        int dy = y - this.guiY;
        this.guiX = x;
        this.guiY = y;
        for (GuiComponent child : this.children) {
            child.offsetGuiCoords(dx, dy);
        }
        if (this.parent != null && (dx != 0 || dy != 0)) {
            this.parent.invalidateSize();
        }
    }

    public final void setRelativeCoords(int x, int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(x, y);
        }
    }

    public final void setRelativeX(int x) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.guiY);
        } else {
            this.setGuiCoords(x, this.guiY);
        }
    }

    public final void setRelativeY(int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.guiX, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(this.guiX, y);
        }
    }

    public final void offsetGuiCoords(int dx, int dy) {
        this.setGuiCoords(this.guiX + dx, this.guiY + dy);
    }

    protected final void setCentered() {
        this.validateSize();
        if (this.parent == null) {
            this.setGuiCoords((this.field_146294_l - this.getWidth()) / 2, (this.field_146295_m - this.getHeight()) / 2);
        } else {
            this.setRelativeCoords((this.parent.getWidth() - this.getWidth()) / 2, (this.parent.getHeight() - this.getHeight()) / 2);
        }
    }

    public int getGuiX() {
        return this.guiX;
    }

    public int getGuiY() {
        return this.guiY;
    }

    int getRelativeX() {
        return this.parent == null ? this.guiX : this.guiX - this.parent.guiX;
    }

    int getRelativeY() {
        return this.parent == null ? this.guiY : this.guiY - this.parent.guiY;
    }

    protected void setSize(int width, int height) {
        this.properWidth = width;
        this.properHeight = height;
        this.contentWidth = width;
        this.contentHeight = height;
        this.invalidateSize();
    }

    protected GuiComponent addChild(GuiComponent child) {
        this.doAddChild(null, child, null);
        return child;
    }

    public GuiComponent addChildInfrontOf(GuiComponent inFrontOf, GuiComponent child) {
        this.doAddChild(inFrontOf, child, null);
        return child;
    }

    protected GuiComponent addChildBehind(GuiComponent behind, GuiComponent child) {
        this.doAddChild(null, child, behind);
        return child;
    }

    private void doAddChild(GuiComponent inFrontOf, GuiComponent child, GuiComponent behind) {
        if (child == null || this.children.contains((Object)child) || this.parent == child) {
            return;
        }
        int i = this.children.indexOf((Object)inFrontOf);
        if (i == -1) {
            int j = this.children.indexOf((Object)behind);
            if (j == -1) {
                this.children.add(child);
            } else {
                this.children.add(j, child);
            }
        } else {
            this.children.add(i + 1, child);
        }
        child.parent = this;
        child.setGuiCoords(this.guiX, this.guiY);
        if (this.field_146297_k != null) {
            child.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
        this.invalidateSize();
    }

    protected GuiComponent removeChild(GuiComponent child) {
        if (child != null && this.children.contains((Object)child)) {
            child.parent = null;
            this.children.remove((Object)child);
            this.invalidateSize();
            this.onChildClosed(child);
        }
        return child;
    }

    void removeAllChildren() {
        this.children.clear();
        this.invalidateSize();
    }

    public GuiComponent getParent() {
        return this.parent;
    }

    List<GuiComponent> getChildren() {
        return this.children;
    }

    public void setInterceptMouse(boolean value) {
        this.interceptsMouse = value;
        this.field_146291_p = !this.interceptsMouse | !this.interceptsKeyboard;
    }

    protected void setInterceptKeyboard(boolean value) {
        this.interceptsKeyboard = value;
        this.field_146291_p = !this.interceptsMouse | !this.interceptsKeyboard;
    }

    public void func_146269_k() throws IOException {
        ListIterator<GuiComponent> iter = this.children.listIterator(this.children.size());
        while (iter.hasPrevious()) {
            GuiComponent child = iter.previous();
            if (!child.blocksScreen) continue;
            child.func_146269_k();
            this.isMouseOver = false;
            return;
        }
        if (this.interceptsMouse) {
            while (Mouse.next()) {
                this.func_146274_d();
            }
        }
        if (this.interceptsKeyboard) {
            while (Keyboard.next()) {
                this.func_146282_l();
            }
        }
    }

    void mouseHasBeenHandled() {
        this.hasHandledMouse = true;
    }

    protected void keyboardHasBeenHandled() {
        this.hasHandledKeyboard = true;
    }

    protected void setBlocksScreen(boolean value) {
        this.blocksScreen = value;
    }

    public void func_146274_d() throws IOException {
        boolean handled = false;
        this.isMouseOver = false;
        ListIterator<GuiComponent> iter = this.children.listIterator(this.children.size());
        while (iter.hasPrevious()) {
            GuiComponent child = iter.previous();
            child.func_146274_d();
            if (!child.hasHandledMouse) continue;
            child.hasHandledMouse = false;
            handled = true;
        }
        if (!handled) {
            this.isMouseOver = this.isMouseInRegion(this.getGuiX(), this.getGuiY(), this.getWidth(), this.getHeight());
            super.func_146274_d();
        }
    }

    public void func_146282_l() throws IOException {
        boolean handled = false;
        ListIterator<GuiComponent> iter = this.children.listIterator(this.children.size());
        while (iter.hasPrevious()) {
            GuiComponent child = iter.previous();
            child.func_146282_l();
            if (!child.hasHandledKeyboard) continue;
            child.hasHandledKeyboard = false;
            handled = true;
        }
        if (!handled && Keyboard.getEventKeyState()) {
            this.func_73869_a(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        super.func_73863_a(mouseX, mouseY, partialTick);
        for (GuiComponent child : this.children) {
            if (child.isClipped) continue;
            child.func_73863_a(mouseX, mouseY, partialTick);
        }
        if (this.hoveringTextInfo.shouldDraw) {
            this.drawHoveringText2(this.hoveringTextInfo.lines, this.hoveringTextInfo.x, this.hoveringTextInfo.y, this.hoveringTextInfo.font);
            this.hoveringTextInfo.shouldDraw = false;
        }
    }

    public void func_146281_b() {
        for (GuiComponent child : this.children) {
            child.func_146281_b();
        }
        super.func_146281_b();
    }

    public void func_73876_c() {
        for (GuiComponent child : this.children) {
            child.func_73876_c();
        }
        super.func_73876_c();
        if (this.sizeIsInvalid) {
            this.validateSize();
        }
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        for (GuiComponent child : this.children) {
            child.func_146280_a(mc, width, height);
        }
    }

    protected int getWidth() {
        return this.contentWidth;
    }

    protected int getHeight() {
        return this.contentHeight;
    }

    void setClipped(boolean value) {
        this.isClipped = value;
    }

    private void invalidateSize() {
        this.sizeIsInvalid = true;
        if (this.parent != null) {
            this.parent.invalidateSize();
        }
    }

    void validateSize() {
        int leftmost = Integer.MAX_VALUE;
        int rightmost = Integer.MIN_VALUE;
        int topmost = Integer.MAX_VALUE;
        int bottommost = Integer.MIN_VALUE;
        for (GuiComponent child : this.children) {
            int childHeight;
            int y;
            int childWidth;
            int x = child.getGuiX();
            if (x < leftmost) {
                leftmost = x;
            }
            if (x + (childWidth = child.getWidth()) > rightmost) {
                rightmost = x + childWidth;
            }
            if ((y = child.getGuiY()) < topmost) {
                topmost = y;
            }
            if (y + (childHeight = child.getHeight()) <= bottommost) continue;
            bottommost = y + childHeight;
        }
        this.contentWidth = Math.max(this.properWidth, rightmost - leftmost);
        this.contentHeight = Math.max(this.properHeight, bottommost - topmost);
        this.sizeIsInvalid = false;
    }

    boolean isMouseInRegion(int left, int top, int width, int height) {
        int mouseX = this.getMouseX();
        int mouseY = this.getMouseY();
        return mouseX >= left && mouseX < left + width && mouseY >= top && mouseY < top + height;
    }

    protected boolean isMouseInRadius(int x, int y, int radius) {
        int mouseX = this.getMouseX();
        int mouseY = this.getMouseY();
        return mouseX >= x - radius && mouseX < x + radius && mouseY >= y - radius && mouseY < y + radius;
    }

    private void drawHoveringText2(List<String> lines, int x, int y, FontRenderer font) {
        if (!lines.isEmpty()) {
            boolean stencilEnabled = GL11.glIsEnabled((int)2960);
            if (stencilEnabled) {
                GL11.glDisable((int)2960);
            }
            RenderHelper.func_74518_a();
            int k = 0;
            for (String s : lines) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = x + 12;
            int j1 = y - 12;
            int k1 = 8;
            if (lines.size() > 1) {
                k1 += 2 + (lines.size() - 1) * 10;
            }
            if (i1 + k > this.field_146294_l) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_146295_m) {
                j1 = this.field_146295_m - k1 - 6;
            }
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < lines.size(); ++k2) {
                String s1 = lines.get(k2);
                font.func_175063_a(s1, (float)i1, (float)j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            if (stencilEnabled) {
                GL11.glEnable((int)2960);
            }
            RenderHelper.func_74519_b();
            GlStateManager.func_179147_l();
        }
    }

    private GuiComponent getTopLevelParent() {
        GuiComponent component = this;
        while (component.parent != null) {
            component = component.parent;
        }
        return component;
    }

    protected void drawTooltip(List<String> lines, FontRenderer font) {
        GuiComponent topLevel = this.getTopLevelParent();
        topLevel.hoveringTextInfo.lines = lines;
        topLevel.hoveringTextInfo.x = this.getMouseX();
        topLevel.hoveringTextInfo.y = this.getMouseY();
        topLevel.hoveringTextInfo.font = font;
        topLevel.hoveringTextInfo.shouldDraw = true;
    }

    public void close() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        } else {
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    protected void onChildClosed(GuiComponent child) {
    }

    protected void drawCenteredString(String text, int y, int color, boolean dropShadow) {
        int length = this.field_146289_q.func_78256_a(text);
        this.field_146289_q.func_175065_a(text, (float)((this.field_146294_l - length) / 2), (float)y, color, dropShadow);
    }

    protected int getMouseX() {
        return Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c;
    }

    protected int getMouseY() {
        return this.field_146295_m - Mouse.getY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
    }

    private static class HoveringTextInfo {
        List<String> lines;
        int x;
        int y;
        FontRenderer font;
        boolean shouldDraw = false;

        private HoveringTextInfo() {
        }
    }
}

