/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client.gui;

import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.client.gui.GuiMarkerInList;
import hunternif.mc.atlas.client.gui.core.GuiComponent;
import hunternif.mc.atlas.client.gui.core.GuiScrollingContainer;
import hunternif.mc.atlas.client.gui.core.ToggleGroup;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerType;
import hunternif.mc.atlas.registry.MarkerTypes;
import hunternif.mc.atlas.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.World;

public class GuiMarkerFinalizer
extends GuiComponent {
    private static final MarkerType defaultMarker = MarkerTypes.RED_X_SMALL;
    private World world;
    private int atlasID;
    private int dimension;
    private int x;
    private int z;
    MarkerType selectedType = defaultMarker;
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_SPACING = 4;
    private static final int TYPE_SPACING = 1;
    private static final int TYPE_BG_FRAME = 4;
    private GuiButton btnDone;
    private GuiButton btnCancel;
    private GuiTextField textField;
    private final GuiScrollingContainer scroller;
    private ToggleGroup<GuiMarkerInList> typeRadioGroup;
    private final List<IMarkerTypeSelectListener> listeners = new ArrayList<IMarkerTypeSelectListener>();

    GuiMarkerFinalizer() {
        this.scroller = new GuiScrollingContainer();
        this.scroller.setWheelScrollsHorizontally();
        this.addChild(this.scroller);
    }

    void setMarkerData(World world, int atlasID, int dimension, int markerX, int markerZ) {
        this.world = world;
        this.atlasID = atlasID;
        this.dimension = dimension;
        this.x = markerX;
        this.z = markerZ;
        this.setBlocksScreen(true);
    }

    void addListener(IMarkerTypeSelectListener listener) {
        this.listeners.add(listener);
    }

    void removeListener(IMarkerTypeSelectListener listener) {
        this.listeners.remove(listener);
    }

    void removeAllListeners() {
        this.listeners.clear();
    }

    public void func_73866_w_() {
        this.btnDone = new GuiButton(0, this.field_146294_l / 2 - 100 - 2, this.field_146295_m / 2 + 40, 100, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnDone);
        this.btnCancel = new GuiButton(0, this.field_146294_l / 2 + 2, this.field_146295_m / 2 + 40, 100, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnCancel);
        this.textField = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, (this.field_146294_l - 200) / 2, this.field_146295_m / 2 - 81, 200, 20);
        this.textField.func_146195_b(true);
        this.textField.func_146180_a("");
        this.scroller.removeAllContent();
        int typeCount = 0;
        for (MarkerType type : MarkerRegistry.getValues()) {
            if (type.isTechnical()) continue;
            ++typeCount;
        }
        int allTypesWidth = typeCount * 35 - 1;
        int scrollerWidth = Math.min(allTypesWidth, 240);
        this.scroller.setViewportSize(scrollerWidth, 34);
        this.scroller.setGuiCoords((this.field_146294_l - scrollerWidth) / 2, this.field_146295_m / 2 - 25);
        this.typeRadioGroup = new ToggleGroup();
        this.typeRadioGroup.addListener((? extends B button) -> {
            this.selectedType = button.getMarkerType();
            for (IMarkerTypeSelectListener listener : this.listeners) {
                listener.onSelectMarkerType(button.getMarkerType());
            }
        });
        int contentX = 0;
        for (MarkerType markerType : MarkerRegistry.getValues()) {
            if (markerType.isTechnical()) continue;
            GuiMarkerInList markerGui = new GuiMarkerInList(markerType);
            this.typeRadioGroup.addButton(markerGui);
            if (this.selectedType.equals(markerType)) {
                this.typeRadioGroup.setSelectedButton(markerGui);
            }
            this.scroller.addContent(markerGui).setRelativeX(contentX);
            contentX += 35;
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        super.func_73864_a(par1, par2, par3);
        this.textField.func_146192_a(par1, par2, par3);
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        this.textField.func_146201_a(par1, par2);
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.btnDone) {
            AtlasAPI.markers.putMarker(this.world, true, this.atlasID, this.selectedType.getRegistryName().toString(), this.textField.func_146179_b(), this.x, this.z);
            Log.info("Put marker in Atlas #%d \"%s\" at (%d, %d)", this.atlasID, this.textField.func_146179_b(), this.x, this.z);
            this.close();
        } else if (button == this.btnCancel) {
            this.close();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        this.func_146276_q_();
        this.drawCenteredString(I18n.func_135052_a((String)"gui.antiqueatlas.marker.label", (Object[])new Object[0]), this.field_146295_m / 2 - 97, 0xFFFFFF, true);
        this.textField.func_146194_f();
        this.drawCenteredString(I18n.func_135052_a((String)"gui.antiqueatlas.marker.type", (Object[])new Object[0]), this.field_146295_m / 2 - 44, 0xFFFFFF, true);
        this.func_73733_a(this.scroller.getGuiX() - 4, this.scroller.getGuiY() - 4, this.scroller.getGuiX() + this.scroller.getWidth() + 4, this.scroller.getGuiY() + this.scroller.getHeight() + 4, -2012213232, -1727000560);
        super.func_73863_a(mouseX, mouseY, partialTick);
    }

    static interface IMarkerTypeSelectListener {
        public void onSelectMarkerType(MarkerType var1);
    }
}

