/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client;

import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.core.Tile;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.SaveData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BiomeTextureMap
extends SaveData {
    private static final BiomeTextureMap INSTANCE = new BiomeTextureMap();
    final Map<Integer, TextureSet> textureMap = new HashMap<Integer, TextureSet>();
    public static final TextureSet defaultTexture = TextureSet.PLAINS;

    public static BiomeTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(int biomeID, TextureSet textureSet) {
        if (textureSet == null) {
            if (this.textureMap.remove(biomeID) != null) {
                Log.warn("Removing old texture for biome %s", biomeID);
                if (biomeID >= 0 && biomeID < 256) {
                    this.markDirty();
                }
            }
            return;
        }
        TextureSet previous = this.textureMap.put(biomeID, textureSet);
        if (biomeID >= 0 && biomeID < 256) {
            if (previous == null) {
                this.markDirty();
            } else if (!previous.equals(textureSet)) {
                Log.warn("Overwriting texture set for biome %d", biomeID);
                this.markDirty();
            }
        }
    }

    private void autoRegister(int biomeID) {
        if (biomeID < 0 || biomeID >= 256) {
            Log.warn("Biome ID %d is out of range. Auto-registering default texture set", biomeID);
            this.setTexture(biomeID, defaultTexture);
            return;
        }
        Biome biome = Biome.func_185357_a((int)biomeID);
        if (biome == null) {
            Log.warn("Biome ID %d is null. Auto-registering default texture set", biomeID);
            this.setTexture(biomeID, defaultTexture);
            return;
        }
        List<BiomeDictionary.Type> types = Arrays.asList(BiomeDictionary.getTypesForBiome((Biome)biome));
        if (types.contains(BiomeDictionary.Type.SWAMP)) {
            if (types.contains(BiomeDictionary.Type.HILLS)) {
                this.setTexture(biomeID, TextureSet.SWAMP_HILLS);
            } else {
                this.setTexture(biomeID, TextureSet.SWAMP);
            }
        } else if (types.contains(BiomeDictionary.Type.WATER) || types.contains(BiomeDictionary.Type.RIVER)) {
            if (types.contains(BiomeDictionary.Type.FOREST) || types.contains(BiomeDictionary.Type.JUNGLE)) {
                if (types.contains(BiomeDictionary.Type.HILLS)) {
                    this.setTexture(biomeID, TextureSet.SWAMP_HILLS);
                } else {
                    this.setTexture(biomeID, TextureSet.SWAMP);
                }
            } else if (types.contains(BiomeDictionary.Type.SNOWY)) {
                this.setTexture(biomeID, TextureSet.ICE);
            } else {
                this.setTexture(biomeID, TextureSet.WATER);
            }
        } else if (types.contains(BiomeDictionary.Type.BEACH)) {
            if (types.contains(BiomeDictionary.Type.MOUNTAIN)) {
                this.setTexture(biomeID, TextureSet.ROCK_SHORE);
            } else {
                this.setTexture(biomeID, TextureSet.SHORE);
            }
        } else if (types.contains(BiomeDictionary.Type.JUNGLE)) {
            if (types.contains(BiomeDictionary.Type.MOUNTAIN)) {
                this.setTexture(biomeID, TextureSet.JUNGLE_CLIFFS);
            } else if (types.contains(BiomeDictionary.Type.HILLS)) {
                this.setTexture(biomeID, TextureSet.JUNGLE_HILLS);
            } else {
                this.setTexture(biomeID, TextureSet.JUNGLE);
            }
        } else if (types.contains(BiomeDictionary.Type.SAVANNA)) {
            if (types.contains(BiomeDictionary.Type.MOUNTAIN) || types.contains(BiomeDictionary.Type.HILLS)) {
                this.setTexture(biomeID, TextureSet.SAVANNA_CLIFFS);
            } else {
                this.setTexture(biomeID, TextureSet.SAVANNA);
            }
        } else if (types.contains(BiomeDictionary.Type.CONIFEROUS)) {
            if (types.contains(BiomeDictionary.Type.MOUNTAIN) || types.contains(BiomeDictionary.Type.HILLS)) {
                this.setTexture(biomeID, TextureSet.PINES_HILLS);
            } else {
                this.setTexture(biomeID, TextureSet.PINES);
            }
        } else if (types.contains(BiomeDictionary.Type.MESA)) {
            if (types.contains(BiomeDictionary.Type.FOREST)) {
                this.setTexture(biomeID, TextureSet.PLATEAU_MESA_TREES);
            } else {
                this.setTexture(biomeID, TextureSet.PLATEAU_MESA);
            }
        } else if (types.contains(BiomeDictionary.Type.FOREST)) {
            if (types.contains(BiomeDictionary.Type.SNOWY)) {
                if (types.contains(BiomeDictionary.Type.HILLS)) {
                    this.setTexture(biomeID, TextureSet.SNOW_PINES_HILLS);
                } else {
                    this.setTexture(biomeID, TextureSet.SNOW_PINES);
                }
            } else if (types.contains(BiomeDictionary.Type.SPARSE)) {
                if (types.contains(BiomeDictionary.Type.HILLS)) {
                    this.setTexture(biomeID, TextureSet.SPARSE_FOREST_HILLS);
                } else {
                    this.setTexture(biomeID, TextureSet.SPARSE_FOREST);
                }
            } else if (types.contains(BiomeDictionary.Type.DENSE)) {
                if (types.contains(BiomeDictionary.Type.HILLS)) {
                    this.setTexture(biomeID, TextureSet.DENSE_FOREST_HILLS);
                } else {
                    this.setTexture(biomeID, TextureSet.DENSE_FOREST);
                }
            } else if (types.contains(BiomeDictionary.Type.HILLS)) {
                this.setTexture(biomeID, TextureSet.FOREST_HILLS);
            } else {
                this.setTexture(biomeID, TextureSet.FOREST);
            }
        } else if (types.contains(BiomeDictionary.Type.PLAINS) || types.contains(BiomeDictionary.Type.WASTELAND)) {
            if (types.contains(BiomeDictionary.Type.SNOWY) || types.contains(BiomeDictionary.Type.COLD)) {
                if (types.contains(BiomeDictionary.Type.MOUNTAIN)) {
                    this.setTexture(biomeID, TextureSet.MOUNTAINS_SNOW_CAPS);
                } else if (types.contains(BiomeDictionary.Type.HILLS)) {
                    this.setTexture(biomeID, TextureSet.SNOW_HILLS);
                } else {
                    this.setTexture(biomeID, TextureSet.SNOW);
                }
            } else if (types.contains(BiomeDictionary.Type.HILLS) || types.contains(BiomeDictionary.Type.MOUNTAIN)) {
                this.setTexture(biomeID, TextureSet.DESERT_HILLS);
            } else {
                this.setTexture(biomeID, TextureSet.DESERT);
            }
        } else if (types.contains(BiomeDictionary.Type.MOUNTAIN)) {
            this.setTexture(biomeID, TextureSet.MOUNTAINS_NAKED);
        } else if (types.contains(BiomeDictionary.Type.HILLS)) {
            if (types.contains(BiomeDictionary.Type.SNOWY) || types.contains(BiomeDictionary.Type.COLD)) {
                this.setTexture(biomeID, TextureSet.SNOW_HILLS);
            } else if (types.contains(BiomeDictionary.Type.SANDY)) {
                this.setTexture(biomeID, TextureSet.DESERT_HILLS);
            } else {
                this.setTexture(biomeID, TextureSet.HILLS);
            }
        } else {
            this.setTexture(biomeID, defaultTexture);
        }
        Log.info("Auto-registered standard texture set for biome %d", biomeID);
    }

    private void checkRegistration(int biomeID) {
        if (!this.isRegistered(biomeID)) {
            this.autoRegister(biomeID);
            this.markDirty();
        }
    }

    public boolean isRegistered(int biomeID) {
        return this.textureMap.containsKey(biomeID);
    }

    public TextureSet getTextureSet(Tile tile) {
        if (tile == null) {
            return defaultTexture;
        }
        this.checkRegistration(tile.biomeID);
        return this.textureMap.get(tile.biomeID);
    }

    public ResourceLocation getTexture(Tile tile) {
        TextureSet set = this.getTextureSet(tile);
        int i = MathHelper.func_76141_d((float)((float)tile.getVariationNumber() / 32767.0f * (float)set.textures.length));
        return set.textures[i];
    }

    public List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(this.textureMap.size());
        for (Map.Entry<Integer, TextureSet> entry : this.textureMap.entrySet()) {
            list.addAll(Arrays.asList(entry.getValue().textures));
        }
        return list;
    }
}

